/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters.TDSChunkingFiles;

import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkHeader;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.MaxChunkIDs;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;

abstract class ChunkerClass
implements MaxChunkIDs {
    static boolean DEBUG_LIGHT = false;
    static boolean DEBUG = false;
    static boolean DEBUG_SEVERE = false;
    public DataInput myIn;
    private ChunkHeader header;

    public ChunkerClass(DataInput dataInput) {
        this.myIn = dataInput;
    }

    public ChunkerClass(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        this.myIn = dataInput;
        this.header = chunkHeader;
        this.initializeVariables();
        this.chunk();
    }

    protected void initializeVariables() throws IOException {
    }

    protected void readChunk(ChunkHeader chunkHeader) throws IOException {
        chunkHeader.type = this.myIn.readUnsignedShort();
        chunkHeader.length = this.myIn.readInt();
        this.header.length -= 6;
        chunkHeader.length -= 6;
    }

    protected void skipSize(int n) throws IOException {
        while (n > 0) {
            int n2 = n;
            if ((n -= this.myIn.skipBytes(n)) < n2) continue;
            throw new IOException("Unable to skip bits in InputStream");
        }
    }

    public void chunk() throws IOException {
        try {
            if (DEBUG_LIGHT) {
                System.out.println("Reading ChunkHeader len=" + this.header.length);
            }
            ChunkHeader chunkHeader = new ChunkHeader();
            while (this.header.length > 0) {
                this.readChunk(chunkHeader);
                if (DEBUG) {
                    System.out.println("Begin ID#:" + Integer.toHexString(chunkHeader.type) + " len=" + chunkHeader.length + " parentID#=" + Integer.toHexString(this.header.type));
                }
                if (DEBUG) {
                    System.out.println("Header.len=" + this.header.length + " chunk.lenth=" + chunkHeader.length);
                }
                if (!this.processChildChunk(new ChunkHeader(chunkHeader))) {
                    if (DEBUG) {
                        System.out.println("*****UNKNOWN TYPE*****" + Integer.toHexString(chunkHeader.type) + "*** for parent " + Integer.toHexString(this.header.type));
                    }
                    if (DEBUG_SEVERE) {
                        throw new IOException("Unknown type:" + Integer.toHexString(chunkHeader.type) + ": in readFile" + "for parent " + Integer.toHexString(this.header.type));
                    }
                    this.skipSize(chunkHeader.length);
                }
                this.header.length -= chunkHeader.length;
                if (this.header.length < 0) {
                    throw new IOException("Header length doesn't match up: End ID#:" + Integer.toHexString(chunkHeader.type) + " len left to read=" + this.header.length + " parentID#=" + Integer.toHexString(this.header.type));
                }
                if (!DEBUG) continue;
                System.out.println("End ID#:" + Integer.toHexString(chunkHeader.type));
            }
        }
        catch (IOException iOException) {
            if (DEBUG) {
                System.out.println("HeaderID=" + Integer.toHexString(this.header.type) + " len=" + this.header.length);
            }
            throw iOException;
        }
    }

    protected abstract boolean processChildChunk(ChunkHeader var1) throws IOException;

    protected final String readcStr() throws IOException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(16);
        byte by = this.myIn.readByte();
        while (by != 0) {
            arrayList.add(by);
            by = this.myIn.readByte();
        }
        byte[] byArray = new byte[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            byArray[i] = (Byte)arrayList.get(i);
        }
        String string = new String(byArray, "US-ASCII");
        return string;
    }

    protected final String readcStrAndDecrHeader() throws IOException {
        String string = this.readcStr();
        this.header.length -= string.length() + 1;
        return string;
    }

    protected final String readcStr(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.myIn.readFully(byArray);
        String string = new String(byArray, 0, n - 1);
        return string;
    }

    protected void setHeader(ChunkHeader chunkHeader) {
        this.header = chunkHeader;
    }

    protected void decrHeaderLen(int n) {
        this.header.length -= n;
    }
}

