/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters.TDSChunkingFiles;

import com.jme.renderer.ColorRGBA;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkHeader;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkerClass;
import java.io.DataInput;
import java.io.IOException;

class FogChunk
extends ChunkerClass {
    float nearPlane;
    float nearDensity;
    float farPlane;
    float farDensity;
    private boolean useBackGround;
    private ColorRGBA background;

    public FogChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected void initializeVariables() throws IOException {
        this.nearPlane = this.myIn.readFloat();
        this.nearDensity = this.myIn.readFloat();
        this.farPlane = this.myIn.readFloat();
        this.farDensity = this.myIn.readFloat();
        this.decrHeaderLen(16);
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Near plane:" + this.nearPlane + " Near Density:" + this.nearDensity + " Far Plane:" + this.farPlane + " Far Density:" + this.farDensity);
        }
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 16: {
                this.background = new ColorRGBA(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), 1.0f);
                if (DEBUG) {
                    System.out.println("Background Color:" + this.background);
                }
                return true;
            }
            case 8720: {
                this.useBackGround = true;
                if (DEBUG) {
                    System.out.println("use background true");
                }
                return true;
            }
        }
        return false;
    }
}

