/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters.TDSChunkingFiles;

import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkHeader;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkerClass;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.KeyframeInfoChunk;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

class KeyframeChunk
extends ChunkerClass {
    int animationLen;
    int begin;
    int end;
    HashMap objKeyframes;
    ArrayList cameraKeyframes;
    ArrayList lightKeyframes;

    public KeyframeChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected void initializeVariables() throws IOException {
        this.objKeyframes = new HashMap();
        this.cameraKeyframes = new ArrayList();
        this.lightKeyframes = new ArrayList();
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 45066: {
                this.readKeyframeHeader();
                return true;
            }
            case 45064: {
                this.readSegment();
                return true;
            }
            case 45065: {
                this.readCurTime();
                return true;
            }
            case 28673: {
                this.skipSize(chunkHeader.length);
                return true;
            }
            case 45058: {
                KeyframeInfoChunk keyframeInfoChunk = new KeyframeInfoChunk(this.myIn, chunkHeader);
                this.objKeyframes.put(keyframeInfoChunk.name, keyframeInfoChunk);
                return true;
            }
            case 45059: 
            case 45060: {
                this.cameraKeyframes.add(new KeyframeInfoChunk(this.myIn, chunkHeader));
                return true;
            }
            case 45057: 
            case 45061: 
            case 45062: 
            case 45063: {
                this.lightKeyframes.add(new KeyframeInfoChunk(this.myIn, chunkHeader));
                return true;
            }
        }
        return false;
    }

    private void readSegment() throws IOException {
        this.begin = this.myIn.readInt();
        this.end = this.myIn.readInt();
        if (DEBUG_LIGHT) {
            System.out.println("Reading segment");
        }
        if (DEBUG) {
            System.out.println("Segment begins at " + this.begin + " and ends at " + this.end);
        }
    }

    private void readCurTime() throws IOException {
        int n = this.myIn.readInt();
        if (DEBUG) {
            System.out.println("Current frame is " + n);
        }
    }

    private void readKeyframeHeader() throws IOException {
        if (DEBUG_LIGHT) {
            System.out.println("Reading keyframeHeader");
        }
        short s = this.myIn.readShort();
        String string = this.readcStr();
        this.animationLen = this.myIn.readInt();
        if (DEBUG) {
            System.out.println("Revision #" + s + " with filename " + string + " and animation len " + this.animationLen);
        }
    }
}

