/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters.TDSChunkingFiles;

import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkHeader;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkerClass;
import java.io.DataInput;
import java.io.IOException;

class TextureChunk
extends ChunkerClass {
    float percent;
    String texName;
    int flags;
    float textureBlur;
    float bumpPercentage;
    float vScale;
    float uScale;

    public TextureChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 48: {
                this.percent = (float)this.myIn.readShort() / 100.0f;
                if (DEBUG) {
                    System.out.println("Texture percent:" + this.percent);
                }
                return true;
            }
            case 41728: {
                this.texName = this.readcStr(chunkHeader.length);
                return true;
            }
            case 41809: {
                this.flags = this.myIn.readUnsignedShort();
                return true;
            }
            case 41811: {
                this.textureBlur = this.myIn.readFloat();
                return true;
            }
            case 41554: {
                this.bumpPercentage = (float)this.myIn.readShort() / 100.0f;
                if (DEBUG) {
                    System.out.println("Texture bump percent:" + this.bumpPercentage);
                }
                return true;
            }
            case 41812: {
                this.vScale = this.myIn.readFloat();
                return true;
            }
            case 41814: {
                this.uScale = this.myIn.readFloat();
                return true;
            }
        }
        return false;
    }
}

