/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser;

import com.jme.animation.SpatialTransformer;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.image.Texture;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.lod.AreaClodMesh;
import com.jme.scene.lod.ClodMesh;
import com.jme.scene.lod.CollapseRecord;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.JointMesh;
import com.jmex.model.XMLparser.LoaderNode;
import com.jmex.model.XMLparser.XMLloadable;
import com.jmex.model.animation.JointController;
import com.jmex.model.animation.KeyframeController;
import com.jmex.model.animation.PointInTime;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.TerrainPage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmeBinaryWriter {
    private DataOutputStream myOut;
    private static final boolean DEBUG = false;
    private IdentityHashMap<Object, String> sharedObjects = new IdentityHashMap(20);
    private IdentityHashMap<Object, String> entireScene = new IdentityHashMap(256);
    private static final Quaternion DEFAULT_ROTATION = new Quaternion();
    private static final Vector3f DEFAULT_TRANSLATION = new Vector3f();
    private static final Vector3f DEFAULT_SCALE = new Vector3f(1.0f, 1.0f, 1.0f);
    private HashMap<String, Object> properties = new HashMap();
    private int totalShared = 0;

    public void writeScene(Node node, OutputStream outputStream) throws IOException {
        this.myOut = new DataOutputStream(outputStream);
        this.sharedObjects.clear();
        this.entireScene.clear();
        this.totalShared = 0;
        this.writeHeader();
        this.findDuplicates((Spatial)node);
        this.entireScene.clear();
        this.writeSpatial((Spatial)node);
        this.writeClosing();
        this.myOut.close();
    }

    private void findDuplicates(Spatial spatial) {
        if (spatial == null) {
            return;
        }
        if (this.entireScene.containsKey(spatial)) {
            if (!this.sharedObjects.containsKey(spatial)) {
                this.sharedObjects.put(spatial, "sharedSpatial" + this.totalShared++);
            }
            return;
        }
        this.entireScene.put(spatial, null);
        this.evaluateSpatialChildrenDuplicates(spatial);
        if ((spatial.getType() & 1) == 0) {
            return;
        }
        Node node = (Node)spatial;
        for (int i = node.getQuantity() - 1; i >= 0; --i) {
            this.findDuplicates(node.getChild(i));
        }
    }

    public void writeScene(Spatial spatial, OutputStream outputStream) throws IOException {
        if (spatial instanceof Node) {
            this.writeScene((Node)spatial, outputStream);
        } else if (spatial instanceof Geometry) {
            this.writeScene((Geometry)spatial, outputStream);
        }
    }

    private void evaluateSpatialChildrenDuplicates(Spatial spatial) {
        Controller controller;
        int n;
        if (spatial == null) {
            return;
        }
        for (n = 0; n < spatial.getControllers().size(); ++n) {
            controller = spatial.getController(n);
            if (controller == null) continue;
            if (this.entireScene.containsKey(controller)) {
                if (this.sharedObjects.containsKey(controller)) continue;
                this.sharedObjects.put(controller, "sharedController" + this.totalShared++);
                continue;
            }
            this.entireScene.put(controller, null);
            if (!(controller instanceof SpatialTransformer)) continue;
            for (int i = 0; i < ((SpatialTransformer)controller).toChange.length; ++i) {
                this.findDuplicateObjects(((SpatialTransformer)controller).toChange[i]);
            }
        }
        for (n = 0; n < 17; ++n) {
            controller = spatial.getRenderState(n);
            if (controller == null) continue;
            if (this.entireScene.containsKey(controller)) {
                if (this.sharedObjects.containsKey(controller)) continue;
                this.sharedObjects.put(controller, "sharedRenderState" + this.totalShared++);
                continue;
            }
            this.entireScene.put(controller, null);
        }
    }

    private void findDuplicateObjects(Object object) {
        if (object instanceof Spatial) {
            this.findDuplicates((Spatial)object);
        }
    }

    public void writeScene(Geometry geometry, OutputStream outputStream) throws IOException {
        this.totalShared = 0;
        this.myOut = new DataOutputStream(outputStream);
        this.sharedObjects.clear();
        this.entireScene.clear();
        this.writeHeader();
        this.findDuplicates((Spatial)geometry);
        this.entireScene.clear();
        this.writeSpatial((Spatial)geometry);
        this.writeClosing();
        this.myOut.close();
    }

    private void writeNode(Node node) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(node)) {
            hashMap.put("sharedident", this.sharedObjects.get(node));
        }
        this.putSpatialAtts((Spatial)node, hashMap);
        this.writeTag("node", hashMap);
        this.writeChildren(node);
        this.writeSpatialChildren((Spatial)node);
        this.writeEndTag("node");
    }

    private void writeTerrainPage(TerrainPage terrainPage) throws IOException {
        if (terrainPage == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(terrainPage)) {
            hashMap.put("sharedident", this.sharedObjects.get(terrainPage));
        }
        this.putSpatialAtts((Spatial)terrainPage, hashMap);
        hashMap.put("offset", terrainPage.getOffset());
        hashMap.put("totsize", new Integer(terrainPage.getTotalSize()));
        hashMap.put("size", new Integer(terrainPage.getSize()));
        hashMap.put("stepscale", terrainPage.getStepScale());
        hashMap.put("offamnt", new Float(terrainPage.getOffsetAmount()));
        this.writeTag("terrainpage", hashMap);
        this.writeChildren((Node)terrainPage);
        this.writeSpatialChildren((Spatial)terrainPage);
        this.writeEndTag("terrainpage");
    }

    private void writeSharedObject(Object object) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("ident", this.sharedObjects.get(object));
        this.writeTag("repeatobject", hashMap);
        this.writeEndTag("repeatobject");
    }

    private void writeChildren(Node node) throws IOException {
        for (int i = 0; i < node.getQuantity(); ++i) {
            this.writeSpatial(node.getChild(i));
        }
    }

    private void writeSpatial(Spatial spatial) throws IOException {
        if (this.sharedObjects.containsKey(spatial)) {
            if (this.entireScene.containsKey(spatial)) {
                this.writeSharedObject(spatial);
                return;
            }
            this.entireScene.put(spatial, null);
        }
        if (spatial instanceof XMLloadable) {
            this.writeXMLloadable((XMLloadable)spatial);
        } else if (spatial instanceof LoaderNode) {
            this.writeLoaderNode((LoaderNode)spatial);
        } else if (spatial instanceof JointMesh) {
            this.writeJointMesh((JointMesh)spatial);
        } else if (spatial instanceof TerrainPage) {
            this.writeTerrainPage((TerrainPage)spatial);
        } else if (spatial instanceof Node) {
            this.writeNode((Node)spatial);
        } else if (spatial instanceof TerrainBlock) {
            this.writeTerrainBlock((TerrainBlock)spatial);
        } else if (spatial instanceof AreaClodMesh) {
            this.writeAreaClod((AreaClodMesh)spatial);
        } else if (spatial instanceof ClodMesh) {
            this.writeClod((ClodMesh)spatial);
        } else if (spatial instanceof TriMesh) {
            this.writeMesh((TriMesh)spatial);
        }
    }

    private void writeLoaderNode(LoaderNode loaderNode) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey((Object)loaderNode)) {
            hashMap.put("sharedident", this.sharedObjects.get((Object)loaderNode));
        }
        hashMap.put("type", loaderNode.type);
        if (loaderNode.filePath != null) {
            hashMap.put("file", loaderNode.filePath);
        } else if (loaderNode.urlPath != null) {
            hashMap.put("url", loaderNode.urlPath);
        } else if (loaderNode.classLoaderPath != null) {
            hashMap.put("classloader", loaderNode.classLoaderPath);
        }
        this.writeTag("jmefile", hashMap);
        this.writeEndTag("jmefile");
    }

    private void writeTerrainBlock(TerrainBlock terrainBlock) throws IOException {
        if (terrainBlock == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(terrainBlock)) {
            hashMap.put("sharedident", this.sharedObjects.get(terrainBlock));
        }
        this.putSpatialAtts((Spatial)terrainBlock, hashMap);
        hashMap.put("trisppix", new Float(terrainBlock.getTrisPerPixel()));
        hashMap.put("disttol", new Float(terrainBlock.getDistanceTolerance()));
        hashMap.put("tbsize", new Integer(terrainBlock.getSize()));
        hashMap.put("totsize", new Integer(terrainBlock.getTotalSize()));
        hashMap.put("step", terrainBlock.getStepScale());
        hashMap.put("isclod", new Boolean(terrainBlock.isUseClod()));
        hashMap.put("offset", terrainBlock.getOffset());
        hashMap.put("offamnt", new Float(terrainBlock.getOffsetAmount()));
        hashMap.put("hmap", terrainBlock.getHeightMap());
        this.writeTag("terrainblock", hashMap);
        this.writeTriMeshTags((TriMesh)terrainBlock);
        this.writeRecords(terrainBlock.getRecords());
        this.writeSpatialChildren((Spatial)terrainBlock);
        this.writeEndTag("terrainblock");
    }

    private void writeAreaClod(AreaClodMesh areaClodMesh) throws IOException {
        if (areaClodMesh == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(areaClodMesh)) {
            hashMap.put("sharedident", this.sharedObjects.get(areaClodMesh));
        }
        this.putSpatialAtts((Spatial)areaClodMesh, hashMap);
        hashMap.put("trisppix", new Float(areaClodMesh.getTrisPerPixel()));
        hashMap.put("disttol", new Float(areaClodMesh.getDistanceTolerance()));
        this.writeTag("areaclod", hashMap);
        this.writeTriMeshTags((TriMesh)areaClodMesh);
        this.writeRecords(areaClodMesh.getRecords());
        this.writeSpatialChildren((Spatial)areaClodMesh);
        this.writeEndTag("areaclod");
    }

    private void writeClod(ClodMesh clodMesh) throws IOException {
        if (clodMesh == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(clodMesh)) {
            hashMap.put("sharedident", this.sharedObjects.get(clodMesh));
        }
        this.putSpatialAtts((Spatial)clodMesh, hashMap);
        this.writeTag("clod", hashMap);
        this.writeTriMeshTags((TriMesh)clodMesh);
        this.writeRecords(clodMesh.getRecords());
        this.writeSpatialChildren((Spatial)clodMesh);
        this.writeEndTag("clod");
    }

    private void writeRecords(CollapseRecord[] collapseRecordArray) throws IOException {
        if (collapseRecordArray == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        hashMap.put("numrec", new Integer(collapseRecordArray.length));
        this.writeTag("clodrecords", hashMap);
        for (int i = 0; i < collapseRecordArray.length; ++i) {
            hashMap.clear();
            hashMap.put("index", new Integer(i));
            hashMap.put("numi", new Integer(collapseRecordArray[i].numbIndices));
            hashMap.put("numt", new Integer(collapseRecordArray[i].numbTriangles));
            hashMap.put("numv", new Integer(collapseRecordArray[i].numbVerts));
            hashMap.put("vkeep", new Integer(collapseRecordArray[i].vertToKeep));
            hashMap.put("vthrow", new Integer(collapseRecordArray[i].vertToThrow));
            if (collapseRecordArray[i].indices != null) {
                hashMap.put("indexary", collapseRecordArray[i].indices);
            }
            this.writeTag("crecord", hashMap);
            this.writeEndTag("crecord");
        }
        this.writeEndTag("clodrecords");
    }

    private void writeMesh(TriMesh triMesh) throws IOException {
        if (triMesh == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(triMesh)) {
            hashMap.put("sharedident", this.sharedObjects.get(triMesh));
        }
        this.putSpatialAtts((Spatial)triMesh, hashMap);
        this.writeTag("mesh", hashMap);
        if (triMesh.getBatchCount() == 1) {
            this.writeTriMeshTags(triMesh);
        } else {
            for (int i = 0; i < triMesh.getBatchCount(); ++i) {
                this.writeTag("batch" + i, hashMap);
                this.writeTriMeshTags(triMesh);
                for (int j = 0; j < 17; ++j) {
                    if (triMesh.getBatch(i).getRenderState(j) == null) continue;
                    this.writeRenderState(triMesh.getBatch(i).getRenderState(j));
                }
                this.writeEndTag("batch" + i);
            }
        }
        this.writeSpatialChildren((Spatial)triMesh);
        this.writeEndTag("mesh");
    }

    private void writeJointMesh(JointMesh jointMesh) throws IOException {
        int n;
        if ("astrimesh".equals(this.properties.get("jointmesh"))) {
            this.writeMesh(jointMesh);
            return;
        }
        for (n = 0; n < jointMesh.jointIndex.length && jointMesh.jointIndex[n] == -1; ++n) {
        }
        if (n == jointMesh.jointIndex.length) {
            this.writeMesh(jointMesh);
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey((Object)jointMesh)) {
            hashMap.put("sharedident", this.sharedObjects.get((Object)jointMesh));
        }
        this.putSpatialAtts((Spatial)jointMesh, hashMap);
        this.writeTag("jointmesh", hashMap);
        this.writeJointMeshTags(jointMesh);
        this.writeSpatialChildren((Spatial)jointMesh);
        this.writeEndTag("jointmesh");
    }

    private void writeJointMeshTags(JointMesh jointMesh) throws IOException {
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        hashMap.clear();
        hashMap.put("data", jointMesh.jointIndex);
        this.writeTag("jointindex", hashMap);
        this.writeEndTag("jointindex");
        hashMap.clear();
        hashMap.put("data", jointMesh.originalVertex);
        this.writeTag("origvertex", hashMap);
        this.writeEndTag("origvertex");
        hashMap.clear();
        hashMap.put("data", jointMesh.originalNormal);
        this.writeTag("orignormal", hashMap);
        this.writeEndTag("orignormal");
        this.writeTriMeshTags(jointMesh);
    }

    private void writeXMLloadable(XMLloadable xMLloadable) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.sharedObjects.containsKey(xMLloadable)) {
            hashMap.put("sharedident", this.sharedObjects.get(xMLloadable));
        }
        hashMap.put("class", xMLloadable.getClass().getName());
        if (xMLloadable instanceof Spatial) {
            this.putSpatialAtts((Spatial)xMLloadable, hashMap);
        }
        hashMap.put("args", xMLloadable.writeToXML());
        this.writeTag("xmlloadable", hashMap);
        if (xMLloadable instanceof Spatial) {
            this.writeSpatialChildren((Spatial)xMLloadable);
        }
        if (xMLloadable instanceof Node) {
            this.writeChildren((Node)xMLloadable);
        }
        this.writeEndTag("xmlloadable");
    }

    private void writeSpatialChildren(Spatial spatial) throws IOException {
        this.writeRenderStates(spatial);
        this.writeControllers(spatial);
    }

    private void writeControllers(Spatial spatial) throws IOException {
        ArrayList arrayList = spatial.getControllers();
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Controller controller = (Controller)arrayList.get(i);
            if (this.sharedObjects.containsKey(controller)) {
                if (this.entireScene.containsKey(controller)) {
                    this.writeSharedObject(controller);
                    return;
                }
                this.entireScene.put(controller, null);
            }
            if (controller instanceof JointController) {
                this.writeJointController((JointController)controller);
                continue;
            }
            if (controller instanceof SpatialTransformer) {
                this.writeSpatialTransformer((SpatialTransformer)controller);
                continue;
            }
            if (controller instanceof KeyframeController) {
                this.writeKeyframeController((KeyframeController)controller);
                continue;
            }
            if (!(controller instanceof XMLloadable)) continue;
            this.writeXMLloadable((XMLloadable)controller);
        }
    }

    private void addControllerBaseAtts(Controller controller, HashMap<String, Object> hashMap) {
        hashMap.put("rptype", new Integer(controller.getRepeatType()));
        hashMap.put("speed", new Float(controller.getSpeed()));
    }

    private void writeSpatialTransformer(SpatialTransformer spatialTransformer) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(spatialTransformer)) {
            hashMap.put("sharedident", this.sharedObjects.get(spatialTransformer));
        }
        hashMap.put("numobjects", new Integer(spatialTransformer.getNumObjects()));
        this.writeTag("spatialtransformer", hashMap);
        for (int i = 0; i < spatialTransformer.toChange.length; ++i) {
            hashMap.clear();
            hashMap.put("obnum", new Integer(i));
            hashMap.put("parnum", new Integer(spatialTransformer.parentIndexes[i]));
            this.writeTag("stobj", hashMap);
            this.writeObject(spatialTransformer.toChange[i]);
            this.writeEndTag("stobj");
        }
        ArrayList arrayList = spatialTransformer.keyframes;
        for (int i = 0; i < arrayList.size(); ++i) {
            this.writeSpatialTransformerPointInTime((SpatialTransformer.PointInTime)arrayList.get(i));
        }
        this.writeEndTag("spatialtransformer");
    }

    private void writeObject(Object object) throws IOException {
        if (object instanceof Spatial) {
            this.writeSpatial((Spatial)object);
        }
    }

    private void writeSpatialTransformerPointInTime(SpatialTransformer.PointInTime pointInTime) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        hashMap.put("time", new Float(pointInTime.time));
        this.writeTag("spatialpointtime", hashMap);
        BitSet bitSet = pointInTime.usedScale;
        int[] nArray = new int[bitSet.cardinality()];
        Vector3f[] vector3fArray = new Vector3f[bitSet.cardinality()];
        int n = bitSet.nextSetBit(0);
        int n2 = 0;
        while (n >= 0) {
            nArray[n2] = n;
            vector3fArray[n2] = new Vector3f();
            pointInTime.look[n].getScale(vector3fArray[n2]);
            n = bitSet.nextSetBit(n + 1);
            ++n2;
        }
        hashMap.clear();
        hashMap.put("index", nArray);
        hashMap.put("scalevalues", vector3fArray);
        this.writeTag("sptscale", hashMap);
        this.writeEndTag("sptscale");
        bitSet = pointInTime.usedRot;
        int[] nArray2 = new int[bitSet.cardinality()];
        Quaternion[] quaternionArray = new Quaternion[bitSet.cardinality()];
        int n3 = bitSet.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            nArray2[n4] = n3;
            quaternionArray[n4] = new Quaternion();
            pointInTime.look[n3].getRotation(quaternionArray[n4]);
            n3 = bitSet.nextSetBit(n3 + 1);
            ++n4;
        }
        hashMap.clear();
        hashMap.put("index", nArray2);
        hashMap.put("rotvalues", quaternionArray);
        this.writeTag("sptrot", hashMap);
        this.writeEndTag("sptrot");
        bitSet = pointInTime.usedTrans;
        int[] nArray3 = new int[bitSet.cardinality()];
        Vector3f[] vector3fArray2 = new Vector3f[bitSet.cardinality()];
        int n5 = bitSet.nextSetBit(0);
        int n6 = 0;
        while (n5 >= 0) {
            nArray3[n6] = n5;
            vector3fArray2[n6] = new Vector3f();
            pointInTime.look[n5].getTranslation(vector3fArray2[n6]);
            n5 = bitSet.nextSetBit(n5 + 1);
            ++n6;
        }
        hashMap.clear();
        hashMap.put("index", nArray3);
        hashMap.put("transvalues", vector3fArray2);
        this.writeTag("spttrans", hashMap);
        this.writeEndTag("spttrans");
        this.writeEndTag("spatialpointtime");
    }

    private void writeKeyframeController(KeyframeController keyframeController) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        if (this.sharedObjects.containsKey((Object)keyframeController)) {
            hashMap.put("sharedident", this.sharedObjects.get((Object)keyframeController));
        }
        this.writeTag("keyframecontroller", hashMap);
        ArrayList<KeyframeController.PointInTime> arrayList = keyframeController.keyframes;
        for (int i = 0; i < arrayList.size(); ++i) {
            this.writeKeyFramePointInTime(arrayList.get(i));
        }
        this.writeEndTag("keyframecontroller");
    }

    private void writeKeyFramePointInTime(KeyframeController.PointInTime pointInTime) throws IOException {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        hashMap.clear();
        hashMap.put("time", new Float(pointInTime.time));
        this.writeTag("keyframepointintime", hashMap);
        this.writeTriMeshTags(pointInTime.newShape);
        this.writeEndTag("keyframepointintime");
    }

    private void writeTriMeshTags(TriMesh triMesh) throws IOException {
        if (triMesh == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (triMesh.getVertexBuffer(0) != null) {
            if (this.properties.get("q3vert") != null) {
                hashMap.put("q3vert", this.vertsToShorts(BufferUtils.getVector3Array((FloatBuffer)triMesh.getVertexBuffer(0))));
            } else {
                hashMap.put("data", BufferUtils.getVector3Array((FloatBuffer)triMesh.getVertexBuffer(0)));
            }
        }
        this.writeTag("vertex", hashMap);
        this.writeEndTag("vertex");
        hashMap.clear();
        if (triMesh.getNormalBuffer(0) != null) {
            if (this.properties.get("q3norm") != null) {
                hashMap.put("q3norm", this.normsToShorts(BufferUtils.getVector3Array((FloatBuffer)triMesh.getNormalBuffer(0))));
            } else {
                hashMap.put("data", BufferUtils.getVector3Array((FloatBuffer)triMesh.getNormalBuffer(0)));
            }
        }
        this.writeTag("normal", hashMap);
        this.writeEndTag("normal");
        hashMap.clear();
        if (triMesh.getColorBuffer(0) != null) {
            hashMap.put("data", BufferUtils.getColorArray((FloatBuffer)triMesh.getColorBuffer(0)));
        }
        this.writeTag("color", hashMap);
        this.writeEndTag("color");
        hashMap.clear();
        for (int i = 0; i < triMesh.getNumberOfUnits(0); ++i) {
            if (triMesh.getTextureBuffer(0, i) == null) continue;
            if (i != 0) {
                hashMap.put("texindex", new Integer(i));
            }
            hashMap.put("data", BufferUtils.getVector2Array((FloatBuffer)triMesh.getTextureBuffer(0, i)));
            this.writeTag("texturecoords", hashMap);
            this.writeEndTag("texturecoords");
        }
        hashMap.clear();
        if (triMesh.getIndexBuffer(0) != null) {
            hashMap.put("data", BufferUtils.getIntArray((IntBuffer)triMesh.getIndexBuffer(0)));
        }
        this.writeTag("index", hashMap);
        this.writeEndTag("index");
        if (triMesh.getBatch(0).getModelBound() != null) {
            this.writeBounds(triMesh.getBatch(0).getModelBound());
        }
    }

    private void writeBounds(BoundingVolume boundingVolume) throws IOException {
        if (boundingVolume == null) {
            return;
        }
        if (boundingVolume instanceof BoundingBox) {
            this.writeBoundingBox((BoundingBox)boundingVolume);
        } else if (boundingVolume instanceof BoundingSphere) {
            this.writeBoundingSphere((BoundingSphere)boundingVolume);
        } else if (boundingVolume instanceof OrientedBoundingBox) {
            this.writeOBB((OrientedBoundingBox)boundingVolume);
        }
    }

    private void writeOBB(OrientedBoundingBox orientedBoundingBox) throws IOException {
        if (orientedBoundingBox == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.sharedObjects.containsKey(orientedBoundingBox)) {
            hashMap.put("sharedident", this.sharedObjects.get(orientedBoundingBox));
        }
        hashMap.put("center", (String)orientedBoundingBox.getCenter());
        hashMap.put("xaxis", (String)orientedBoundingBox.getXAxis());
        hashMap.put("yaxis", (String)orientedBoundingBox.getYAxis());
        hashMap.put("zaxis", (String)orientedBoundingBox.getZAxis());
        hashMap.put("extent", (String)orientedBoundingBox.getExtent());
        this.writeTag("obb", hashMap);
        this.writeEndTag("obb");
    }

    private void writeBoundingSphere(BoundingSphere boundingSphere) throws IOException {
        if (boundingSphere == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.sharedObjects.containsKey(boundingSphere)) {
            hashMap.put("sharedident", this.sharedObjects.get(boundingSphere));
        }
        hashMap.put("center", boundingSphere.getCenter());
        hashMap.put("radius", new Float(boundingSphere.getRadius()));
        this.writeTag("boundsphere", hashMap);
        this.writeEndTag("boundsphere");
    }

    private void writeBoundingBox(BoundingBox boundingBox) throws IOException {
        if (boundingBox == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.sharedObjects.containsKey(boundingBox)) {
            hashMap.put("sharedident", this.sharedObjects.get(boundingBox));
        }
        hashMap.put("nowcent", (String)boundingBox.getCenter());
        hashMap.put("nowext", (String)new Vector3f(boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent));
        this.writeTag("boundbox", hashMap);
        this.writeEndTag("boundbox");
    }

    private short[] vertsToShorts(Vector3f[] vector3fArray) {
        short[] sArray = new short[vector3fArray.length * 3];
        for (int i = 0; i < vector3fArray.length; ++i) {
            sArray[i * 3 + 0] = (short)(vector3fArray[i].x / 0.015625f);
            sArray[i * 3 + 1] = (short)(vector3fArray[i].y / 0.015625f);
            sArray[i * 3 + 2] = (short)(vector3fArray[i].z / 0.015625f);
        }
        return sArray;
    }

    private byte[] normsToShorts(Vector3f[] vector3fArray) {
        byte[] byArray = new byte[vector3fArray.length * 2];
        for (int i = 0; i < byArray.length; i += 2) {
            byArray[i] = (byte)(57.295776f * FastMath.acos((float)vector3fArray[i / 2].z));
            byArray[i + 1] = (byte)((float)Math.PI / 180 * FastMath.atan((float)(vector3fArray[i / 2].y / vector3fArray[i / 2].x)));
        }
        return byArray;
    }

    private void writeJointController(JointController jointController) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey((Object)jointController)) {
            hashMap.put("sharedident", this.sharedObjects.get((Object)jointController));
        }
        hashMap.put("numJoints", new Integer(jointController.numJoints));
        hashMap.put("fps", new Float(jointController.FPS));
        this.addControllerBaseAtts(jointController, hashMap);
        this.writeTag("jointcontroller", hashMap);
        Object[] objectArray = jointController.movementInfo.toArray();
        Vector3f vector3f = new Vector3f();
        Matrix3f matrix3f = new Matrix3f();
        for (int i = 0; i < jointController.numJoints; ++i) {
            hashMap.clear();
            hashMap.put("index", new Integer(i));
            hashMap.put("parentindex", new Integer(jointController.parentIndex[i]));
            jointController.localRefMatrix[i].getRotation(matrix3f);
            jointController.localRefMatrix[i].getTranslation(vector3f);
            hashMap.put("localrot", matrix3f);
            hashMap.put("localvec", vector3f);
            this.writeTag("joint", hashMap);
            for (int j = 0; j < objectArray.length; ++j) {
                PointInTime pointInTime = (PointInTime)objectArray[j];
                if (!pointInTime.usedTrans.get(i) && !pointInTime.usedRot.get(i)) continue;
                hashMap.clear();
                hashMap.put("time", new Float(pointInTime.time));
                if (pointInTime.usedTrans.get(i)) {
                    hashMap.put("trans", pointInTime.jointTranslation[i]);
                }
                if (pointInTime.usedRot.get(i)) {
                    hashMap.put("rot", pointInTime.jointRotation[i]);
                }
                this.writeTag("keyframe", hashMap);
                this.writeEndTag("keyframe");
            }
            this.writeEndTag("joint");
        }
        this.writeEndTag("jointcontroller");
    }

    private void writeRenderStates(Spatial spatial) throws IOException {
        for (int i = 0; i < 17; ++i) {
            this.writeRenderState(spatial.getRenderState(i));
        }
    }

    private void writeRenderState(RenderState renderState) throws IOException {
        if (renderState == null) {
            return;
        }
        if (this.sharedObjects.containsKey(renderState)) {
            if (this.entireScene.containsKey(renderState)) {
                this.writeSharedObject(renderState);
                return;
            }
            this.entireScene.put(renderState, null);
        }
        if (renderState instanceof MaterialState) {
            this.writeMaterialState((MaterialState)renderState);
        } else if (renderState instanceof AlphaState) {
            this.writeAlphaState((AlphaState)renderState);
        } else if (renderState instanceof TextureState) {
            this.writeTextureState((TextureState)renderState);
        } else if (renderState instanceof LightState) {
            this.writeLightState((LightState)renderState);
        } else if (renderState instanceof CullState) {
            this.writeCullState((CullState)renderState);
        } else if (renderState instanceof WireframeState) {
            this.writeWireframeState((WireframeState)renderState);
        } else {
            System.out.println("Unknown render state... ut ow!");
        }
    }

    private void writeWireframeState(WireframeState wireframeState) throws IOException {
        if (wireframeState == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(wireframeState)) {
            hashMap.put("sharedident", this.sharedObjects.get(wireframeState));
        }
        hashMap.put("width", new Float(wireframeState.getLineWidth()));
        hashMap.put("facetype", new Integer(wireframeState.getFace()));
        this.writeTag("wirestate", hashMap);
        this.writeEndTag("wirestate");
    }

    private void writeCullState(CullState cullState) throws IOException {
        int n;
        if (cullState == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(cullState)) {
            hashMap.put("sharedident", this.sharedObjects.get(cullState));
        }
        if ((n = cullState.getCullMode()) == 2) {
            hashMap.put("cull", "back");
        } else if (n == 1) {
            hashMap.put("cull", "front");
        } else if (n == 0) {
            hashMap.put("cull", "none");
        }
        this.writeTag("cullstate", hashMap);
        this.writeEndTag("cullstate");
    }

    private void writeLightState(LightState lightState) throws IOException {
        if (lightState == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        hashMap.put("ambient", lightState.getGlobalAmbient());
        hashMap.put("twosided", lightState.getTwoSidedLighting());
        hashMap.put("local", lightState.getLocalViewer());
        hashMap.put("sepspec", lightState.getSeparateSpecular());
        if (this.sharedObjects.containsKey(lightState)) {
            hashMap.put("sharedident", this.sharedObjects.get(lightState));
        }
        this.writeTag("lightstate", null);
        for (int i = 0; i < lightState.getQuantity(); ++i) {
            hashMap.clear();
            Light light = lightState.get(i);
            this.putLightProperties(light, hashMap);
            if (light.getType() == 2) {
                this.writeSpotLight((SpotLight)light, hashMap);
                continue;
            }
            if (light.getType() != 1) continue;
            this.writePointLight((PointLight)light, hashMap);
        }
        this.writeEndTag("lightstate");
    }

    private void writePointLight(PointLight pointLight, HashMap<String, Object> hashMap) throws IOException {
        hashMap.put("loc", pointLight.getLocation());
        this.writeTag("pointlight", hashMap);
        this.writeEndTag("pointlight");
    }

    private void putLightProperties(Light light, HashMap<String, Object> hashMap) {
        hashMap.put("ambient", light.getAmbient());
        hashMap.put("fconstant", new Float(light.getConstant()));
        hashMap.put("diffuse", light.getDiffuse());
        hashMap.put("flinear", new Float(light.getLinear()));
        hashMap.put("fquadratic", new Float(light.getQuadratic()));
        hashMap.put("specular", light.getSpecular());
        hashMap.put("isattenuate", new Boolean(light.isAttenuate()));
    }

    private void writeSpotLight(SpotLight spotLight, HashMap<String, Object> hashMap) throws IOException {
        hashMap.put("loc", spotLight.getLocation());
        hashMap.put("fangle", new Float(spotLight.getAngle()));
        hashMap.put("dir", spotLight.getDirection());
        hashMap.put("fexponent", new Float(spotLight.getExponent()));
        this.writeTag("spotlight", hashMap);
        this.writeEndTag("spotlight");
    }

    private void writeTextureState(TextureState textureState) throws IOException {
        this.writeTag("texturestate", null);
        for (int i = 0; i < TextureState.getNumberOfTotalUnits(); ++i) {
            if (textureState.getTexture(i) == null || textureState.getTexture(i).getImageLocation() == null) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.clear();
            Texture texture = textureState.getTexture(i);
            String string = texture.getImageLocation();
            if (this.sharedObjects.containsKey(textureState)) {
                hashMap.put("sharedident", this.sharedObjects.get(textureState));
            }
            if ("file:/".equals(string.substring(0, 6))) {
                hashMap.put("file", JmeBinaryWriter.replaceSpecialsForFile(new StringBuffer(string.substring(6))).toString());
            } else {
                hashMap.put("URL", new URL(string));
            }
            hashMap.put("wrap", new Integer(texture.getWrap()));
            hashMap.put("texnum", new Integer(i));
            if (texture.getScale() != null) {
                hashMap.put("scale", texture.getScale());
            }
            this.writeTag("texture", hashMap);
            this.writeEndTag("texture");
        }
        this.writeEndTag("texturestate");
    }

    private static StringBuffer replaceSpecialsForFile(StringBuffer stringBuffer) {
        int n = stringBuffer.indexOf("%20");
        if (n == -1) {
            return stringBuffer;
        }
        return JmeBinaryWriter.replaceSpecialsForFile(stringBuffer.replace(n, n + 3, " "));
    }

    private void writeMaterialState(MaterialState materialState) throws IOException {
        if (materialState == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(materialState)) {
            hashMap.put("sharedident", this.sharedObjects.get(materialState));
        }
        hashMap.put("emissive", materialState.getEmissive());
        hashMap.put("ambient", materialState.getAmbient());
        hashMap.put("diffuse", materialState.getDiffuse());
        hashMap.put("specular", materialState.getSpecular());
        hashMap.put("shiny", new Float(materialState.getShininess()));
        hashMap.put("color", new Integer(materialState.getColorMaterial()));
        hashMap.put("face", new Integer(materialState.getMaterialFace()));
        this.writeTag("materialstate", hashMap);
        this.writeEndTag("materialstate");
    }

    private void writeAlphaState(AlphaState alphaState) throws IOException {
        if (alphaState == null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.clear();
        if (this.sharedObjects.containsKey(alphaState)) {
            hashMap.put("sharedident", this.sharedObjects.get(alphaState));
        }
        hashMap.put("srcfunc", new Integer(alphaState.getSrcFunction()));
        hashMap.put("dstfunc", new Integer(alphaState.getDstFunction()));
        hashMap.put("testfunc", new Integer(alphaState.getTestFunction()));
        hashMap.put("reference", new Float(alphaState.getReference()));
        hashMap.put("blend", new Boolean(alphaState.isBlendEnabled()));
        hashMap.put("test", new Boolean(alphaState.isTestEnabled()));
        hashMap.put("enabled", new Boolean(alphaState.isEnabled()));
        this.writeTag("alphastate", hashMap);
        this.writeEndTag("alphastate");
    }

    private void writeEndTag(String string) throws IOException {
        this.myOut.writeByte(1);
        this.myOut.writeUTF(string);
    }

    private void writeTag(String string, HashMap hashMap) throws IOException {
        this.myOut.writeByte(0);
        this.myOut.writeUTF(string);
        if (hashMap == null) {
            this.myOut.writeByte(0);
            return;
        }
        this.myOut.writeByte(hashMap.size());
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = hashMap.get(string2);
            this.myOut.writeUTF(string2);
            if (v == null) {
                throw new NullPointerException();
            }
            if (v instanceof Vector3f[]) {
                this.writeVec3fArray((Vector3f[])v);
            } else if (v instanceof Vector2f[]) {
                this.writeVec2fArray((Vector2f[])v);
            } else if (v instanceof ColorRGBA[]) {
                this.writeColorArray((ColorRGBA[])v);
            } else if (v instanceof String) {
                this.writeString((String)v);
            } else if (v instanceof int[]) {
                this.writeIntArray((int[])v);
            } else if (v instanceof Vector3f) {
                this.writeVec3f((Vector3f)v);
            } else if (v instanceof Vector2f) {
                this.writeVec2f((Vector2f)v);
            } else if (v instanceof Quaternion) {
                this.writeQuat((Quaternion)v);
            } else if (v instanceof Float) {
                this.writeFloat((Float)v);
            } else if (v instanceof ColorRGBA) {
                this.writeColor((ColorRGBA)v);
            } else if (v instanceof URL) {
                this.writeURL((URL)v);
            } else if (v instanceof Integer) {
                this.writeInt((Integer)v);
            } else if (v instanceof Boolean) {
                this.writeBoolean((Boolean)v);
            } else if (v instanceof Quaternion[]) {
                this.writeQuatArray((Quaternion[])v);
            } else if (v instanceof byte[]) {
                this.writeByteArray((byte[])v);
            } else if (v instanceof short[]) {
                this.writeShortArray((short[])v);
            } else if (v instanceof Matrix3f) {
                this.writeMatrix3((Matrix3f)v);
            } else {
                throw new RuntimeException("unknown class type for " + v + " of " + v.getClass() + " in attr " + string2);
            }
            iterator.remove();
        }
    }

    private void writeMatrix3(Matrix3f matrix3f) throws IOException {
        this.myOut.writeByte(16);
        this.myOut.writeFloat(matrix3f.m00);
        this.myOut.writeFloat(matrix3f.m01);
        this.myOut.writeFloat(matrix3f.m02);
        this.myOut.writeFloat(matrix3f.m10);
        this.myOut.writeFloat(matrix3f.m11);
        this.myOut.writeFloat(matrix3f.m12);
        this.myOut.writeFloat(matrix3f.m20);
        this.myOut.writeFloat(matrix3f.m21);
        this.myOut.writeFloat(matrix3f.m22);
    }

    private void writeShortArray(short[] sArray) throws IOException {
        this.myOut.writeByte(14);
        this.myOut.writeInt(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            this.myOut.writeShort(sArray[i]);
        }
    }

    private void writeByteArray(byte[] byArray) throws IOException {
        this.myOut.writeByte(13);
        this.myOut.writeInt(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            this.myOut.writeByte(byArray[i]);
        }
    }

    private void writeQuatArray(Quaternion[] quaternionArray) throws IOException {
        this.myOut.writeByte(12);
        this.myOut.writeInt(quaternionArray.length);
        for (int i = 0; i < quaternionArray.length; ++i) {
            this.myOut.writeFloat(quaternionArray[i].x);
            this.myOut.writeFloat(quaternionArray[i].y);
            this.myOut.writeFloat(quaternionArray[i].z);
            this.myOut.writeFloat(quaternionArray[i].w);
        }
    }

    private void writeBoolean(Boolean bl) throws IOException {
        this.myOut.writeByte(11);
        this.myOut.writeBoolean(bl);
    }

    private void writeInt(Integer n) throws IOException {
        this.myOut.writeByte(10);
        this.myOut.writeInt(n);
    }

    private void writeURL(URL uRL) throws IOException {
        this.myOut.writeByte(9);
        this.myOut.writeUTF(uRL.toString());
    }

    private void writeColor(ColorRGBA colorRGBA) throws IOException {
        this.myOut.writeByte(8);
        this.myOut.writeFloat(colorRGBA.r);
        this.myOut.writeFloat(colorRGBA.g);
        this.myOut.writeFloat(colorRGBA.b);
        this.myOut.writeFloat(colorRGBA.a);
    }

    private void writeFloat(Float f) throws IOException {
        this.myOut.writeByte(7);
        this.myOut.writeFloat(f.floatValue());
    }

    private void writeQuat(Quaternion quaternion) throws IOException {
        this.myOut.writeByte(6);
        this.myOut.writeFloat(quaternion.x);
        this.myOut.writeFloat(quaternion.y);
        this.myOut.writeFloat(quaternion.z);
        this.myOut.writeFloat(quaternion.w);
    }

    private void writeVec3f(Vector3f vector3f) throws IOException {
        this.myOut.writeByte(5);
        this.myOut.writeFloat(vector3f.x);
        this.myOut.writeFloat(vector3f.y);
        this.myOut.writeFloat(vector3f.z);
    }

    private void writeVec2f(Vector2f vector2f) throws IOException {
        this.myOut.writeByte(15);
        this.myOut.writeFloat(vector2f.x);
        this.myOut.writeFloat(vector2f.y);
    }

    private void writeIntArray(int[] nArray) throws IOException {
        this.myOut.writeByte(4);
        this.myOut.writeInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.myOut.writeInt(nArray[i]);
        }
    }

    private void writeString(String string) throws IOException {
        this.myOut.writeByte(3);
        this.myOut.writeUTF(string);
    }

    private void writeColorArray(ColorRGBA[] colorRGBAArray) throws IOException {
        this.myOut.writeByte(2);
        this.myOut.writeInt(colorRGBAArray.length);
        for (int i = 0; i < colorRGBAArray.length; ++i) {
            this.myOut.writeFloat(colorRGBAArray[i].r);
            this.myOut.writeFloat(colorRGBAArray[i].g);
            this.myOut.writeFloat(colorRGBAArray[i].b);
            this.myOut.writeFloat(colorRGBAArray[i].a);
        }
    }

    private void writeVec2fArray(Vector2f[] vector2fArray) throws IOException {
        this.myOut.writeByte(1);
        this.myOut.writeInt(vector2fArray.length);
        for (int i = 0; i < vector2fArray.length; ++i) {
            if (vector2fArray[i] == null) {
                this.myOut.writeFloat(Float.NaN);
                this.myOut.writeFloat(Float.NaN);
                continue;
            }
            this.myOut.writeFloat(vector2fArray[i].x);
            this.myOut.writeFloat(vector2fArray[i].y);
        }
    }

    private void writeVec3fArray(Vector3f[] vector3fArray) throws IOException {
        this.myOut.writeByte(0);
        this.myOut.writeInt(vector3fArray.length);
        for (int i = 0; i < vector3fArray.length; ++i) {
            if (vector3fArray[i] == null) {
                this.myOut.writeFloat(Float.NaN);
                this.myOut.writeFloat(Float.NaN);
                this.myOut.writeFloat(Float.NaN);
                continue;
            }
            this.myOut.writeFloat(vector3fArray[i].x);
            this.myOut.writeFloat(vector3fArray[i].y);
            this.myOut.writeFloat(vector3fArray[i].z);
        }
    }

    private void putSpatialAtts(Spatial spatial, HashMap<String, Object> hashMap) {
        hashMap.put("name", spatial.getName());
        if (!spatial.getLocalScale().equals((Object)DEFAULT_SCALE)) {
            hashMap.put("scale", spatial.getLocalScale());
        }
        if (!spatial.getLocalRotation().equals((Object)DEFAULT_ROTATION)) {
            hashMap.put("rotation", spatial.getLocalRotation());
        }
        if (!spatial.getLocalTranslation().equals((Object)DEFAULT_TRANSLATION)) {
            hashMap.put("translation", spatial.getLocalTranslation());
        }
    }

    private void writeClosing() throws IOException {
        this.writeEndTag("scene");
        this.myOut.writeByte(2);
    }

    private void writeHeader() throws IOException {
        this.myOut.writeLong(1234567L);
        this.writeTag("scene", null);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void clearProperty(String string) {
        this.properties.remove(string);
    }
}

