/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects;

import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Matrix4f;
import com.jme.math.Vector3f;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;

public class ProjectedTextureUtil {
    private static Matrix4f lightProjectionMatrix = new Matrix4f();
    private static Matrix4f lightViewMatrix = new Matrix4f();
    private static Matrix4f biasMatrix = new Matrix4f(0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f);
    private static final FloatBuffer tmp_FloatBuffer = org.lwjgl.BufferUtils.createFloatBuffer((int)16);
    private static Vector3f localDir = new Vector3f();
    private static Vector3f localLeft = new Vector3f();
    private static Vector3f localUp = new Vector3f();
    private static Vector3f tmpVec = new Vector3f();
    private static IntBuffer matrixModeBuffer = BufferUtils.createIntBuffer((int)16);
    private static int savedMatrixMode = 0;

    public static void setupProjectedTexture(Texture texture, int n, int n2) {
        texture.setMatrix(new Matrix4f());
        texture.setEnvironmentalMapMode(1);
        texture.setWrap(n);
        texture.setApply(4);
        texture.setCombineFuncRGB(n2);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(3);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
    }

    public static void updateProjectedTexture(Texture texture, float f, float f2, float f3, float f4, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        ProjectedTextureUtil.matrixPerspective(f, f2, f3, f4, lightProjectionMatrix);
        ProjectedTextureUtil.matrixLookAt(vector3f, vector3f2, vector3f3, lightViewMatrix);
        texture.getMatrix().set(lightViewMatrix.multLocal(lightProjectionMatrix).multLocal(biasMatrix)).transposeLocal();
    }

    private static void saveMatrixMode() {
        matrixModeBuffer.rewind();
        GL11.glGetInteger((int)2976, (IntBuffer)matrixModeBuffer);
        savedMatrixMode = matrixModeBuffer.get(0);
    }

    private static void restoreMatrixMode() {
        GL11.glMatrixMode((int)savedMatrixMode);
    }

    public static void matrixLookAt(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Matrix4f matrix4f) {
        localDir.set(vector3f2).subtractLocal(vector3f).normalizeLocal();
        localDir.cross(vector3f3, localLeft);
        localLeft.cross(localDir, localUp);
        ProjectedTextureUtil.saveMatrixMode();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluLookAt((float)vector3f.x, (float)vector3f.y, (float)vector3f.z, (float)vector3f2.x, (float)vector3f2.y, (float)vector3f2.z, (float)ProjectedTextureUtil.localUp.x, (float)ProjectedTextureUtil.localUp.y, (float)ProjectedTextureUtil.localUp.z);
        if (matrix4f != null) {
            tmp_FloatBuffer.rewind();
            GL11.glGetFloat((int)2982, (FloatBuffer)tmp_FloatBuffer);
            tmp_FloatBuffer.rewind();
            matrix4f.readFloatBuffer(tmp_FloatBuffer);
        }
        GL11.glPopMatrix();
        ProjectedTextureUtil.restoreMatrixMode();
    }

    public static void matrixPerspective(float f, float f2, float f3, float f4, Matrix4f matrix4f) {
        ProjectedTextureUtil.saveMatrixMode();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)f, (float)f2, (float)f3, (float)f4);
        if (matrix4f != null) {
            tmp_FloatBuffer.rewind();
            GL11.glGetFloat((int)2982, (FloatBuffer)tmp_FloatBuffer);
            tmp_FloatBuffer.rewind();
            matrix4f.readFloatBuffer(tmp_FloatBuffer);
        }
        GL11.glPopMatrix();
        ProjectedTextureUtil.restoreMatrixMode();
    }

    public static void matrixProjection(float f, float f2, float f3, float f4, Matrix4f matrix4f) {
        float f5 = FastMath.tan((float)(f * ((float)Math.PI / 180))) * f3 * 0.5f;
        float f6 = f5 * f2;
        float f7 = -f6;
        float f8 = f6;
        float f9 = -f5;
        float f10 = f5;
        float f11 = f3;
        float f12 = f4;
        ProjectedTextureUtil.saveMatrixMode();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glFrustum((double)f7, (double)f8, (double)f9, (double)f10, (double)f11, (double)f12);
        if (matrix4f != null) {
            tmp_FloatBuffer.rewind();
            GL11.glGetFloat((int)2983, (FloatBuffer)tmp_FloatBuffer);
            tmp_FloatBuffer.rewind();
            matrix4f.readFloatBuffer(tmp_FloatBuffer);
        }
        GL11.glPopMatrix();
        ProjectedTextureUtil.restoreMatrixMode();
    }
}

