/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.glsl;

import com.jme.image.Texture;
import com.jme.math.Matrix4f;
import com.jme.renderer.AbstractCamera;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.pass.Pass;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.LoggingSystem;
import java.util.ArrayList;
import java.util.logging.Level;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;

public class MotionBlurRenderPass
extends Pass {
    private static final long serialVersionUID = 1L;
    private TextureRenderer tRenderer;
    private Texture mainTexture;
    private AlphaState alphaObj;
    private CullState cullObj;
    private TextureState tsObj;
    private float blurStrength = -3.5E-5f;
    private GLSLShaderObjectsState motionBlurShader;
    private boolean freeze = false;
    private boolean supported = true;
    private boolean useCurrentScene = false;
    private ArrayList<DynamicObject> dynamicObjects = new ArrayList();
    private Matrix4f tmpMatrix = new Matrix4f();
    private Matrix4f projectionMatrix = new Matrix4f();
    private float tpf = 0.0f;
    private Camera cam;
    private final SpatialsRenderNode spatialsRenderNode = new SpatialsRenderNode();

    public void addMotionBlurSpatial(Spatial spatial) {
        DynamicObject dynamicObject = new DynamicObject();
        dynamicObject.spatial = spatial;
        this.dynamicObjects.add(dynamicObject);
    }

    public void resetParameters() {
    }

    public void cleanup() {
        super.cleanUp();
        if (this.tRenderer != null) {
            this.tRenderer.cleanup();
        }
    }

    public boolean isSupported() {
        return this.supported;
    }

    public MotionBlurRenderPass(Camera camera) {
        this.cam = camera;
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.resetParameters();
        this.tRenderer = displaySystem.createTextureRenderer(displaySystem.getWidth(), displaySystem.getHeight(), 2);
        this.tRenderer.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.tRenderer.setCamera(camera);
        this.mainTexture = new Texture();
        this.mainTexture.setWrap(4);
        this.mainTexture.setFilter(1);
        this.tRenderer.setupTexture(this.mainTexture);
        this.motionBlurShader = displaySystem.getRenderer().createGLSLShaderObjectsState();
        if (!this.motionBlurShader.isSupported()) {
            this.supported = false;
        } else {
            this.reloadShader();
        }
        this.tsObj = displaySystem.getRenderer().createTextureState();
        this.tsObj.setEnabled(true);
        this.tsObj.setTexture(this.mainTexture, 0);
        this.cullObj = displaySystem.getRenderer().createCullState();
        this.cullObj.setEnabled(true);
        this.cullObj.setCullMode(2);
        this.alphaObj = displaySystem.getRenderer().createAlphaState();
        this.alphaObj.setEnabled(true);
        this.alphaObj.setBlendEnabled(true);
        this.alphaObj.setSrcFunction(4);
        this.alphaObj.setDstFunction(5);
    }

    public void reloadShader() {
        GLSLShaderObjectsState gLSLShaderObjectsState = DisplaySystem.getDisplaySystem().getRenderer().createGLSLShaderObjectsState();
        try {
            gLSLShaderObjectsState.load(MotionBlurRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/motionblur.vert"), MotionBlurRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/motionblur.frag"));
            gLSLShaderObjectsState.apply();
            Util.checkGLError();
        }
        catch (OpenGLException openGLException) {
            openGLException.printStackTrace();
            return;
        }
        this.motionBlurShader.load(MotionBlurRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/motionblur.vert"), MotionBlurRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/motionblur.frag"));
        this.motionBlurShader.clearUniforms();
        this.motionBlurShader.setUniform("screenTexture", 0);
        this.motionBlurShader.setUniform("prevModelViewMatrix", new Matrix4f(), false);
        this.motionBlurShader.setUniform("prevModelViewProjectionMatrix", new Matrix4f(), false);
        this.motionBlurShader.setUniform("halfWinSize", (float)DisplaySystem.getDisplaySystem().getWidth() * 0.5f, (float)DisplaySystem.getDisplaySystem().getHeight() * 0.5f);
        this.motionBlurShader.setUniform("blurStrength", this.blurStrength);
        this.motionBlurShader.apply();
        LoggingSystem.getLogger().log(Level.INFO, "Shader reloaded...");
    }

    protected void doUpdate(float f) {
        super.doUpdate(f);
        if (!this.freeze) {
            this.tpf = f;
        }
    }

    public void doRender(Renderer renderer) {
        Matrix4f matrix4f;
        Matrix4f matrix4f2;
        DynamicObject dynamicObject;
        int n;
        if (!this.useCurrentScene && this.spatials.size() == 0) {
            return;
        }
        if (this.useCurrentScene) {
            this.tRenderer.copyBufferToTexture(this.mainTexture, DisplaySystem.getDisplaySystem().getWidth(), DisplaySystem.getDisplaySystem().getHeight(), 1);
        } else {
            this.tRenderer.render((Spatial)this.spatialsRenderNode, this.mainTexture);
        }
        this.projectionMatrix.set(((AbstractCamera)this.cam).getProjectionMatrix());
        for (n = 0; n < this.dynamicObjects.size(); ++n) {
            dynamicObject = this.dynamicObjects.get(n);
            matrix4f2 = dynamicObject.modelMatrix;
            matrix4f = dynamicObject.modelViewMatrix;
            Matrix4f matrix4f3 = dynamicObject.modelViewProjectionMatrix;
            matrix4f.set(matrix4f2);
            matrix4f.multLocal(((AbstractCamera)this.cam).getModelViewMatrix());
            matrix4f3.set(matrix4f).multLocal(this.projectionMatrix);
        }
        this.context.enforceState((RenderState)this.motionBlurShader);
        this.context.enforceState((RenderState)this.tsObj);
        this.context.enforceState((RenderState)this.cullObj);
        for (n = 0; n < this.dynamicObjects.size(); ++n) {
            dynamicObject = this.dynamicObjects.get(n);
            this.motionBlurShader.setUniform("prevModelViewMatrix", dynamicObject.modelViewMatrix, false);
            this.motionBlurShader.setUniform("prevModelViewProjectionMatrix", dynamicObject.modelViewProjectionMatrix, false);
            this.motionBlurShader.setUniform("blurStrength", this.blurStrength / this.tpf);
            this.motionBlurShader.apply();
            renderer.draw(dynamicObject.spatial);
            renderer.renderQueue();
        }
        this.context.clearEnforcedState(14);
        this.context.clearEnforcedState(6);
        this.context.clearEnforcedState(9);
        if (!this.freeze) {
            for (n = 0; n < this.dynamicObjects.size(); ++n) {
                dynamicObject = this.dynamicObjects.get(n);
                matrix4f2 = dynamicObject.modelMatrix;
                matrix4f = dynamicObject.spatial;
                matrix4f2.loadIdentity();
                matrix4f.getWorldRotation().toRotationMatrix(this.tmpMatrix);
                matrix4f2.multLocal(this.tmpMatrix);
                matrix4f2.m00 *= matrix4f.getWorldScale().x;
                matrix4f2.m11 *= matrix4f.getWorldScale().y;
                matrix4f2.m22 *= matrix4f.getWorldScale().z;
                matrix4f2.setTranslation(matrix4f.getWorldTranslation());
                matrix4f2.transposeLocal();
            }
        }
    }

    public Texture getMainTexture() {
        return this.mainTexture;
    }

    public boolean useCurrentScene() {
        return this.useCurrentScene;
    }

    public void setUseCurrentScene(boolean bl) {
        this.useCurrentScene = bl;
    }

    public boolean isFreeze() {
        return this.freeze;
    }

    public void setFreeze(boolean bl) {
        this.freeze = bl;
    }

    public float getBlurStrength() {
        return this.blurStrength;
    }

    public void setBlurStrength(float f) {
        this.blurStrength = f;
    }

    private class SpatialsRenderNode
    extends Node {
        private static final long serialVersionUID = 7367501683137581101L;

        private SpatialsRenderNode() {
        }

        public void draw(Renderer renderer) {
            int n = MotionBlurRenderPass.this.spatials.size();
            for (int i = 0; i < n; ++i) {
                Spatial spatial = (Spatial)MotionBlurRenderPass.this.spatials.get(i);
                if (spatial == null) continue;
                spatial.onDraw(renderer);
            }
        }

        public void onDraw(Renderer renderer) {
            this.draw(renderer);
        }
    }

    private class DynamicObject {
        public Spatial spatial;
        public Matrix4f modelMatrix = new Matrix4f();
        public Matrix4f modelViewMatrix = new Matrix4f();
        public Matrix4f modelViewProjectionMatrix = new Matrix4f();

        private DynamicObject() {
        }
    }
}

