/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.water;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.pass.Pass;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.ClipState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.nio.FloatBuffer;

public class SimpleWaterRenderPass
extends Pass {
    private Camera cam;
    private TextureRenderer tRendererReflect;
    private Texture textureReflect;
    private float tpf;
    private Node renderNode;
    private Geometry waterQuad;
    private Node skyBox;
    private GLSLShaderObjectsState waterShader;
    private Vector3f waterColor;
    private Vector3f lightPosition;
    private float normalTranslation = 0.0f;
    private float refractionTranslation = 0.0f;
    private boolean supported = true;
    private float waterSize = 10000.0f;
    private float waterHeight = 0.0f;
    private float speedReflection = 0.3f;
    private float speedRefraction = 0.3f;
    private float scaleReflection = 0.3f;
    private float scaleRefraction = 0.3f;
    private boolean useLod;
    private ClipState clipState;
    Vector3f save = new Vector3f();
    final Vector3f invUp = new Vector3f(0.0f, -1.0f, 0.0f);

    public void resetParameters() {
        this.waterColor = new Vector3f(0.0f, 0.0f, 0.0f);
        this.lightPosition = new Vector3f(1000.0f, 100.0f, 1000.0f);
    }

    public void cleanup() {
        if (this.isSupported()) {
            this.tRendererReflect.cleanup();
        }
    }

    public boolean isSupported() {
        return this.supported;
    }

    public SimpleWaterRenderPass(Camera camera, int n, boolean bl) {
        this.cam = camera;
        this.resetParameters();
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.waterShader = displaySystem.getRenderer().createGLSLShaderObjectsState();
        if (!this.waterShader.isSupported() || !bl) {
            this.supported = false;
        } else {
            this.waterShader.load(SimpleWaterRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/simplewatershader.vert"), SimpleWaterRenderPass.class.getClassLoader().getResource("com/jmex/effects/glsl/data/simplewatershader.frag"));
            this.waterShader.setEnabled(true);
            this.waterShader.clearUniforms();
            this.waterShader.setUniform("normalMap", 0);
            this.waterShader.setUniform("reflection", 1);
            this.waterShader.setUniform("dudvMap", 2);
            this.waterShader.setUniform("waterColor", this.waterColor.x, this.waterColor.y, this.waterColor.z, 1.0f);
            this.waterShader.setUniform("cameraPos", camera.getLocation().x, camera.getLocation().y, camera.getLocation().z, 1.0f);
            this.waterShader.setUniform("normalTranslation", this.normalTranslation);
            this.waterShader.setUniform("refractionTranslation", this.refractionTranslation);
            this.waterShader.setUniform("abovewater", 1);
            this.waterShader.apply();
        }
        this.waterQuad = new Quad("waterQuad", 1.0f, 1.0f);
        this.waterQuad.copyTextureCoords(0, 0, 1);
        CullState cullState = displaySystem.getRenderer().createCullState();
        cullState.setEnabled(true);
        cullState.setCullMode(0);
        this.waterQuad.setRenderState((RenderState)cullState);
        this.clipState = displaySystem.getRenderer().createClipState();
        if (this.isSupported()) {
            this.waterQuad.setRenderQueueMode(1);
            this.waterQuad.setRenderState((RenderState)this.waterShader);
            this.tRendererReflect = displaySystem.createTextureRenderer(displaySystem.getWidth() / n, displaySystem.getHeight() / n, 2);
            this.tRendererReflect.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
            this.tRendererReflect.getCamera().setFrustum(camera.getFrustumNear(), camera.getFrustumFar(), camera.getFrustumLeft(), camera.getFrustumRight(), camera.getFrustumTop(), camera.getFrustumBottom());
            this.textureReflect = new Texture();
            this.textureReflect.setWrap(0);
            this.textureReflect.setFilter(1);
            this.tRendererReflect.setupTexture(this.textureReflect);
            TextureState textureState = displaySystem.getRenderer().createTextureState();
            textureState.setEnabled(true);
            Texture texture = TextureManager.loadTexture((URL)SimpleWaterRenderPass.class.getClassLoader().getResource("data/normalmap3.dds"), (int)6, (int)1);
            textureState.setTexture(texture, 0);
            texture.setWrap(3);
            textureState.setTexture(this.textureReflect, 1);
            texture = TextureManager.loadTexture((URL)SimpleWaterRenderPass.class.getClassLoader().getResource("data/dudvmap.png"), (int)6, (int)1);
            textureState.setTexture(texture, 2);
            texture.setWrap(3);
            this.waterQuad.setRenderState((RenderState)textureState);
            this.waterQuad.updateRenderState();
            this.clipState.setEnabled(true);
            this.clipState.setEnableClipPlane(0, true);
        } else {
            this.waterQuad.setRenderQueueMode(3);
            this.waterQuad.setLightCombineMode(0);
            TextureState textureState = displaySystem.getRenderer().createTextureState();
            textureState.setEnabled(true);
            Texture texture = TextureManager.loadTexture((URL)SimpleWaterRenderPass.class.getClassLoader().getResource("data/water2.png"), (int)6, (int)1);
            textureState.setTexture(texture, 0);
            texture.setWrap(3);
            texture = TextureManager.loadTexture((URL)SimpleWaterRenderPass.class.getClassLoader().getResource("data/water2.png"), (int)6, (int)1);
            textureState.setTexture(texture, 1);
            texture.setWrap(3);
            this.waterQuad.setRenderState((RenderState)textureState);
            AlphaState alphaState = displaySystem.getRenderer().createAlphaState();
            alphaState.setBlendEnabled(true);
            alphaState.setSrcFunction(4);
            alphaState.setDstFunction(5);
            alphaState.setEnabled(true);
            this.waterQuad.setRenderState((RenderState)alphaState);
            this.waterQuad.updateRenderState();
        }
    }

    public void doRender(Renderer renderer) {
        this.normalTranslation += this.speedReflection * this.tpf;
        this.refractionTranslation -= this.speedRefraction * this.tpf;
        Vector3f vector3f = new Vector3f(this.cam.getLocation().x, this.waterHeight, this.cam.getLocation().z);
        if (this.isSupported()) {
            this.setTextureCoords(0, vector3f.x, -vector3f.z, this.scaleRefraction);
            this.setTextureCoords(1, vector3f.x, -vector3f.z, this.scaleReflection);
        } else {
            this.setTextureCoords(0, vector3f.x, -vector3f.z + this.refractionTranslation * 100.0f, this.scaleRefraction * 0.25f);
            this.setTextureCoords(1, vector3f.x, -vector3f.z + this.normalTranslation * 100.0f, this.scaleReflection * 0.25f);
        }
        this.setVertexCoords(vector3f.x, vector3f.y, vector3f.z);
        if (this.isSupported()) {
            this.waterShader.clearUniforms();
            this.waterShader.setUniform("normalMap", 0);
            this.waterShader.setUniform("reflection", 1);
            this.waterShader.setUniform("dudvMap", 2);
            this.waterShader.setUniform("waterColor", this.waterColor.x, this.waterColor.y, this.waterColor.z, 1.0f);
            this.waterShader.setUniform("cameraPos", this.cam.getLocation().x, this.cam.getLocation().y, this.cam.getLocation().z, 1.0f);
            this.waterShader.setUniform("normalTranslation", this.normalTranslation);
            this.waterShader.setUniform("refractionTranslation", this.refractionTranslation);
            this.waterShader.setUniform("abovewater", this.cam.getLocation().y > this.waterHeight ? 1 : 0);
            this.waterShader.apply();
            if (this.cam.getLocation().y > this.waterHeight) {
                this.clipState.setClipPlaneEquation(0, 0.0, 1.0, 0.0, (double)(-this.waterHeight) + 0.5);
            } else {
                this.clipState.setClipPlaneEquation(0, 0.0, 1.0, 0.0, (double)(-this.waterHeight) + 0.5);
                ClipState clipState = (ClipState)this.skyBox.getRenderState(16);
                clipState.setClipPlaneEquation(0, 0.0, 1.0, 0.0, (double)(-this.waterHeight) + 0.5);
            }
            this.renderReflection();
            if (this.cam.getLocation().y > this.waterHeight) {
                this.clipState.setClipPlaneEquation(0, 0.0, 1.0, 0.0, (double)(-this.waterHeight) + 0.5);
            } else {
                this.clipState.setClipPlaneEquation(0, 0.0, -1.0, 0.0, (double)this.waterHeight + 0.5);
            }
        }
    }

    private void renderReflection() {
        if (this.cam.getLocation().y > this.waterHeight) {
            this.tRendererReflect.getCamera().getLocation().set(this.cam.getLocation().x, -this.cam.getLocation().y + this.waterHeight * 2.0f, this.cam.getLocation().z);
            this.tRendererReflect.getCamera().getDirection().set(this.cam.getDirection().x, -this.cam.getDirection().y, this.cam.getDirection().z);
            Vector3f vector3f = this.tRendererReflect.getCamera().getDirection();
            Vector3f vector3f2 = this.invUp.cross(vector3f).normalizeLocal();
            Vector3f vector3f3 = vector3f.cross(vector3f2).normalizeLocal();
            this.tRendererReflect.getCamera().getUp().set(vector3f3);
            this.tRendererReflect.getCamera().getLeft().set(vector3f2);
        } else {
            this.tRendererReflect.getCamera().getLocation().set(this.cam.getLocation());
            this.tRendererReflect.getCamera().getDirection().set(this.cam.getDirection());
            this.tRendererReflect.getCamera().getUp().set(this.cam.getUp());
            this.tRendererReflect.getCamera().getLeft().set(this.cam.getLeft());
        }
        this.tRendererReflect.updateCamera();
        if (this.useLod) {
            // empty if block
        }
        this.tRendererReflect.render((Spatial)this.renderNode, this.textureReflect);
        if (this.useLod) {
            // empty if block
        }
    }

    public Spatial getWaterSurface() {
        return this.waterQuad;
    }

    private void setVertexCoords(float f, float f2, float f3) {
        FloatBuffer floatBuffer = this.waterQuad.getVertexBuffer(0);
        floatBuffer.clear();
        floatBuffer.put(f - this.waterSize).put(f2).put(f3 - this.waterSize);
        floatBuffer.put(f - this.waterSize).put(f2).put(f3 + this.waterSize);
        floatBuffer.put(f + this.waterSize).put(f2).put(f3 + this.waterSize);
        floatBuffer.put(f + this.waterSize).put(f2).put(f3 - this.waterSize);
    }

    private void setTextureCoords(int n, float f, float f2, float f3) {
        f *= f3 * 0.5f;
        f2 *= f3 * 0.5f;
        f3 = this.waterSize * f3;
        FloatBuffer floatBuffer = this.waterQuad.getTextureBuffer(0, n);
        floatBuffer.clear();
        floatBuffer.put(f).put(f3 + f2);
        floatBuffer.put(f).put(f2);
        floatBuffer.put(f3 + f).put(f2);
        floatBuffer.put(f3 + f).put(f3 + f2);
    }

    public void setScene(Node node) {
        this.renderNode = node;
        node.setRenderState((RenderState)this.clipState);
        node.updateRenderState();
    }

    public void setSkybox(Node node) {
        this.skyBox = node;
    }

    public float getWaterHeight() {
        return this.waterHeight;
    }

    public Vector3f getLightPosition() {
        return this.lightPosition;
    }

    public void setLightPosition(Vector3f vector3f) {
        this.lightPosition = vector3f;
    }

    public Vector3f getWaterColor() {
        return this.waterColor;
    }

    public void setWaterColor(Vector3f vector3f) {
        this.waterColor = vector3f;
    }

    public GLSLShaderObjectsState getWaterShader() {
        return this.waterShader;
    }
}

