/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.applet;

import com.jme.input.FirstPersonHandler;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.KeyInput;
import com.jme.input.MouseInput;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.WireframeState;
import com.jme.system.DisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.TextureManager;
import com.jmex.awt.JMECanvas;
import com.jmex.awt.SimpleCanvasImpl;
import com.jmex.awt.input.AWTKeyInput;
import com.jmex.awt.input.AWTMouseInput;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.Callable;

public class SimpleJMEApplet
extends Applet {
    private static final long serialVersionUID = 1L;
    private Canvas glCanvas;
    private SimpleAppletCanvasImplementor impl;
    protected long repaintSleepTime = 2L;
    private static final String INIT_LOCK = "INIT_LOCK";
    protected static final int STATUS_INITING = 0;
    protected static final int STATUS_RUNNING = 1;
    protected static final int STATUS_DESTROYING = 2;
    protected static final int STATUS_DEAD = 3;
    private static final String USE_APPLET_CANVAS_SIZE = "useAppletCanvasSize";
    private static final int DEFAULT_JME_CANVAS_WIDTH = 640;
    private static final int DEFAULT_JME_CANVAS_HEIGHT = 480;
    protected int status = 0;
    protected int alphaBits = 0;
    protected int depthBits = 8;
    protected int stencilBits = 0;
    protected int samples = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String string = INIT_LOCK;
        synchronized (INIT_LOCK) {
            int n;
            int n2;
            TextureManager.clearCache();
            Text.resetFontTexture();
            try {
                DisplaySystem.getSystemProvider().installLibs();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
            displaySystem.setMinDepthBits(this.depthBits);
            displaySystem.setMinStencilBits(this.stencilBits);
            displaySystem.setMinAlphaBits(this.alphaBits);
            displaySystem.setMinSamples(this.samples);
            if (Boolean.parseBoolean(this.getParameter(USE_APPLET_CANVAS_SIZE))) {
                n2 = this.getWidth();
                n = this.getHeight();
            } else {
                n2 = 640;
                n = 480;
            }
            this.glCanvas = DisplaySystem.getDisplaySystem().createCanvas(n2, n);
            this.impl = new SimpleAppletCanvasImplementor(this.getWidth(), this.getHeight());
            ((JMECanvas)((Object)this.glCanvas)).setImplementor(this.impl);
            this.setLayout(new BorderLayout());
            this.add((Component)this.glCanvas, "Center");
            this.glCanvas.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    if (SimpleJMEApplet.this.impl != null) {
                        SimpleJMEApplet.this.impl.resizeCanvas(SimpleJMEApplet.this.glCanvas.getWidth(), SimpleJMEApplet.this.glCanvas.getHeight());
                        if (SimpleJMEApplet.this.impl.getCamera() != null) {
                            Callable callable = new Callable(){

                                public Object call() {
                                    SimpleJMEApplet.this.impl.getCamera().setFrustumPerspective(45.0f, (float)SimpleJMEApplet.this.glCanvas.getWidth() / (float)SimpleJMEApplet.this.glCanvas.getHeight(), 1.0f, 1000.0f);
                                    return null;
                                }
                            };
                            GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
                        }
                    }
                }
            });
            this.glCanvas.setFocusable(true);
            this.glCanvas.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ((AWTKeyInput)KeyInput.get()).setEnabled(true);
                    ((AWTMouseInput)MouseInput.get()).setEnabled(true);
                }

                public void focusLost(FocusEvent focusEvent) {
                    ((AWTKeyInput)KeyInput.get()).setEnabled(false);
                    ((AWTMouseInput)MouseInput.get()).setEnabled(false);
                }
            });
            ((JMECanvas)((Object)this.glCanvas)).setUpdateInput(true);
            if (!KeyInput.isInited()) {
                KeyInput.setProvider((String)"AWT");
            }
            ((AWTKeyInput)KeyInput.get()).setEnabled(false);
            KeyListener keyListener = (KeyListener)KeyInput.get();
            this.glCanvas.addKeyListener(keyListener);
            if (!MouseInput.isInited()) {
                MouseInput.setProvider((String)"AWT");
            }
            ((AWTMouseInput)MouseInput.get()).setEnabled(false);
            ((AWTMouseInput)MouseInput.get()).setDragOnly(true);
            this.glCanvas.addMouseListener((MouseListener)MouseInput.get());
            this.glCanvas.addMouseWheelListener((MouseWheelListener)MouseInput.get());
            this.glCanvas.addMouseMotionListener((MouseMotionListener)MouseInput.get());
            this.glCanvas.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    if (!SimpleJMEApplet.this.glCanvas.hasFocus()) {
                        SimpleJMEApplet.this.glCanvas.requestFocus();
                    }
                }
            });
            new Thread(){
                {
                    this.setDaemon(true);
                }

                public void run() {
                    while (true) {
                        if (SimpleJMEApplet.this.isVisible() || SimpleJMEApplet.this.status == 2 || SimpleJMEApplet.this.status == 0) {
                            SimpleJMEApplet.this.glCanvas.repaint();
                        }
                        try {
                            Thread.sleep(SimpleJMEApplet.this.repaintSleepTime);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void simpleAppletSetup() {
    }

    public void simpleAppletUpdate() {
    }

    public void simpleAppletRender() {
    }

    public Camera getCamera() {
        return this.impl.getCamera();
    }

    public Renderer getRenderer() {
        return this.impl.getRenderer();
    }

    public Node getRootNode() {
        return this.impl.getRootNode();
    }

    public Node getFPSNode() {
        return this.impl.getFPSNode();
    }

    public float getTimePerFrame() {
        return this.impl.getTimePerFrame();
    }

    public LightState getLightState() {
        return this.impl.getLightState();
    }

    public WireframeState getWireframeState() {
        return this.impl.getWireframeState();
    }

    public InputHandler getInputHandler() {
        return this.impl.getInputHandler();
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.impl.setInputHandler(inputHandler);
    }

    class SimpleAppletCanvasImplementor
    extends SimpleCanvasImpl {
        protected boolean showDepth;
        protected boolean showBounds;
        protected boolean showNormals;
        protected boolean pause;
        protected WireframeState wireState;
        private InputHandler input;
        protected LightState lightState;
        protected Node fpsNode;
        protected Text fps;
        protected StringBuffer tempBuffer;
        protected StringBuffer updateBuffer;

        protected SimpleAppletCanvasImplementor(int n, int n2) {
            super(n, n2);
            this.showDepth = false;
            this.showBounds = false;
            this.showNormals = false;
            this.tempBuffer = new StringBuffer();
            this.updateBuffer = new StringBuffer(30);
        }

        public Node getFPSNode() {
            return this.fpsNode;
        }

        public LightState getLightState() {
            return this.lightState;
        }

        public WireframeState getWireframeState() {
            return this.wireState;
        }

        public InputHandler getInputHandler() {
            return this.input;
        }

        public void setInputHandler(InputHandler inputHandler) {
            this.input = inputHandler;
        }

        public void simpleUpdate() {
            this.input.update(this.tpf);
            SimpleJMEApplet.this.simpleAppletUpdate();
            this.updateBuffer.setLength(0);
            this.updateBuffer.append("FPS: ").append((int)this.timer.getFrameRate()).append(" - ");
            this.updateBuffer.append(this.renderer.getStatistics(this.tempBuffer));
            this.fps.print(this.updateBuffer);
            this.renderer.clearStatistics();
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_pause", false)) {
                boolean bl = this.pause = !this.pause;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_wire", false)) {
                this.wireState.setEnabled(!this.wireState.isEnabled());
                this.rootNode.updateRenderState();
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_lights", false)) {
                this.lightState.setEnabled(!this.lightState.isEnabled());
                this.rootNode.updateRenderState();
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_bounds", false)) {
                boolean bl = this.showBounds = !this.showBounds;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_depth", false)) {
                boolean bl = this.showDepth = !this.showDepth;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_normals", false)) {
                boolean bl = this.showNormals = !this.showNormals;
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("camera_out", false)) {
                System.err.println("Camera at: " + this.renderer.getCamera().getLocation());
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("screen_shot", false)) {
                this.renderer.takeScreenShot("SimpleAppletScreenShot");
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("mem_report", false)) {
                long l = Runtime.getRuntime().totalMemory();
                long l2 = Runtime.getRuntime().freeMemory();
                long l3 = Runtime.getRuntime().maxMemory();
                System.err.println("|*|*|  Memory Stats  |*|*|");
                System.err.println("Total memory: " + (l >> 10) + " kb");
                System.err.println("Free memory: " + (l2 >> 10) + " kb");
                System.err.println("Max memory: " + (l3 >> 10) + " kb");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void simpleSetup() {
            String string = SimpleJMEApplet.INIT_LOCK;
            synchronized (SimpleJMEApplet.INIT_LOCK) {
                this.input = new FirstPersonHandler(this.getCamera(), 50.0f, 1.0f);
                this.wireState = this.renderer.createWireframeState();
                this.wireState.setEnabled(false);
                this.rootNode.setRenderState((RenderState)this.wireState);
                PointLight pointLight = new PointLight();
                pointLight.setDiffuse(new ColorRGBA(0.75f, 0.75f, 0.75f, 0.75f));
                pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
                pointLight.setLocation(new Vector3f(100.0f, 100.0f, 100.0f));
                pointLight.setEnabled(true);
                this.lightState = this.renderer.createLightState();
                this.lightState.setEnabled(true);
                this.lightState.attach((Light)pointLight);
                this.rootNode.setRenderState((RenderState)this.lightState);
                this.fps = Text.createDefaultTextLabel((String)"FPS label");
                this.fps.setCullMode(3);
                this.fps.setTextureCombineMode(5);
                this.fpsNode = new Node("FPS node");
                this.fpsNode.setRenderState(this.fps.getRenderState(0));
                this.fpsNode.setRenderState(this.fps.getRenderState(6));
                this.fpsNode.attachChild((Spatial)this.fps);
                this.fpsNode.setCullMode(3);
                this.renderer.enableStatistics(true);
                this.fpsNode.updateGeometricState(0.0f, true);
                this.fpsNode.updateRenderState();
                try {
                    SimpleJMEApplet.this.simpleAppletSetup();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                KeyBindingManager.getKeyBindingManager().set("toggle_pause", 25);
                KeyBindingManager.getKeyBindingManager().set("toggle_wire", 20);
                KeyBindingManager.getKeyBindingManager().set("toggle_lights", 38);
                KeyBindingManager.getKeyBindingManager().set("toggle_bounds", 48);
                KeyBindingManager.getKeyBindingManager().set("toggle_normals", 49);
                KeyBindingManager.getKeyBindingManager().set("camera_out", 46);
                KeyBindingManager.getKeyBindingManager().set("screen_shot", 59);
                KeyBindingManager.getKeyBindingManager().set("exit", 1);
                KeyBindingManager.getKeyBindingManager().set("mem_report", 19);
                SimpleJMEApplet.this.status = 1;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void simpleRender() {
            SimpleJMEApplet.this.simpleAppletRender();
            this.fpsNode.draw(this.renderer);
        }
    }
}

