/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.lwjgl;

import com.jme.input.InputSystem;
import com.jme.renderer.ColorRGBA;
import com.jme.system.DisplaySystem;
import com.jme.system.lwjgl.LWJGLDisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jmex.awt.JMECanvas;
import com.jmex.awt.JMECanvasImplementor;
import java.awt.Color;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.PixelFormat;

public class LWJGLCanvas
extends AWTGLCanvas
implements JMECanvas {
    private static final long serialVersionUID = 1L;
    private JMECanvasImplementor impl;
    private static final String PAINT_LOCK = "INIT_LOCK";
    private boolean updateInput = false;

    public LWJGLCanvas() throws LWJGLException {
        super(LWJGLCanvas.generatePixelFormat());
    }

    private static PixelFormat generatePixelFormat() {
        return ((LWJGLDisplaySystem)DisplaySystem.getDisplaySystem()).getFormat();
    }

    public void setVSync(boolean bl) {
        this.setVSyncEnabled(bl);
    }

    public void setImplementor(JMECanvasImplementor jMECanvasImplementor) {
        this.impl = jMECanvasImplementor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintGL() {
        String string = PAINT_LOCK;
        synchronized (PAINT_LOCK) {
            try {
                DisplaySystem.getDisplaySystem().setCurrentCanvas((JMECanvas)this);
                if (this.updateInput) {
                    InputSystem.update();
                }
                if (!this.impl.isSetup()) {
                    this.impl.doSetup();
                }
                GameTaskQueueManager.getManager().getQueue("update").execute();
                this.impl.doUpdate();
                GameTaskQueueManager.getManager().getQueue("render").execute();
                this.impl.doRender();
                this.swapBuffers();
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
            }
            return;
        }
    }

    public void setBackground(Color color) {
        this.impl.setBackground(this.makeColorRGBA(color));
    }

    protected ColorRGBA makeColorRGBA(Color color) {
        return new ColorRGBA((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    public boolean doUpdateInput() {
        return this.updateInput;
    }

    public void setUpdateInput(boolean bl) {
        this.updateInput = bl;
    }
}

