/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.swingui;

import com.jme.input.InputHandler;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.system.DisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jmex.awt.swingui.JMEDesktop;
import com.jmex.game.state.GameState;
import java.awt.Color;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class JMEDesktopState
extends GameState {
    private boolean variableDesktopSize;
    private Node guiNode;
    private InputHandler guiInput;
    private JMEDesktop desktop;
    private Node rootNode;
    private int width;
    private int height;

    public JMEDesktopState() {
        this(800, 600);
    }

    public JMEDesktopState(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.init();
    }

    public JMEDesktopState(boolean bl) {
        this.variableDesktopSize = bl;
        this.init();
    }

    private void init() {
        this.guiNode = new Node("GUI");
        this.guiNode.setCullMode(3);
        this.guiNode.setLightCombineMode(0);
        this.rootNode = new Node("RootNode");
        this.guiInput = new InputHandler();
        this.guiInput.setEnabled(true);
        Future future = GameTaskQueueManager.getManager().update((Callable)new Callable<JMEDesktop>(){

            @Override
            public JMEDesktop call() throws Exception {
                if (JMEDesktopState.this.variableDesktopSize) {
                    return new JMEDesktop("Desktop", DisplaySystem.getDisplaySystem().getWidth(), DisplaySystem.getDisplaySystem().getHeight(), JMEDesktopState.this.guiInput);
                }
                return new JMEDesktop("Desktop", JMEDesktopState.this.width, JMEDesktopState.this.height, JMEDesktopState.this.guiInput);
            }
        });
        try {
            this.desktop = (JMEDesktop)((Object)future.get());
            this.desktop.getJDesktop().setName("Desktop");
            this.desktop.getJDesktop().setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
            this.desktop.getJDesktop().setOpaque(true);
            this.guiNode.attachChild((Spatial)this.desktop);
            this.guiNode.getLocalTranslation().set((float)(DisplaySystem.getDisplaySystem().getWidth() / 2), (float)(DisplaySystem.getDisplaySystem().getHeight() / 2), 0.0f);
            this.guiNode.getLocalScale().set(1.0f, 1.0f, 1.0f);
            this.guiNode.updateRenderState();
            this.guiNode.updateGeometricState(0.0f, true);
            this.guiNode.setRenderQueueMode(4);
            this.guiNode.updateGeometricState(0.0f, true);
            this.guiNode.updateRenderState();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        this.buildUI();
    }

    protected void buildUI() {
    }

    public void update(float f) {
        this.guiInput.update(f);
        this.guiNode.updateGeometricState(f, true);
        this.rootNode.updateGeometricState(f, true);
    }

    public void render(float f) {
        DisplaySystem.getDisplaySystem().getRenderer().draw((Spatial)this.guiNode);
        DisplaySystem.getDisplaySystem().getRenderer().draw((Spatial)this.rootNode);
    }

    public void cleanup() {
        this.desktop.dispose();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public JMEDesktop getDesktop() {
        return this.desktop;
    }

    public InputHandler getInputHandler() {
        return this.guiInput;
    }
}

