/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.system.JmeException;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.BinaryFileReader;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.Face;
import com.jmex.model.XMLparser.Converters.FormatConverter;
import com.jmex.model.animation.KeyframeController;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class Md2ToJme
extends FormatConverter {
    public static void main(String[] stringArray) {
        new DummyDisplaySystem();
        new Md2ToJme().attemptFileConvert(stringArray);
    }

    public void convert(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("Unable to load null streams");
        }
        Md2ConverterCopy md2ConverterCopy = new Md2ConverterCopy(inputStream);
        Node node = new Node(md2ConverterCopy.tm.getName());
        node.attachChild((Spatial)md2ConverterCopy.tm);
        BinaryExporter.getInstance().save((Savable)node, outputStream);
    }

    public static KeyframeController findController(Node node) {
        if (node.getQuantity() == 0 || node.getChild(0).getControllers().size() == 0 || !(node.getChild(0).getController(0) instanceof KeyframeController)) {
            return null;
        }
        return (KeyframeController)node.getChild(0).getController(0);
    }

    private static class Md2ConverterCopy {
        private static final long serialVersionUID = 1L;
        private BinaryFileReader bis = null;
        private Header header;
        private Vector2f[] texCoords;
        private Md2Face[] triangles;
        private Md2Frame[] frames;
        private TriMesh[] triMesh;
        private KeyframeController controller;
        public TriMesh tm = new TriMesh("MD2 mesh" + new Random().nextInt());

        public Md2ConverterCopy(InputStream inputStream) {
            if (null == inputStream) {
                throw new JmeException("Null data. Cannot load.");
            }
            this.bis = new BinaryFileReader(inputStream);
            this.header = new Header();
            if (this.header.version != 8) {
                throw new JmeException("Invalid file format (Version not 8)!");
            }
            this.parseMesh();
            this.convertDataStructures();
            this.triangles = null;
            this.texCoords = null;
            this.frames = null;
        }

        public Controller getAnimationController() {
            return this.controller;
        }

        private void parseMesh() {
            int n;
            String[] stringArray = new String[this.header.numSkins];
            this.texCoords = new Vector2f[this.header.numTexCoords];
            this.triangles = new Md2Face[this.header.numTriangles];
            this.frames = new Md2Frame[this.header.numFrames];
            this.bis.setOffset(this.header.offsetSkins);
            for (n = 0; n < this.header.numSkins; ++n) {
                stringArray[n] = this.bis.readString(64);
            }
            this.bis.setOffset(this.header.offsetTexCoords);
            for (n = 0; n < this.header.numTexCoords; ++n) {
                this.texCoords[n] = new Vector2f();
                this.texCoords[n].x = this.bis.readShort();
                this.texCoords[n].y = this.bis.readShort();
            }
            this.bis.setOffset(this.header.offsetTriangles);
            for (n = 0; n < this.header.numTriangles; ++n) {
                this.triangles[n] = new Md2Face();
            }
            this.bis.setOffset(this.header.offsetFrames);
            for (n = 0; n < this.header.numFrames; ++n) {
                VectorKeyframe vectorKeyframe = new VectorKeyframe();
                this.frames[n] = new Md2Frame();
                this.frames[n].vertices = new Triangle[this.header.numVertices];
                Vector3f[] vector3fArray = new Vector3f[this.header.numVertices];
                int[] nArray = new int[this.header.numVertices];
                for (int i = 0; i < this.header.numVertices; ++i) {
                    vector3fArray[i] = new Vector3f((float)this.bis.readByte(), (float)this.bis.readByte(), (float)this.bis.readByte());
                    nArray[i] = this.bis.readByte();
                }
                this.frames[n].name = vectorKeyframe.name;
                Triangle[] triangleArray = this.frames[n].vertices;
                for (int i = 0; i < this.header.numVertices; ++i) {
                    triangleArray[i] = new Triangle();
                    triangleArray[i].vertex.x = vector3fArray[i].x * ((VectorKeyframe)vectorKeyframe).scale.x + ((VectorKeyframe)vectorKeyframe).translate.x;
                    triangleArray[i].vertex.z = -1.0f * (vector3fArray[i].y * ((VectorKeyframe)vectorKeyframe).scale.y + ((VectorKeyframe)vectorKeyframe).translate.y);
                    triangleArray[i].vertex.y = vector3fArray[i].z * ((VectorKeyframe)vectorKeyframe).scale.z + ((VectorKeyframe)vectorKeyframe).translate.z;
                }
            }
        }

        private void convertDataStructures() {
            this.triMesh = new TriMesh[this.header.numFrames];
            Vector2f[] vector2fArray = new Vector2f[this.header.numVertices];
            this.controller = new KeyframeController();
            for (int i = 0; i < this.header.numFrames; ++i) {
                int n;
                int n2 = this.header.numVertices;
                int n3 = this.header.numTexCoords;
                int n4 = this.header.numTriangles;
                this.triMesh[i] = i != 0 ? new TriMesh() : this.tm;
                Vector3f[] vector3fArray = new Vector3f[n2];
                Vector2f[] vector2fArray2 = new Vector2f[n3];
                Face[] faceArray = new Face[n4];
                for (n = 0; n < n2; ++n) {
                    vector3fArray[n] = i != 0 ? this.frames[i].vertices[n].vertex : new Vector3f(this.frames[i].vertices[n].vertex);
                }
                for (n = 0; n < n4; ++n) {
                    faceArray[n] = new Face();
                    faceArray[n].vertIndex[0] = this.triangles[n].vertexIndices[0];
                    faceArray[n].vertIndex[1] = this.triangles[n].vertexIndices[1];
                    faceArray[n].vertIndex[2] = this.triangles[n].vertexIndices[2];
                    faceArray[n].coordIndex[0] = this.triangles[n].textureIndices[0];
                    faceArray[n].coordIndex[1] = this.triangles[n].textureIndices[1];
                    faceArray[n].coordIndex[2] = this.triangles[n].textureIndices[2];
                }
                if (i == 0) {
                    int n5;
                    for (n = 0; n < n3; ++n) {
                        vector2fArray2[n] = new Vector2f();
                        vector2fArray2[n].x = this.texCoords[n].x / (float)this.header.skinWidth;
                        vector2fArray2[n].y = 1.0f - this.texCoords[n].y / (float)this.header.skinHeight;
                    }
                    if (n3 != 0) {
                        for (n = 0; n < n4; ++n) {
                            n5 = faceArray[n].vertIndex[0];
                            vector2fArray[n5] = vector2fArray2[faceArray[n].coordIndex[0]];
                            n5 = faceArray[n].vertIndex[1];
                            vector2fArray[n5] = vector2fArray2[faceArray[n].coordIndex[1]];
                            n5 = faceArray[n].vertIndex[2];
                            vector2fArray[n5] = vector2fArray2[faceArray[n].coordIndex[2]];
                        }
                    }
                    int[] nArray = new int[n4 * 3];
                    n5 = 0;
                    for (int j = 0; j < n4; ++j) {
                        nArray[n5] = faceArray[j].vertIndex[0];
                        nArray[++n5] = faceArray[j].vertIndex[1];
                        nArray[++n5] = faceArray[j].vertIndex[2];
                        ++n5;
                    }
                    this.triMesh[i].setIndexBuffer(0, BufferUtils.createIntBuffer((int[])nArray));
                    this.triMesh[i].setTextureBuffer(0, BufferUtils.createFloatBuffer((Vector2f[])vector2fArray));
                    this.controller.setMorphingMesh(this.triMesh[i]);
                }
                this.triMesh[i].setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])vector3fArray));
                this.triMesh[i].setNormalBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])this.computeNormals(faceArray, vector3fArray)));
                if (i == 0) continue;
                this.controller.setKeyframe(i - 1, this.triMesh[i]);
            }
            this.tm.addController((Controller)this.controller);
        }

        private Vector3f[] computeNormals(Face[] faceArray, Vector3f[] vector3fArray) {
            Vector3f[] vector3fArray2 = new Vector3f[vector3fArray.length];
            Vector3f[] vector3fArray3 = new Vector3f[faceArray.length];
            for (int i = 0; i < faceArray.length; ++i) {
                vector3fArray3[i] = vector3fArray[faceArray[i].vertIndex[0]].subtract(vector3fArray[faceArray[i].vertIndex[2]]).cross(vector3fArray[faceArray[i].vertIndex[2]].subtract(vector3fArray[faceArray[i].vertIndex[1]]));
            }
            Vector3f vector3f = new Vector3f();
            int n = 0;
            for (int i = 0; i < vector3fArray.length; ++i) {
                for (int j = 0; j < faceArray.length; ++j) {
                    if (faceArray[j].vertIndex[0] != i && faceArray[j].vertIndex[1] != i && faceArray[j].vertIndex[2] != i) continue;
                    vector3f.addLocal(vector3fArray3[j]);
                    ++n;
                }
                vector3fArray2[i] = vector3f.divide((float)(-n));
                vector3fArray2[i].normalizeLocal().negateLocal();
                vector3f.zero();
                n = 0;
            }
            return vector3fArray2;
        }

        private class Md2Frame {
            String name;
            Triangle[] vertices;

            Md2Frame() {
            }
        }

        private class VectorKeyframe {
            private Vector3f scale = new Vector3f();
            private Vector3f translate = new Vector3f();
            private String name;

            VectorKeyframe() {
                this.scale.x = Md2ConverterCopy.this.bis.readFloat();
                this.scale.y = Md2ConverterCopy.this.bis.readFloat();
                this.scale.z = Md2ConverterCopy.this.bis.readFloat();
                this.translate.x = Md2ConverterCopy.this.bis.readFloat();
                this.translate.y = Md2ConverterCopy.this.bis.readFloat();
                this.translate.z = Md2ConverterCopy.this.bis.readFloat();
                this.name = Md2ConverterCopy.this.bis.readString(16);
            }
        }

        private class Md2Face {
            int[] vertexIndices = new int[3];
            int[] textureIndices = new int[3];

            Md2Face() {
                this.vertexIndices = new int[]{Md2ConverterCopy.this.bis.readShort(), Md2ConverterCopy.this.bis.readShort(), Md2ConverterCopy.this.bis.readShort()};
                this.textureIndices = new int[]{Md2ConverterCopy.this.bis.readShort(), Md2ConverterCopy.this.bis.readShort(), Md2ConverterCopy.this.bis.readShort()};
            }
        }

        private class Triangle {
            Vector3f vertex = new Vector3f();
            Vector3f normal = new Vector3f();

            private Triangle() {
            }
        }

        private class Header {
            int magic;
            int version;
            int skinWidth;
            int skinHeight;
            int frameSize;
            int numSkins;
            int numVertices;
            int numTexCoords;
            int numTriangles;
            int numGlCommands;
            int numFrames;
            int offsetSkins;
            int offsetTexCoords;
            int offsetTriangles;
            int offsetFrames;
            int offsetGlCommands;
            int offsetEnd;

            Header() {
                this.magic = Md2ConverterCopy.this.bis.readInt();
                this.version = Md2ConverterCopy.this.bis.readInt();
                this.skinWidth = Md2ConverterCopy.this.bis.readInt();
                this.skinHeight = Md2ConverterCopy.this.bis.readInt();
                this.frameSize = Md2ConverterCopy.this.bis.readInt();
                this.numSkins = Md2ConverterCopy.this.bis.readInt();
                this.numVertices = Md2ConverterCopy.this.bis.readInt();
                this.numTexCoords = Md2ConverterCopy.this.bis.readInt();
                this.numTriangles = Md2ConverterCopy.this.bis.readInt();
                this.numGlCommands = Md2ConverterCopy.this.bis.readInt();
                this.numFrames = Md2ConverterCopy.this.bis.readInt();
                this.offsetSkins = Md2ConverterCopy.this.bis.readInt();
                this.offsetTexCoords = Md2ConverterCopy.this.bis.readInt();
                this.offsetTriangles = Md2ConverterCopy.this.bis.readInt();
                this.offsetFrames = Md2ConverterCopy.this.bis.readInt();
                this.offsetGlCommands = Md2ConverterCopy.this.bis.readInt();
                this.offsetEnd = Md2ConverterCopy.this.bis.readInt();
            }
        }
    }
}

