/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters.TDSChunkingFiles;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jmex.model.XMLparser.Converters.FormatConverter;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkHeader;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkerClass;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ColorChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.DistanceQueueChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.FogChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.LayeredFogChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.MaterialBlock;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.NamedObjectChunk;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;

class EditableObjectChunk
extends ChunkerClass {
    HashMap materialBlocks;
    HashMap namedObjects;
    float masterScale;
    float shadowMapRange;
    float rayTraceBias;
    Vector3f oConstPlanes;
    ColorRGBA genAmbientColor;
    ColorRGBA backGroundColor;
    String backGroundBigMap;
    boolean useBackColor;
    float shadowBias;
    short shadowMapSize;
    LayeredFogChunk fogOptions;
    FogChunk myFog;
    DistanceQueueChunk distanceQueue;
    FormatConverter formatConverter;

    public EditableObjectChunk(DataInput dataInput, ChunkHeader chunkHeader, FormatConverter formatConverter) throws IOException {
        super(dataInput);
        this.formatConverter = formatConverter;
        this.setHeader(chunkHeader);
        this.initializeVariables();
        this.chunk();
    }

    protected void initializeVariables() {
        this.materialBlocks = new HashMap();
        this.namedObjects = new HashMap();
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 15678: {
                this.readMeshVersion();
                return true;
            }
            case 45055: {
                MaterialBlock materialBlock = new MaterialBlock(this.myIn, chunkHeader, this.formatConverter);
                this.materialBlocks.put(materialBlock.name, materialBlock);
                return true;
            }
            case 256: {
                this.readMasterScale();
                return true;
            }
            case 16384: {
                NamedObjectChunk namedObjectChunk = new NamedObjectChunk(this.myIn, chunkHeader);
                this.namedObjects.put(namedObjectChunk.name, namedObjectChunk);
                return true;
            }
            case 28673: {
                this.skipSize(chunkHeader.length);
                return true;
            }
            case 5200: {
                this.readShadowRange();
                return true;
            }
            case 5216: {
                this.readRayTraceBias();
                return true;
            }
            case 5376: {
                this.readOConst();
                return true;
            }
            case 8448: {
                this.genAmbientColor = new ColorChunk(this.myIn, chunkHeader).getBestColor();
                return true;
            }
            case 4608: {
                this.backGroundColor = new ColorChunk(this.myIn, chunkHeader).getBestColor();
                return true;
            }
            case 4352: {
                this.backGroundBigMap = this.readcStr();
                return true;
            }
            case 4864: {
                this.skipSize(chunkHeader.length);
                return true;
            }
            case 4609: {
                this.useBackColor = true;
                return true;
            }
            case 8704: {
                this.myFog = new FogChunk(this.myIn, chunkHeader);
                return true;
            }
            case 5120: {
                this.readShadowBias();
                return true;
            }
            case 5152: {
                this.readShadowMapSize();
                return true;
            }
            case 8962: {
                this.fogOptions = new LayeredFogChunk(this.myIn, chunkHeader);
                return true;
            }
            case 8960: {
                this.distanceQueue = new DistanceQueueChunk(this.myIn, chunkHeader);
                return true;
            }
            case 12288: {
                this.skipSize(chunkHeader.length);
                return true;
            }
            case 1: {
                this.skipSize(chunkHeader.length);
                return true;
            }
        }
        return false;
    }

    private void readOConst() throws IOException {
        this.oConstPlanes = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Planes:" + this.oConstPlanes);
        }
    }

    private void readRayTraceBias() throws IOException {
        this.rayTraceBias = this.myIn.readFloat();
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Raytrace bias:" + this.rayTraceBias);
        }
    }

    private void readShadowRange() throws IOException {
        this.shadowMapRange = this.myIn.readFloat();
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Shadow map range:" + this.shadowMapRange);
        }
    }

    private void readMasterScale() throws IOException {
        this.masterScale = this.myIn.readFloat();
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Master scale:" + this.masterScale);
        }
    }

    private void readMeshVersion() throws IOException {
        int n = this.myIn.readInt();
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Mesh version:" + n);
        }
    }

    private void readShadowBias() throws IOException {
        this.shadowBias = this.myIn.readFloat();
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Bias:" + this.shadowBias);
        }
    }

    private void readShadowMapSize() throws IOException {
        this.shadowMapSize = this.myIn.readShort();
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Shadow map siz:" + this.shadowMapSize);
        }
    }
}

