/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters.TDSChunkingFiles;

import com.jme.animation.SpatialTransformer;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.TransformMatrix;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.XMLparser.Converters.FormatConverter;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkHeader;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkerClass;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.EditableObjectChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.FacesChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.KeyframeChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.KeyframeInfoChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.LightChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.MaterialBlock;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.NamedObjectChunk;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.TriMeshChunk;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TDSFile
extends ChunkerClass {
    private EditableObjectChunk objects = null;
    private KeyframeChunk keyframes = null;
    private List<Spatial> spatialNodes;
    private List<String> spatialNodesNames;
    private SpatialTransformer st;
    private List<Light> spatialLights;
    private AlphaState alpha;
    private FormatConverter formatConverter;

    public TDSFile(DataInput dataInput, FormatConverter formatConverter) throws IOException {
        super(dataInput);
        this.formatConverter = formatConverter;
        ChunkHeader chunkHeader = new ChunkHeader(dataInput);
        if (chunkHeader.type != 19789) {
            throw new IOException("Header doesn't match 0x4D4D; Header=" + Integer.toHexString(chunkHeader.type));
        }
        chunkHeader.length -= 6;
        this.setHeader(chunkHeader);
        this.chunk();
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 2: {
                this.readVersion();
                return true;
            }
            case 15677: {
                this.objects = new EditableObjectChunk(this.myIn, chunkHeader, this.formatConverter);
                return true;
            }
            case 45056: {
                this.keyframes = new KeyframeChunk(this.myIn, chunkHeader);
                return true;
            }
        }
        return false;
    }

    private void readVersion() throws IOException {
        int n = this.myIn.readInt();
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Version:" + n);
        }
    }

    public Node buildScene() throws IOException {
        this.buildObject();
        this.putTranslations();
        Node node = new Node("TDS Scene");
        for (Spatial object : this.spatialNodes) {
            Spatial spatial;
            if (object == null || (spatial = object).getParent() != null) continue;
            node.attachChild(spatial);
        }
        LightState lightState = null;
        for (Light light : this.spatialLights) {
            if (lightState == null) {
                lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
                lightState.setEnabled(true);
            }
            lightState.attach(light);
        }
        if (lightState != null) {
            node.setRenderState(lightState);
        }
        if (this.keyframes != null) {
            this.st.interpolateMissing();
            if (this.st.keyframes.size() == 1) {
                this.st.update(0.0f);
            } else {
                node.addController((Controller)this.st);
                this.st.setActive(true);
            }
        }
        return node;
    }

    private void putTranslations() {
        Object[] objectArray;
        if (this.keyframes == null) {
            return;
        }
        int n = 0;
        for (Spatial objectArray2 : this.spatialNodes) {
            if (objectArray2 == null) continue;
            ++n;
        }
        this.st = new SpatialTransformer(n);
        n = 0;
        for (int i = 0; i < this.spatialNodes.size(); ++i) {
            if (this.spatialNodes.get(i) == null) continue;
            this.st.setObject(this.spatialNodes.get(i), n++, -1);
        }
        for (Object object : objectArray = this.keyframes.objKeyframes.keySet().toArray()) {
            KeyframeInfoChunk keyframeInfoChunk = (KeyframeInfoChunk)this.keyframes.objKeyframes.get(object);
            if ("$$$DUMMY".equals(keyframeInfoChunk.name)) continue;
            int n2 = this.findIndex(keyframeInfoChunk.name);
            for (Object e : keyframeInfoChunk.track) {
                KeyframeInfoChunk.KeyPointInTime keyPointInTime = (KeyframeInfoChunk.KeyPointInTime)e;
                if (keyPointInTime.rot != null) {
                    this.st.setRotation(n2, (float)keyPointInTime.frame, keyPointInTime.rot);
                }
                if (keyPointInTime.position != null) {
                    this.st.setPosition(n2, (float)keyPointInTime.frame, keyPointInTime.position);
                }
                if (keyPointInTime.scale == null) continue;
                this.st.setScale(n2, (float)keyPointInTime.frame, keyPointInTime.scale);
            }
        }
        this.st.setSpeed(10.0f);
    }

    private int findIndex(String string) {
        int n = 0;
        for (int i = 0; i < this.spatialNodesNames.size(); ++i) {
            if (this.spatialNodesNames.get(i).equals(string)) {
                return n;
            }
            if (this.spatialNodes.get(i) == null) continue;
            ++n;
        }
        throw new JmeException("Logic error.  Unknown keyframe name " + string);
    }

    private int getParentIndex(int n) {
        if (this.keyframes.objKeyframes.get(this.spatialNodesNames.get(n)) == null) {
            return -2;
        }
        short s = ((KeyframeInfoChunk)this.keyframes.objKeyframes.get((Object)this.spatialNodesNames.get((int)n))).parent;
        if (s == -1) {
            return -1;
        }
        Object[] objectArray = this.keyframes.objKeyframes.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((KeyframeInfoChunk)this.keyframes.objKeyframes.get((Object)objectArray[i])).myID != s) continue;
            return i;
        }
        throw new JmeException("Logic error.  Unknown parent ID for " + n);
    }

    private void buildObject() throws IOException {
        Object object;
        ChunkerClass chunkerClass;
        Object object2;
        Map.Entry entry;
        Map.Entry entry22;
        this.spatialNodes = new ArrayList<Spatial>();
        this.spatialLights = new ArrayList<Light>();
        this.spatialNodesNames = new ArrayList<String>();
        HashMap<Short, Node> hashMap = new HashMap<Short, Node>();
        if (this.keyframes != null) {
            for (Map.Entry entry22 : this.keyframes.objKeyframes.entrySet()) {
                entry = entry22;
                object2 = (String)entry.getKey();
                if (this.objects.namedObjects.containsKey(object2)) continue;
                chunkerClass = (KeyframeInfoChunk)entry.getValue();
                object = new Node(((KeyframeInfoChunk)chunkerClass).name);
                hashMap.put(((KeyframeInfoChunk)chunkerClass).myID, (Node)object);
                this.spatialNodesNames.add((String)object2);
                this.spatialNodes.add((Spatial)object);
            }
        }
        Iterator iterator = this.objects.namedObjects.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = entry22 = iterator.next();
            object2 = (String)entry.getKey();
            chunkerClass = (NamedObjectChunk)entry.getValue();
            object = null;
            if (this.keyframes != null && this.keyframes.objKeyframes != null) {
                object = (KeyframeInfoChunk)this.keyframes.objKeyframes.get(object2);
            }
            if (chunkerClass.whatIAm instanceof TriMeshChunk) {
                Node node;
                Node node2 = new Node((String)object2);
                if (object == null) {
                    this.putChildMeshes(node2, (TriMeshChunk)chunkerClass.whatIAm, new Vector3f(0.0f, 0.0f, 0.0f));
                    node = this.usedSpatial(node2);
                } else {
                    this.putChildMeshes(node2, (TriMeshChunk)chunkerClass.whatIAm, object.pivot);
                    node = node2;
                    hashMap.put(object.myID, node2);
                }
                this.spatialNodesNames.add(chunkerClass.name);
                this.spatialNodes.add((Spatial)node);
                continue;
            }
            if (!(chunkerClass.whatIAm instanceof LightChunk)) continue;
            this.spatialLights.add(this.createChildLight((LightChunk)chunkerClass.whatIAm));
        }
        if (this.keyframes != null) {
            iterator = this.keyframes.objKeyframes.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = entry22 = iterator.next();
                object2 = (KeyframeInfoChunk)entry.getValue();
                if (((KeyframeInfoChunk)object2).parent == -1 || (chunkerClass = (Node)hashMap.get(((KeyframeInfoChunk)object2).myID)) == null) continue;
                object = (Node)hashMap.get(((KeyframeInfoChunk)object2).parent);
                if (object != null) {
                    object.attachChild((Spatial)chunkerClass);
                    continue;
                }
                throw new JmeException("Parent node (id=" + ((KeyframeInfoChunk)object2).parent + ") not foudn!");
            }
        }
    }

    private Spatial usedSpatial(Node node) {
        Node node2;
        if (node.getQuantity() == 1) {
            node.getChild(0).setName(node.getName());
            node2 = node.getChild(0);
            node.detachChild((Spatial)node2);
        } else {
            node2 = node;
        }
        return node2;
    }

    private Light createChildLight(LightChunk lightChunk) {
        if (lightChunk.spotInfo != null) {
            SpotLight spotLight = new SpotLight();
            spotLight.setLocation(lightChunk.myLoc);
            spotLight.setDiffuse(lightChunk.lightColor);
            spotLight.setAmbient(ColorRGBA.black);
            spotLight.setSpecular(ColorRGBA.white);
            Vector3f vector3f = lightChunk.myLoc.subtract(lightChunk.spotInfo.target).multLocal(-1.0f);
            vector3f.normalizeLocal();
            spotLight.setDirection(vector3f);
            spotLight.setAngle(180.0f);
            spotLight.setEnabled(true);
            return spotLight;
        }
        PointLight pointLight = new PointLight();
        pointLight.setLocation(lightChunk.myLoc);
        pointLight.setDiffuse(lightChunk.lightColor);
        pointLight.setAmbient(ColorRGBA.black);
        pointLight.setSpecular(ColorRGBA.white);
        pointLight.setEnabled(true);
        return pointLight;
    }

    private void putChildMeshes(Node node, TriMeshChunk triMeshChunk, Vector3f vector3f) throws IOException {
        int n;
        int n2;
        FacesChunk facesChunk = triMeshChunk.face;
        if (facesChunk == null) {
            return;
        }
        boolean[] blArray = new boolean[facesChunk.nFaces];
        int n3 = facesChunk.nFaces;
        ArrayList<Vector3f> arrayList = new ArrayList<Vector3f>(facesChunk.nFaces);
        ArrayList<Vector3f> arrayList2 = new ArrayList<Vector3f>(facesChunk.nFaces);
        Vector3f vector3f2 = new Vector3f();
        ArrayList<Vector2f> arrayList3 = new ArrayList<Vector2f>(facesChunk.nFaces);
        if (triMeshChunk.coordSystem == null) {
            triMeshChunk.coordSystem = new TransformMatrix();
        }
        triMeshChunk.coordSystem.inverse();
        for (Vector3f vector3f3 : triMeshChunk.vertexes) {
            triMeshChunk.coordSystem.multPoint(vector3f3);
            vector3f3.subtractLocal(vector3f);
        }
        Vector3f[] vector3fArray = new Vector3f[facesChunk.nFaces];
        this.calculateFaceNormals(vector3fArray, triMeshChunk.vertexes, triMeshChunk.face.faces);
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Precaching");
        }
        int[] nArray = new int[triMeshChunk.vertexes.length];
        for (int i = 0; i < facesChunk.nFaces; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n4 = facesChunk.faces[i][j];
                nArray[n4] = nArray[n4] + 1;
            }
        }
        int[][] nArrayArray = new int[triMeshChunk.vertexes.length][];
        for (n2 = 0; n2 < nArrayArray.length; ++n2) {
            nArrayArray[n2] = new int[nArray[n2]];
        }
        for (int i = 0; i < facesChunk.nFaces; ++i) {
            for (n = 0; n < 3; ++n) {
                int n5 = n2 = facesChunk.faces[i][n];
                int n6 = nArray[n5] - 1;
                nArray[n5] = n6;
                nArrayArray[n2][n6] = i;
            }
        }
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Precaching done");
        }
        int[] nArray2 = new int[facesChunk.nFaces * 3];
        for (n = 0; n < facesChunk.materialIndexes.size(); ++n) {
            int n7;
            String string = (String)facesChunk.materialNames.get(n);
            int[] nArray3 = (int[])facesChunk.materialIndexes.get(n);
            if (DEBUG_LIGHT || DEBUG) {
                System.out.println("On material " + string + " with " + nArray3.length + " faces.");
            }
            if (nArray3.length == 0) continue;
            TriMesh triMesh = new TriMesh(node.getName() + "##" + n);
            arrayList.clear();
            arrayList2.clear();
            arrayList3.clear();
            int n8 = 0;
            for (int i = 0; i < nArray3.length; ++i) {
                if (DEBUG && i % 500 == 0) {
                    System.out.println("Face:" + i);
                }
                if (!blArray[n7 = nArray3[i]]) {
                    blArray[n7] = true;
                    --n3;
                }
                for (int j = 0; j < 3; ++j) {
                    int n9;
                    n2 = facesChunk.faces[n7][j];
                    vector3f2.set(vector3fArray[n7]);
                    this.calcFacesWithVertexAndSmoothGroup(nArrayArray[n2], vector3fArray, facesChunk, vector3f2, n7);
                    Vector3f vector3f4 = triMeshChunk.vertexes[n2];
                    for (n9 = 0; !(n9 >= arrayList.size() || ((Vector3f)arrayList.get(n9)).equals((Object)vector3f2) && ((Vector3f)arrayList2.get(n9)).equals((Object)vector3f4)); ++n9) {
                    }
                    if (n9 == arrayList.size()) {
                        arrayList.add(new Vector3f(vector3f2));
                        arrayList2.add(triMeshChunk.vertexes[n2]);
                        if (triMeshChunk.texCoords != null) {
                            arrayList3.add(triMeshChunk.texCoords[n2]);
                        }
                        nArray2[n8++] = n9;
                        continue;
                    }
                    nArray2[n8++] = n9;
                }
            }
            Vector3f[] vector3fArray2 = new Vector3f[arrayList2.size()];
            for (n7 = 0; n7 < vector3fArray2.length; ++n7) {
                vector3fArray2[n7] = (Vector3f)arrayList2.get(n7);
            }
            triMesh.setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])vector3fArray2));
            triMesh.setNormalBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])arrayList.toArray(new Vector3f[0])));
            if (triMeshChunk.texCoords != null) {
                triMesh.setTextureBuffer(0, BufferUtils.createFloatBuffer((Vector2f[])arrayList3.toArray(new Vector2f[0])));
            }
            int[] nArray4 = new int[n8];
            System.arraycopy(nArray2, 0, nArray4, 0, n8);
            triMesh.setIndexBuffer(0, BufferUtils.createIntBuffer((int[])nArray4));
            MaterialBlock materialBlock = (MaterialBlock)this.objects.materialBlocks.get(string);
            if (string == null) {
                throw new IOException("Couldn't find the correct name of " + materialBlock);
            }
            if (materialBlock.myMatState.isEnabled()) {
                triMesh.setRenderState((RenderState)materialBlock.myMatState);
                if (materialBlock.myMatState.getDiffuse().a < 1.0f) {
                    triMesh.setRenderQueueMode(3);
                    if (this.alpha == null) {
                        this.alpha = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                        this.alpha.setEnabled(true);
                        this.alpha.setBlendEnabled(true);
                        this.alpha.setSrcFunction(4);
                        this.alpha.setDstFunction(5);
                        this.alpha.setTestEnabled(true);
                        this.alpha.setTestFunction(4);
                    }
                    triMesh.setRenderState((RenderState)this.alpha);
                }
            }
            if (materialBlock.myTexState.isEnabled()) {
                triMesh.setRenderState((RenderState)materialBlock.myTexState);
            }
            if (materialBlock.myWireState.isEnabled()) {
                triMesh.setRenderState((RenderState)materialBlock.myWireState);
            }
            node.attachChild((Spatial)triMesh);
        }
        if (n3 != 0) {
            int[] nArray5 = new int[n3 * 3];
            int n10 = 0;
            for (int i = 0; i < triMeshChunk.face.nFaces; ++i) {
                if (blArray[i]) continue;
                nArray5[n10++] = facesChunk.faces[i][0];
                nArray5[n10++] = facesChunk.faces[i][1];
                nArray5[n10++] = facesChunk.faces[i][2];
            }
            TriMesh triMesh = new TriMesh(node.getName() + "-1");
            triMesh.setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])triMeshChunk.vertexes));
            triMesh.setIndexBuffer(0, BufferUtils.createIntBuffer((int[])nArray5));
            node.attachChild((Spatial)triMesh);
        }
    }

    private void calculateFaceNormals(Vector3f[] vector3fArray, Vector3f[] vector3fArray2, int[][] nArray) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        for (int i = 0; i < vector3fArray.length; ++i) {
            vector3f.set(vector3fArray2[nArray[i][0]]);
            vector3f.subtractLocal(vector3fArray2[nArray[i][1]]);
            vector3f2.set(vector3fArray2[nArray[i][0]]);
            vector3f2.subtractLocal(vector3fArray2[nArray[i][2]]);
            vector3fArray[i] = vector3f.cross(vector3f2).normalizeLocal();
        }
    }

    private void calcFacesWithVertexAndSmoothGroup(int[] nArray, Vector3f[] vector3fArray, FacesChunk facesChunk, Vector3f vector3f, int n) {
        int n2 = facesChunk.smoothingGroups[n];
        if (n2 == 0) {
            return;
        }
        for (int n3 : nArray) {
            if (n3 == n || (facesChunk.smoothingGroups[n3] & n2) == 0) continue;
            vector3f.addLocal(vector3fArray[n3]);
        }
        vector3f.normalizeLocal();
    }
}

