/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser.Converters.TDSChunkingFiles;

import com.jme.math.Matrix3f;
import com.jme.math.TransformMatrix;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkHeader;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.ChunkerClass;
import com.jmex.model.XMLparser.Converters.TDSChunkingFiles.FacesChunk;
import java.io.DataInput;
import java.io.IOException;

class TriMeshChunk
extends ChunkerClass {
    Vector3f[] vertexes;
    Vector2f[] texCoords;
    Matrix3f rotation;
    Vector3f origin;
    private byte color;
    FacesChunk face;
    TransformMatrix coordSystem;

    public TriMeshChunk(DataInput dataInput, ChunkHeader chunkHeader) throws IOException {
        super(dataInput, chunkHeader);
    }

    protected boolean processChildChunk(ChunkHeader chunkHeader) throws IOException {
        switch (chunkHeader.type) {
            case 16656: {
                this.readVerts();
                return true;
            }
            case 16704: {
                this.readTexCoords();
                return true;
            }
            case 16736: {
                this.readCoordSystem();
                return true;
            }
            case 16672: {
                if (this.face != null) {
                    throw new IOException("Face already non-null... ut ow");
                }
                this.face = new FacesChunk(this.myIn, chunkHeader);
                return true;
            }
            case 16657: {
                this.readOptions();
                return true;
            }
            case 16741: {
                this.readMeshColor();
                return true;
            }
            case 16752: {
                this.readMeshTextureInfo();
                return true;
            }
        }
        return false;
    }

    private void readMeshTextureInfo() throws IOException {
        short s = this.myIn.readShort();
        float f = this.myIn.readFloat();
        float f2 = this.myIn.readFloat();
        float f3 = this.myIn.readFloat();
        float f4 = this.myIn.readFloat();
        float f5 = this.myIn.readFloat();
        float[][] fArray = new float[4][3];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                fArray[i][j] = this.myIn.readFloat();
            }
        }
        float f6 = this.myIn.readFloat();
        float f7 = this.myIn.readFloat();
        float f8 = this.myIn.readFloat();
        float f9 = this.myIn.readFloat();
    }

    private void readMeshColor() throws IOException {
        this.color = this.myIn.readByte();
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Mesh color read as " + this.color);
        }
    }

    private void readOptions() throws IOException {
        int n = this.myIn.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            short s = this.myIn.readShort();
        }
        if (DEBUG || DEBUG_LIGHT) {
            System.out.println("Options read");
        }
    }

    private void readCoordSystem() throws IOException {
        float[] fArray = new float[9];
        this.coordSystem = new TransformMatrix();
        this.rotation = new Matrix3f();
        for (int i = 0; i < 9; ++i) {
            fArray[i] = this.myIn.readFloat();
        }
        this.rotation.set(fArray);
        this.rotation.transposeLocal();
        this.coordSystem.setRotation(this.rotation);
        this.origin = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
        this.coordSystem.setTranslation(this.origin);
    }

    private void readTexCoords() throws IOException {
        this.texCoords = new Vector2f[this.myIn.readUnsignedShort()];
        for (int i = 0; i < this.texCoords.length; ++i) {
            this.texCoords[i] = new Vector2f(this.myIn.readFloat(), this.myIn.readFloat());
            if (!DEBUG) continue;
            System.out.println("TX#" + i + '=' + this.texCoords[i]);
        }
    }

    private void readVerts() throws IOException {
        this.vertexes = new Vector3f[this.myIn.readUnsignedShort()];
        for (int i = 0; i < this.vertexes.length; ++i) {
            this.vertexes[i] = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
            if (!DEBUG) continue;
            System.out.println("V#" + i + '=' + this.vertexes[i]);
        }
    }
}

