/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser;

import com.jme.animation.SpatialTransformer;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.image.Texture;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.lod.AreaClodMesh;
import com.jme.scene.lod.ClodMesh;
import com.jme.scene.lod.CollapseRecord;
import com.jme.scene.shape.Box;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.JointMesh;
import com.jmex.model.XMLparser.LoaderNode;
import com.jmex.model.XMLparser.XMLSharedNode;
import com.jmex.model.XMLparser.XMLloadable;
import com.jmex.model.animation.JointController;
import com.jmex.model.animation.KeyframeController;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.TerrainPage;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmeBinaryReader {
    private Stack<Object> objStack = new Stack();
    private Hashtable<String, Object> shares = new Hashtable();
    private HashMap<String, Object> attributes = new HashMap();
    private HashMap<String, Object> properties = new HashMap();
    private Hashtable<Object, Object> repeatShare = new Hashtable();
    private Node myScene;
    private Renderer renderer = DisplaySystem.getDisplaySystem().getRenderer();
    private DataInputStream myIn;
    private static final boolean DEBUG = false;

    public Node loadBinaryFormat(Node node, InputStream inputStream) throws IOException {
        this.clearValues();
        this.myScene = node;
        this.myIn = new DataInputStream(inputStream);
        this.readHeader();
        this.objStack.push(node);
        byte by = this.myIn.readByte();
        while (by != 2) {
            if (by == 0) {
                this.readBegining();
            } else if (by == 1) {
                this.readEnd();
            } else {
                throw new IOException("Unknown flag:" + by);
            }
            by = this.myIn.readByte();
        }
        this.clearValues();
        return this.myScene;
    }

    private void clearValues() {
        this.repeatShare.clear();
        this.objStack.clear();
        this.shares.clear();
        this.attributes.clear();
        this.myIn = null;
    }

    public Node loadBinaryFormat(InputStream inputStream) throws IOException {
        return this.loadBinaryFormat(new Node("XML loaded scene"), inputStream);
    }

    private void readBegining() throws IOException {
        Object object;
        String string = this.myIn.readUTF().trim();
        this.readInObjects(this.attributes);
        if (!string.equals("scene")) {
            if (string.equals("node")) {
                this.objStack.push(this.processSpatial((Spatial)new Node((String)this.attributes.get("name")), this.attributes));
            } else if (string.equals("terrainpage")) {
                this.objStack.push(this.processTerrainPage(new TerrainPage((String)this.attributes.get("name")), this.attributes));
            } else if (string.equals("repeatobject")) {
                this.objStack.push(this.repeatShare.get(this.attributes.get("ident")));
            } else if (string.equals("materialstate")) {
                this.objStack.push(this.buildMaterial(this.attributes));
            } else if (string.equals("alphastate")) {
                this.objStack.push(this.buildAlphaState(this.attributes));
            } else if (string.equals("texturestate")) {
                this.objStack.push(this.renderer.createTextureState());
            } else if (string.equals("texture")) {
                object = this.buildTexture(this.attributes);
                if (object != null) {
                    TextureState textureState = (TextureState)this.objStack.pop();
                    Integer n = (Integer)this.attributes.get("texnum");
                    int n2 = n == null ? 0 : n;
                    textureState.setTexture((Texture)object, n2);
                    this.objStack.push(textureState);
                }
            } else if (string.equals("clod")) {
                this.objStack.push(this.processSpatial((Spatial)new ClodMesh((String)this.attributes.get("name")), this.attributes));
            } else if (string.equals("obb")) {
                this.objStack.push(this.processOBB(new OrientedBoundingBox(), this.attributes));
            } else if (string.equals("boundsphere")) {
                this.objStack.push(this.processBSphere(new BoundingSphere(), this.attributes));
            } else if (string.equals("boundbox")) {
                this.objStack.push(this.processBBox(new BoundingBox(), this.attributes));
            } else if (string.equals("terrainblock")) {
                this.objStack.push(this.processTerrainBlock(new TerrainBlock((String)this.attributes.get("name")), this.attributes));
            } else if (string.equals("areaclod")) {
                this.objStack.push(this.processAreaClod(new AreaClodMesh((String)this.attributes.get("name")), this.attributes));
            } else if (string.equals("clodrecords")) {
                this.objStack.push(new CollapseRecord[((Integer)this.attributes.get("numrec")).intValue()]);
            } else if (string.equals("crecord")) {
                this.writeCollapseRecord(this.attributes);
            } else if (string.equals("mesh")) {
                object = new TriMesh((String)this.attributes.get("name"));
                object.getBatch(0).setIndexBuffer(BufferUtils.createIntBuffer((int)0));
                object.getBatch(0).setNormalBuffer(BufferUtils.createFloatBuffer((int)0));
                object.getBatch(0).setVertexBuffer(BufferUtils.createFloatBuffer((int)0));
                object.getBatch(0).setColorBuffer(null);
                object.getBatch(0).setTextureBuffer(null, 0);
                this.objStack.push(this.processSpatial((Spatial)object, this.attributes));
            } else if (string.startsWith("batch")) {
                if (!"batch0".equals(string)) {
                    object = this.objStack.pop();
                    if (object instanceof GeomBatch) {
                        object = this.objStack.pop();
                    }
                    Geometry geometry = (Geometry)object;
                    TriangleBatch triangleBatch = null;
                    if (geometry instanceof TriMesh) {
                        triangleBatch = new TriangleBatch();
                        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer((int)0));
                    } else {
                        triangleBatch = new GeomBatch();
                    }
                    triangleBatch.setNormalBuffer(BufferUtils.createFloatBuffer((int)0));
                    triangleBatch.setVertexBuffer(BufferUtils.createFloatBuffer((int)0));
                    triangleBatch.setColorBuffer(BufferUtils.createFloatBuffer((int)0));
                    triangleBatch.setTextureBuffer(BufferUtils.createFloatBuffer((int)0), 0);
                    geometry.addBatch((GeomBatch)triangleBatch);
                    this.objStack.push(geometry);
                    this.objStack.push(triangleBatch);
                }
            } else if (string.equals("vertex")) {
                object = this.objStack.pop();
                GeomBatch geomBatch = null;
                if (object instanceof Geometry) {
                    Geometry geometry = (Geometry)object;
                    geomBatch = geometry.getBatch(0);
                } else if (object instanceof GeomBatch) {
                    geomBatch = (GeomBatch)object;
                }
                if (this.attributes.get("q3vert") != null) {
                    geomBatch.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.decodeShortCompress((short[])this.attributes.get("q3vert"))));
                } else {
                    geomBatch.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])((Vector3f[])this.attributes.get("data"))));
                }
                this.objStack.push(object);
            } else if (string.equals("normal")) {
                object = this.objStack.pop();
                GeomBatch geomBatch = null;
                if (object instanceof Geometry) {
                    Geometry geometry = (Geometry)object;
                    geomBatch = geometry.getBatch(0);
                } else if (object instanceof GeomBatch) {
                    geomBatch = (GeomBatch)object;
                }
                if (this.attributes.get("q3norm") != null) {
                    geomBatch.setNormalBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.decodeLatLong((byte[])this.attributes.get("q3norm"))));
                } else {
                    geomBatch.setNormalBuffer(BufferUtils.createFloatBuffer((Vector3f[])((Vector3f[])this.attributes.get("data"))));
                }
                this.objStack.push(object);
            } else if (string.equals("texturecoords")) {
                object = this.objStack.pop();
                GeomBatch geomBatch = null;
                if (object instanceof Geometry) {
                    Geometry geometry = (Geometry)object;
                    geomBatch = geometry.getBatch(0);
                } else if (object instanceof GeomBatch) {
                    geomBatch = (GeomBatch)object;
                }
                if (this.attributes.get("texindex") == null) {
                    geomBatch.setTextureBuffer(BufferUtils.createFloatBuffer((Vector2f[])((Vector2f[])this.attributes.get("data"))), 0);
                } else {
                    geomBatch.setTextureBuffer(BufferUtils.createFloatBuffer((Vector2f[])((Vector2f[])this.attributes.get("data"))), ((Integer)this.attributes.get("texindex")).intValue());
                }
                this.objStack.push(object);
            } else if (string.equals("color")) {
                object = this.objStack.pop();
                GeomBatch geomBatch = null;
                if (object instanceof Geometry) {
                    Geometry geometry = (Geometry)object;
                    geomBatch = geometry.getBatch(0);
                } else if (object instanceof GeomBatch) {
                    geomBatch = (GeomBatch)object;
                }
                geomBatch.setColorBuffer((FloatBuffer)this.attributes.get("data"));
                this.objStack.push(object);
            } else if (string.equals("defcolor")) {
                object = this.objStack.pop();
                Geometry geometry = null;
                if (object instanceof Geometry) {
                    geometry = (Geometry)object;
                } else if (object instanceof GeomBatch) {
                    geometry = (Geometry)this.objStack.pop();
                    this.objStack.push(geometry);
                }
                geometry.setDefaultColor((ColorRGBA)this.attributes.get("data"));
                this.objStack.push(object);
            } else if (string.equals("index")) {
                object = this.objStack.pop();
                TriangleBatch triangleBatch = null;
                if (object instanceof TriMesh) {
                    TriMesh triMesh = (TriMesh)object;
                    triangleBatch = triMesh.getBatch(0);
                } else if (object instanceof TriangleBatch) {
                    triangleBatch = (TriangleBatch)object;
                }
                triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer((int[])((int[])this.attributes.get("data"))));
                if (triangleBatch.getIndexBuffer() == null) {
                    triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer((int)0));
                }
                this.objStack.push(object);
            } else if (string.equals("origvertex")) {
                object = (JointMesh)((Object)this.objStack.pop());
                ((JointMesh)((Object)object)).originalVertex = (Vector3f[])this.attributes.get("data");
                this.objStack.push(object);
            } else if (string.equals("orignormal")) {
                object = (JointMesh)((Object)this.objStack.pop());
                ((JointMesh)((Object)object)).originalNormal = (Vector3f[])this.attributes.get("data");
                this.objStack.push(object);
            } else if (string.equals("jointindex")) {
                object = (JointMesh)((Object)this.objStack.pop());
                ((JointMesh)((Object)object)).jointIndex = (int[])this.attributes.get("data");
                this.objStack.push(object);
            } else if (!string.equals("sharedtypes")) {
                if (string.equals("primitive")) {
                    this.objStack.push(this.processPrimitive(this.attributes));
                } else if (string.equals("sharedrenderstate")) {
                    this.objStack.push((Object)new XMLSharedNode((String)this.attributes.get("ident")));
                } else if (string.equals("sharedtrimesh")) {
                    this.objStack.push((Object)new XMLSharedNode((String)this.attributes.get("ident")));
                } else if (string.equals("sharednode")) {
                    this.objStack.push((Object)new XMLSharedNode((String)this.attributes.get("ident")));
                } else if (string.equals("publicobject")) {
                    object = this.shares.get(this.attributes.get("ident"));
                    this.objStack.push(object);
                } else if (string.equals("xmlloadable")) {
                    try {
                        object = Class.forName((String)this.attributes.get("class"));
                        if (!XMLloadable.class.isAssignableFrom((Class<?>)object)) {
                            throw new JmeException("Given XML class must implement XMLloadable");
                        }
                        XMLloadable xMLloadable = (XMLloadable)((Class)object).newInstance();
                        Object object2 = xMLloadable.loadFromXML((String)this.attributes.get("args"));
                        if (object2 instanceof Spatial) {
                            this.processSpatial((Spatial)object2, this.attributes);
                        }
                        this.objStack.push(object2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new JmeException("Unknown class type:" + this.attributes.get("class"));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new JmeException("XMLloadable classes must have a default() constructor: " + this.attributes.get("class"));
                    }
                    catch (InstantiationException instantiationException) {
                        throw new JmeException("XMLloadable classes cannot be abstract: " + this.attributes.get("class"));
                    }
                } else if (string.equals("jointcontroller")) {
                    object = new JointController((Integer)this.attributes.get("numJoints"));
                    this.processController((Controller)object, this.attributes);
                    ((JointController)((Object)object)).FPS = ((Float)this.attributes.get("fps")).floatValue();
                    this.objStack.push(object);
                } else if (string.equals("keyframe")) {
                    object = (Integer)this.objStack.pop();
                    JointController jointController = (JointController)((Object)this.objStack.pop());
                    if (this.attributes.get("rot") != null) {
                        jointController.setRotation((Integer)object, ((Float)this.attributes.get("time")).floatValue(), (Quaternion)this.attributes.get("rot"));
                    }
                    if (this.attributes.get("trans") != null) {
                        jointController.setTranslation((Integer)object, ((Float)this.attributes.get("time")).floatValue(), (Vector3f)this.attributes.get("trans"));
                    }
                    this.objStack.push((Object)jointController);
                    this.objStack.push(object);
                } else if (string.equals("joint")) {
                    object = (JointController)((Object)this.objStack.pop());
                    ((JointController)((Object)object)).parentIndex[((Integer)this.attributes.get((Object)"index")).intValue()] = (Integer)this.attributes.get("parentindex");
                    ((JointController)((Object)object)).localRefMatrix[(Integer)this.attributes.get("index")].setRotation((Matrix3f)this.attributes.get("localrot"));
                    ((JointController)((Object)object)).localRefMatrix[(Integer)this.attributes.get("index")].setTranslation((Vector3f)this.attributes.get("localvec"));
                    this.objStack.push(object);
                    this.objStack.push(this.attributes.get("index"));
                } else if (string.equals("jointmesh")) {
                    this.objStack.push(this.processSpatial((Spatial)new JointMesh((String)this.attributes.get("name")), this.attributes));
                } else if (string.equals("keyframecontroller")) {
                    object = new KeyframeController();
                    object.setActive(true);
                    TriMesh triMesh = (TriMesh)this.objStack.pop();
                    ((KeyframeController)((Object)object)).setMorphingMesh(triMesh);
                    this.objStack.push(triMesh);
                    this.objStack.push(object);
                } else if (string.equals("keyframepointintime")) {
                    this.objStack.push(this.attributes.get("time"));
                    this.objStack.push(new TriMesh());
                } else if (string.equals("lightstate")) {
                    this.objStack.push(this.buildLightState(this.attributes));
                } else if (string.equals("spotlight")) {
                    object = (LightState)this.objStack.pop();
                    object.attach((Light)this.buildSpotLight(this.attributes));
                    this.objStack.push(object);
                } else if (string.equals("pointlight")) {
                    object = (LightState)this.objStack.pop();
                    object.attach((Light)this.buildPointLight(this.attributes));
                    this.objStack.push(object);
                } else if (string.equals("jmefile")) {
                    if (this.attributes.get("file") != null) {
                        object = new LoaderNode("file " + (String)this.attributes.get("file"));
                        ((LoaderNode)((Object)object)).loadFromFilePath((String)this.attributes.get("type"), (String)this.attributes.get("file"), this.properties);
                        this.objStack.push(object);
                    } else if (this.attributes.get("classloader") != null) {
                        object = new LoaderNode("classloader " + (String)this.attributes.get("classloader"));
                        ((LoaderNode)((Object)object)).loadFromClassLoader((String)this.attributes.get("type"), (String)this.attributes.get("classloader"), this.properties);
                        this.objStack.push(object);
                    } else if (this.attributes.get("url") != null) {
                        object = new LoaderNode("classloader " + this.attributes.get("url"));
                        ((LoaderNode)((Object)object)).loadFromURLPath((String)this.attributes.get("type"), (URL)this.attributes.get("url"), this.properties);
                        this.objStack.push(object);
                    }
                } else if (string.equals("spatialtransformer")) {
                    object = new SpatialTransformer(((Integer)this.attributes.get("numobjects")).intValue());
                    this.processController((Controller)object, this.attributes);
                    this.objStack.push(object);
                } else if (string.equals("stobj")) {
                    this.objStack.push(this.attributes.get("obnum"));
                    this.objStack.push(this.attributes.get("parnum"));
                    this.objStack.push((Object)new XMLSharedNode(null));
                } else if (string.equals("spatialpointtime")) {
                    this.objStack.push(this.attributes.get("time"));
                } else if (string.equals("sptscale")) {
                    object = (Float)this.objStack.pop();
                    float f = ((Float)object).floatValue();
                    int[] nArray = (int[])this.attributes.get("index");
                    Vector3f[] vector3fArray = (Vector3f[])this.attributes.get("scalevalues");
                    SpatialTransformer spatialTransformer = (SpatialTransformer)this.objStack.pop();
                    if (vector3fArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            spatialTransformer.setScale(nArray[i], f, vector3fArray[i]);
                        }
                    }
                    this.objStack.push(spatialTransformer);
                    this.objStack.push(object);
                } else if (string.equals("sptrot")) {
                    object = (Float)this.objStack.pop();
                    float f = ((Float)object).floatValue();
                    int[] nArray = (int[])this.attributes.get("index");
                    Quaternion[] quaternionArray = (Quaternion[])this.attributes.get("rotvalues");
                    SpatialTransformer spatialTransformer = (SpatialTransformer)this.objStack.pop();
                    if (quaternionArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            spatialTransformer.setRotation(nArray[i], f, quaternionArray[i]);
                        }
                    }
                    this.objStack.push(spatialTransformer);
                    this.objStack.push(object);
                } else if (string.equals("spttrans")) {
                    object = (Float)this.objStack.pop();
                    float f = ((Float)object).floatValue();
                    int[] nArray = (int[])this.attributes.get("index");
                    Vector3f[] vector3fArray = (Vector3f[])this.attributes.get("transvalues");
                    SpatialTransformer spatialTransformer = (SpatialTransformer)this.objStack.pop();
                    if (vector3fArray != null) {
                        for (int i = 0; i < nArray.length; ++i) {
                            spatialTransformer.setPosition(nArray[i], f, vector3fArray[i]);
                        }
                    }
                    this.objStack.push(spatialTransformer);
                    this.objStack.push(object);
                } else if (string.equals("cullstate")) {
                    this.objStack.push(this.buildCullState(this.attributes));
                } else if (string.equals("wirestate")) {
                    this.objStack.push(this.buildWireState(this.attributes));
                } else {
                    throw new JmeException("Illegale Qualified name: '" + string + "'");
                }
            }
        }
        if (this.attributes.containsKey("sharedident")) {
            object = this.objStack.pop();
            this.repeatShare.put(this.attributes.get("sharedident"), object);
            this.objStack.push(object);
        }
    }

    private void processController(Controller controller, HashMap hashMap) {
        if (hashMap.containsKey("speed")) {
            controller.setSpeed(((Float)hashMap.get("speed")).floatValue());
        }
        if (hashMap.containsKey("rptype")) {
            controller.setRepeatType(((Integer)hashMap.get("rptype")).intValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readEnd() throws IOException {
        String string = this.myIn.readUTF();
        if (string.equals("scene")) {
            this.myScene = (Node)this.objStack.pop();
            return;
        } else if (string.equals("node") || string.equals("terrainpage")) {
            Node node = (Node)this.objStack.pop();
            Node node2 = (Node)this.objStack.pop();
            node2.attachChild((Spatial)node);
            this.objStack.push(node2);
            return;
        } else if (string.equals("repeatobject")) {
            Object object = this.objStack.pop();
            if (object instanceof RenderState) {
                Spatial spatial = (Spatial)this.objStack.pop();
                spatial.setRenderState((RenderState)object);
                this.objStack.push(spatial);
                return;
            } else if (object instanceof Controller) {
                Spatial spatial = (Spatial)this.objStack.pop();
                spatial.addController((Controller)object);
                this.objStack.push(spatial);
                return;
            } else {
                if (!(object instanceof Spatial)) throw new IOException("Unknown child repeat object " + object.getClass());
                Node node = (Node)this.objStack.pop();
                node.attachChild((Spatial)object);
                this.objStack.push(node);
            }
            return;
        } else if (string.equals("materialstate")) {
            MaterialState materialState = (MaterialState)this.objStack.pop();
            Object object = this.objStack.pop();
            if (object instanceof Spatial) {
                Spatial spatial = (Spatial)object;
                spatial.setRenderState((RenderState)materialState);
            } else if (object instanceof GeomBatch) {
                ((GeomBatch)object).setRenderState((RenderState)materialState);
            }
            this.objStack.push(object);
            return;
        } else if (string.equals("alphastate")) {
            AlphaState alphaState = (AlphaState)this.objStack.pop();
            Object object = this.objStack.pop();
            if (object instanceof Spatial) {
                Spatial spatial = (Spatial)object;
                spatial.setRenderState((RenderState)alphaState);
                if (alphaState.isBlendEnabled()) {
                    Spatial spatial2 = spatial;
                    spatial2.setRenderQueueMode(3);
                }
            } else if (object instanceof GeomBatch) {
                ((GeomBatch)object).setRenderState((RenderState)alphaState);
                if (alphaState.isBlendEnabled()) {
                    Spatial spatial = (Spatial)this.objStack.pop();
                    spatial.setRenderQueueMode(3);
                    this.objStack.push(spatial);
                }
            }
            this.objStack.push(object);
            return;
        } else if (string.equals("texturestate")) {
            TextureState textureState = (TextureState)this.objStack.pop();
            Object object = this.objStack.pop();
            if (object instanceof Spatial) {
                Spatial spatial = (Spatial)object;
                spatial.setRenderState((RenderState)textureState);
            } else if (object instanceof GeomBatch) {
                ((GeomBatch)object).setRenderState((RenderState)textureState);
            }
            this.objStack.push(object);
            return;
        } else {
            if (string.equals("texture")) return;
            if (string.equals("cullstate")) {
                CullState cullState = (CullState)this.objStack.pop();
                Object object = this.objStack.pop();
                if (object instanceof Spatial) {
                    Spatial spatial = (Spatial)object;
                    spatial.setRenderState((RenderState)cullState);
                } else if (object instanceof GeomBatch) {
                    ((GeomBatch)object).setRenderState((RenderState)cullState);
                }
                this.objStack.push(object);
                return;
            } else {
                if (string.startsWith("batch")) return;
                if (string.equals("mesh") || string.equals("jointmesh") || string.equals("clod") || string.equals("areaclod") || string.equals("terrainblock")) {
                    Object object = this.objStack.pop();
                    Geometry geometry = null;
                    if (object instanceof GeomBatch) {
                        geometry = (Geometry)this.objStack.pop();
                    } else if (object instanceof Geometry) {
                        geometry = (Geometry)object;
                    }
                    if (geometry.getBatch(0).getModelBound() == null) {
                        if ("box".equals(this.properties.get("bound"))) {
                            geometry.setModelBound((BoundingVolume)new BoundingBox());
                        } else if ("obb".equals(this.properties.get("bound"))) {
                            geometry.setModelBound((BoundingVolume)new OrientedBoundingBox());
                        } else {
                            geometry.setModelBound((BoundingVolume)new BoundingSphere());
                        }
                        geometry.updateModelBound();
                    }
                    Node node = (Node)this.objStack.pop();
                    node.attachChild((Spatial)geometry);
                    this.objStack.push(node);
                    return;
                } else {
                    if (string.equals("vertex") || string.equals("normal") || string.equals("color") || string.equals("defcolor") || string.equals("texturecoords") || string.equals("index")) return;
                    if (string.equals("primitive")) {
                        Spatial spatial = (Spatial)this.objStack.pop();
                        Node node = (Node)this.objStack.pop();
                        node.attachChild(spatial);
                        this.objStack.push(node);
                        return;
                    } else {
                        if (string.equals("pointlight") || string.equals("spotlight") || string.equals("sharedtypes") || string.equals("keyframe")) return;
                        if (string.equals("xmlloadable")) {
                            Object object = this.objStack.pop();
                            if (object instanceof RenderState) {
                                Spatial spatial = (Spatial)this.objStack.pop();
                                spatial.setRenderState((RenderState)object);
                                this.objStack.push(spatial);
                                return;
                            } else if (object instanceof Controller) {
                                Spatial spatial = (Spatial)this.objStack.pop();
                                spatial.addController((Controller)object);
                                this.objStack.push(spatial);
                                return;
                            } else {
                                if (!(object instanceof Spatial)) return;
                                Node node = (Node)this.objStack.pop();
                                node.attachChild((Spatial)object);
                                this.objStack.push(node);
                            }
                            return;
                        } else if (string.equals("sharedrenderstate")) {
                            XMLSharedNode xMLSharedNode = (XMLSharedNode)((Object)this.objStack.pop());
                            if (xMLSharedNode.whatIReallyAm == null) return;
                            this.shares.put(xMLSharedNode.myIdent, xMLSharedNode.whatIReallyAm);
                            return;
                        } else if (string.equals("sharedtrimesh")) {
                            XMLSharedNode xMLSharedNode = (XMLSharedNode)((Object)this.objStack.pop());
                            this.shares.put(xMLSharedNode.myIdent, xMLSharedNode.whatIReallyAm);
                            return;
                        } else if (string.equals("sharednode")) {
                            XMLSharedNode xMLSharedNode = (XMLSharedNode)((Object)this.objStack.pop());
                            this.shares.put(xMLSharedNode.myIdent, xMLSharedNode.whatIReallyAm);
                            return;
                        } else if (string.equals("publicobject")) {
                            Object object = this.objStack.pop();
                            if (object instanceof RenderState) {
                                Spatial spatial = (Spatial)this.objStack.pop();
                                spatial.setRenderState((RenderState)object);
                                this.objStack.push(spatial);
                                return;
                            } else if (object instanceof Controller) {
                                Spatial spatial = (Spatial)this.objStack.pop();
                                spatial.addController((Controller)object);
                                this.objStack.push(spatial);
                                return;
                            } else {
                                if (!(object instanceof Spatial)) return;
                                Node node = (Node)this.objStack.pop();
                                node.attachChild((Spatial)object);
                                this.objStack.push(node);
                            }
                            return;
                        } else if (string.equals("jointcontroller")) {
                            JointController jointController = (JointController)((Object)this.objStack.pop());
                            Node node = (Node)this.objStack.pop();
                            for (int i = 0; i < node.getQuantity(); ++i) {
                                if (!(node.getChild(i) instanceof JointMesh)) continue;
                                jointController.addJointMesh((JointMesh)node.getChild(i));
                            }
                            jointController.processController();
                            if (jointController.numJoints != 0) {
                                node.addController((Controller)jointController);
                            }
                            this.objStack.push(node);
                            return;
                        } else if (string.equals("joint")) {
                            this.objStack.pop();
                            return;
                        } else if (string.equals("obb") || string.equals("boundsphere") || string.equals("boundbox")) {
                            BoundingVolume boundingVolume = (BoundingVolume)this.objStack.pop();
                            Object object = this.objStack.pop();
                            if (object instanceof Geometry) {
                                Geometry geometry = (Geometry)object;
                                geometry.setModelBound(boundingVolume);
                            }
                            this.objStack.push(object);
                            return;
                        } else {
                            if (string.equals("jointindex") || string.equals("origvertex") || string.equals("orignormal")) return;
                            if (string.equals("keyframecontroller")) {
                                KeyframeController keyframeController = (KeyframeController)((Object)this.objStack.pop());
                                TriMesh triMesh = (TriMesh)this.objStack.pop();
                                triMesh.addController((Controller)keyframeController);
                                this.objStack.push(triMesh);
                                return;
                            } else if (string.equals("lightstate")) {
                                LightState lightState = (LightState)this.objStack.pop();
                                Object object = this.objStack.pop();
                                if (object instanceof Spatial) {
                                    Spatial spatial = (Spatial)object;
                                    spatial.setRenderState((RenderState)lightState);
                                } else if (object instanceof GeomBatch) {
                                    ((GeomBatch)object).setRenderState((RenderState)lightState);
                                }
                                this.objStack.push(object);
                                return;
                            } else if (string.equals("keyframepointintime")) {
                                TriMesh triMesh = (TriMesh)this.objStack.pop();
                                float f = ((Float)this.objStack.pop()).floatValue();
                                KeyframeController keyframeController = (KeyframeController)((Object)this.objStack.pop());
                                keyframeController.setKeyframe(f, triMesh);
                                this.objStack.push((Object)keyframeController);
                                return;
                            } else if (string.equals("jmefile")) {
                                LoaderNode loaderNode = (LoaderNode)((Object)this.objStack.pop());
                                Node node = (Node)this.objStack.pop();
                                node.attachChild((Spatial)loaderNode);
                                this.objStack.push(node);
                                return;
                            } else if (string.equals("spatialtransformer")) {
                                SpatialTransformer spatialTransformer = (SpatialTransformer)this.objStack.pop();
                                Spatial spatial = (Spatial)this.objStack.pop();
                                spatialTransformer.interpolateMissing();
                                spatialTransformer.setActive(true);
                                spatial.addController((Controller)spatialTransformer);
                                this.objStack.push(spatial);
                                return;
                            } else if (string.equals("stobj")) {
                                XMLSharedNode xMLSharedNode = (XMLSharedNode)((Object)this.objStack.pop());
                                int n = (Integer)this.objStack.pop();
                                int n2 = (Integer)this.objStack.pop();
                                SpatialTransformer spatialTransformer = (SpatialTransformer)this.objStack.pop();
                                spatialTransformer.setObject((Spatial)xMLSharedNode.whatIReallyAm, n2, n);
                                this.objStack.push(spatialTransformer);
                                return;
                            } else if (string.equals("spatialpointtime")) {
                                this.objStack.pop();
                                return;
                            } else if (string.equals("clodrecords")) {
                                CollapseRecord[] collapseRecordArray = (CollapseRecord[])this.objStack.pop();
                                ClodMesh clodMesh = (ClodMesh)this.objStack.pop();
                                clodMesh.create(collapseRecordArray);
                                this.objStack.push(clodMesh);
                                return;
                            } else if (string.equals("wirestate")) {
                                WireframeState wireframeState = (WireframeState)this.objStack.pop();
                                Object object = this.objStack.pop();
                                if (object instanceof Spatial) {
                                    Spatial spatial = (Spatial)object;
                                    spatial.setRenderState((RenderState)wireframeState);
                                } else if (object instanceof GeomBatch) {
                                    ((GeomBatch)object).setRenderState((RenderState)wireframeState);
                                }
                                this.objStack.push(object);
                                return;
                            } else {
                                if (string.equals("crecord") || string.equals("sptscale") || string.equals("sptrot") || string.equals("spttrans")) return;
                                throw new JmeException("Illegal Qualified name: " + string);
                            }
                        }
                    }
                }
            }
        }
    }

    private OrientedBoundingBox processOBB(OrientedBoundingBox orientedBoundingBox, HashMap hashMap) {
        orientedBoundingBox.setCenter((Vector3f)hashMap.get("center"));
        orientedBoundingBox.setXAxis((Vector3f)hashMap.get("xaxis"));
        orientedBoundingBox.setYAxis((Vector3f)hashMap.get("yaxis"));
        orientedBoundingBox.setZAxis((Vector3f)hashMap.get("zaxis"));
        orientedBoundingBox.setExtent((Vector3f)hashMap.get("extent"));
        return orientedBoundingBox;
    }

    private BoundingSphere processBSphere(BoundingSphere boundingSphere, HashMap hashMap) {
        boundingSphere.setCenter((Vector3f)hashMap.get("center"));
        boundingSphere.setRadius(((Float)hashMap.get("radius")).floatValue());
        return boundingSphere;
    }

    private BoundingBox processBBox(BoundingBox boundingBox, HashMap hashMap) {
        boundingBox.setCenter((Vector3f)hashMap.get("nowcent"));
        Vector3f vector3f = (Vector3f)hashMap.get("nowext");
        boundingBox.xExtent = vector3f.x;
        boundingBox.yExtent = vector3f.y;
        boundingBox.zExtent = vector3f.z;
        return boundingBox;
    }

    private void writeCollapseRecord(HashMap hashMap) {
        CollapseRecord collapseRecord = new CollapseRecord();
        collapseRecord.indices = (int[])hashMap.get("indexary");
        collapseRecord.numbIndices = (Integer)hashMap.get("numi");
        collapseRecord.numbTriangles = (Integer)hashMap.get("numt");
        collapseRecord.numbVerts = (Integer)hashMap.get("numv");
        collapseRecord.vertToKeep = (Integer)hashMap.get("vkeep");
        collapseRecord.vertToThrow = (Integer)hashMap.get("vthrow");
        CollapseRecord[] collapseRecordArray = (CollapseRecord[])this.objStack.pop();
        collapseRecordArray[((Integer)hashMap.get((Object)"index")).intValue()] = collapseRecord;
        this.objStack.push(collapseRecordArray);
    }

    private TerrainPage processTerrainPage(TerrainPage terrainPage, HashMap hashMap) {
        this.processSpatial((Spatial)terrainPage, hashMap);
        terrainPage.setOffset((Vector2f)hashMap.get("offset"));
        terrainPage.setTotalSize(((Integer)hashMap.get("totsize")).intValue());
        terrainPage.setSize(((Integer)hashMap.get("size")).intValue());
        terrainPage.setStepScale((Vector3f)hashMap.get("stepscale"));
        terrainPage.setOffsetAmount(((Float)hashMap.get("offamnt")).floatValue());
        return terrainPage;
    }

    private TerrainBlock processTerrainBlock(TerrainBlock terrainBlock, HashMap hashMap) {
        this.processAreaClod((AreaClodMesh)terrainBlock, hashMap);
        terrainBlock.setSize(((Integer)hashMap.get("tbsize")).intValue());
        terrainBlock.setTotalSize(((Integer)hashMap.get("totsize")).intValue());
        terrainBlock.setStepScale((Vector3f)hashMap.get("step"));
        terrainBlock.setUseClod(((Boolean)hashMap.get("isclod")).booleanValue());
        terrainBlock.setOffset((Vector2f)hashMap.get("offset"));
        terrainBlock.setOffsetAmount(((Float)hashMap.get("offamnt")).floatValue());
        terrainBlock.setHeightMap((int[])hashMap.get("hmap"));
        return terrainBlock;
    }

    private AreaClodMesh processAreaClod(AreaClodMesh areaClodMesh, HashMap hashMap) {
        this.processSpatial((Spatial)areaClodMesh, hashMap);
        areaClodMesh.setDistanceTolerance(((Float)hashMap.get("disttol")).floatValue());
        areaClodMesh.setTrisPerPixel(((Float)hashMap.get("trisppix")).floatValue());
        return areaClodMesh;
    }

    private Vector3f[] decodeShortCompress(short[] sArray) throws IOException {
        if (sArray.length % 3 != 0) {
            throw new IOException("Illeagle short[] length of " + sArray.length);
        }
        Vector3f[] vector3fArray = new Vector3f[sArray.length / 3];
        for (int i = 0; i < vector3fArray.length; ++i) {
            vector3fArray[i] = new Vector3f();
            vector3fArray[i].x = (float)sArray[i * 3 + 0] * 0.015625f;
            vector3fArray[i].y = (float)sArray[i * 3 + 1] * 0.015625f;
            vector3fArray[i].z = (float)sArray[i * 3 + 2] * 0.015625f;
        }
        return vector3fArray;
    }

    private Vector3f[] decodeLatLong(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        if (byArray.length % 2 != 0) {
            throw new IOException("Illeagle bytes[] length of " + byArray.length);
        }
        Vector3f[] vector3fArray = new Vector3f[byArray.length / 2];
        for (int i = 0; i < byArray.length; i += 2) {
            vector3fArray[i / 2] = new Vector3f();
            byte by = byArray[i];
            byte by2 = byArray[i + 1];
            float f = (float)Math.PI / 180 * (float)by2;
            float f2 = (float)Math.PI / 180 * (float)by;
            vector3fArray[i / 2].x = FastMath.cos((float)f) * FastMath.sin((float)f2);
            vector3fArray[i / 2].y = FastMath.sin((float)f) * FastMath.sin((float)f2);
            vector3fArray[i / 2].z = FastMath.cos((float)f2);
        }
        return vector3fArray;
    }

    private Object buildCullState(HashMap hashMap) {
        CullState cullState = this.renderer.createCullState();
        cullState.setEnabled(true);
        String string = (String)hashMap.get("cull");
        if ("none".equals(string)) {
            cullState.setCullMode(0);
        } else if ("back".equals(string)) {
            cullState.setCullMode(2);
        } else if ("front".equals(string)) {
            cullState.setCullMode(1);
        }
        return cullState;
    }

    private PointLight buildPointLight(HashMap hashMap) {
        PointLight pointLight = new PointLight();
        this.putLightInfo((Light)pointLight, hashMap);
        pointLight.setLocation((Vector3f)hashMap.get("loc"));
        pointLight.setEnabled(true);
        return pointLight;
    }

    private SpotLight buildSpotLight(HashMap hashMap) {
        SpotLight spotLight = new SpotLight();
        this.putLightInfo((Light)spotLight, hashMap);
        spotLight.setLocation((Vector3f)hashMap.get("loc"));
        spotLight.setAngle(((Float)hashMap.get("fangle")).floatValue());
        spotLight.setDirection((Vector3f)hashMap.get("dir"));
        spotLight.setExponent(((Float)hashMap.get("fexponent")).floatValue());
        spotLight.setEnabled(true);
        return spotLight;
    }

    private WireframeState buildWireState(HashMap hashMap) {
        WireframeState wireframeState = this.renderer.createWireframeState();
        wireframeState.setFace(((Integer)hashMap.get("facetype")).intValue());
        wireframeState.setLineWidth(((Float)hashMap.get("width")).floatValue());
        wireframeState.setEnabled(true);
        return wireframeState;
    }

    private void putLightInfo(Light light, HashMap hashMap) {
        light.setAmbient((ColorRGBA)hashMap.get("ambient"));
        light.setConstant(((Float)hashMap.get("fconstant")).floatValue());
        light.setDiffuse((ColorRGBA)hashMap.get("diffuse"));
        light.setLinear(((Float)hashMap.get("flinear")).floatValue());
        light.setQuadratic(((Float)hashMap.get("fquadratic")).floatValue());
        light.setSpecular((ColorRGBA)hashMap.get("specular"));
        light.setAttenuate(((Boolean)hashMap.get("isattenuate")).booleanValue());
    }

    private LightState buildLightState(HashMap hashMap) {
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        LightState lightState = this.renderer.createLightState();
        ColorRGBA colorRGBA = (ColorRGBA)hashMap.get("ambient");
        if (colorRGBA != null) {
            lightState.setGlobalAmbient(colorRGBA);
        }
        if ((bl3 = (Boolean)hashMap.get("twosided")) != null) {
            lightState.setTwoSidedLighting(bl3.booleanValue());
        }
        if ((bl2 = (Boolean)hashMap.get("local")) != null) {
            lightState.setLocalViewer(bl2.booleanValue());
        }
        if ((bl = (Boolean)hashMap.get("sepspec")) != null) {
            lightState.setSeparateSpecular(bl.booleanValue());
        }
        lightState.setEnabled(true);
        return lightState;
    }

    private Spatial processPrimitive(HashMap hashMap) {
        String string = (String)hashMap.get("params");
        String string2 = (String)hashMap.get("type");
        if (string == null) {
            throw new JmeException("Must specify parameters");
        }
        String[] stringArray = string.trim().split(" ");
        if (string2.equalsIgnoreCase("box")) {
            if (stringArray.length != 7) {
                throw new JmeException("Box must have 7 parameters");
            }
        } else {
            throw new JmeException("Unknown primitive type: " + string2);
        }
        Box box = new Box(stringArray[0], new Vector3f(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])), new Vector3f(Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5]), Float.parseFloat(stringArray[6])));
        box.setModelBound((BoundingVolume)new BoundingSphere());
        box.updateModelBound();
        Box box2 = box;
        return this.processSpatial((Spatial)box2, hashMap);
    }

    private Texture buildTexture(HashMap hashMap) {
        Texture texture = null;
        int n = 2;
        int n2 = 1;
        int n3 = TextureManager.COMPRESS_BY_DEFAULT ? -1 : -2;
        float f = 1.0f;
        boolean bl = true;
        if (this.properties.containsKey("tex_mm")) {
            n = (Integer)this.properties.get("tex_mm");
        }
        if (this.properties.containsKey("tex_fm")) {
            n2 = (Integer)this.properties.get("tex_fm");
        }
        if (this.properties.containsKey("tex_type")) {
            n3 = (Integer)this.properties.get("tex_type");
        }
        if (this.properties.containsKey("tex_aniso")) {
            f = ((Float)this.properties.get("tex_aniso")).floatValue();
        }
        if (this.properties.containsKey("tex_flip")) {
            bl = (Boolean)this.properties.get("tex_flip");
        }
        try {
            if (hashMap.get("URL") != null && !hashMap.get("URL").equals("null")) {
                texture = TextureManager.loadTexture((URL)((URL)hashMap.get("URL")), (int)n, (int)n2, (int)n3, (float)f, (boolean)bl);
            } else if (hashMap.get("file") != null && !hashMap.get("file").equals("null")) {
                URL uRL = this.properties.containsKey("texurl") ? new URL((URL)this.properties.get("texurl"), (String)hashMap.get("file")) : (this.properties.containsKey("texclasspath") ? JmeBinaryReader.class.getClassLoader().getResource((String)this.properties.get("texclasspath") + (String)hashMap.get("file")) : (this.properties.containsKey("texdirfile") ? new File((String)this.properties.get("texdirfile") + File.separator + (String)hashMap.get("file")).toURL() : new File((String)hashMap.get("file")).toURI().toURL()));
                texture = TextureManager.loadTexture((URL)uRL, (int)n, (int)n2, (int)n3, (float)f, (boolean)bl);
                if (texture == null) {
                    return texture;
                }
                texture.setImageLocation("file:/" + hashMap.get("file"));
            }
            if (texture == null) {
                LoggingSystem.getLogger().log(Level.INFO, "Unable to load file: " + hashMap.get("file"));
            } else {
                if (hashMap.get("wrap") != null) {
                    texture.setWrap(((Integer)hashMap.get("wrap")).intValue());
                }
                if (hashMap.get("scale") != null) {
                    texture.setScale((Vector3f)hashMap.get("scale"));
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new JmeException("Bad file name: " + hashMap.get("file") + " (" + hashMap.get("URL") + ")");
        }
        return texture;
    }

    private Spatial processSpatial(Spatial spatial, HashMap hashMap) {
        if (hashMap.get("name") != null) {
            spatial.setName((String)hashMap.get("name"));
        }
        if (hashMap.get("translation") != null) {
            spatial.setLocalTranslation((Vector3f)hashMap.get("translation"));
        }
        if (hashMap.get("rotation") != null) {
            spatial.setLocalRotation((Quaternion)hashMap.get("rotation"));
        }
        if (hashMap.get("scale") != null) {
            spatial.setLocalScale((Vector3f)hashMap.get("scale"));
        }
        return spatial;
    }

    private MaterialState buildMaterial(HashMap hashMap) {
        MaterialState materialState = this.renderer.createMaterialState();
        materialState.setAmbient((ColorRGBA)hashMap.get("ambient"));
        materialState.setDiffuse((ColorRGBA)hashMap.get("diffuse"));
        materialState.setEmissive((ColorRGBA)hashMap.get("emissive"));
        materialState.setShininess(((Float)hashMap.get("shiny")).floatValue());
        materialState.setSpecular((ColorRGBA)hashMap.get("specular"));
        Integer n = (Integer)hashMap.get("color");
        if (n != null) {
            materialState.setColorMaterial(n.intValue());
        }
        if ((n = (Integer)hashMap.get("face")) != null) {
            materialState.setMaterialFace(n.intValue());
        }
        materialState.setEnabled(true);
        return materialState;
    }

    private AlphaState buildAlphaState(HashMap hashMap) {
        AlphaState alphaState = this.renderer.createAlphaState();
        alphaState.setSrcFunction(((Integer)hashMap.get("srcfunc")).intValue());
        alphaState.setDstFunction(((Integer)hashMap.get("dstfunc")).intValue());
        alphaState.setTestFunction(((Integer)hashMap.get("testfunc")).intValue());
        alphaState.setReference(((Float)hashMap.get("reference")).floatValue());
        alphaState.setBlendEnabled(((Boolean)hashMap.get("blend")).booleanValue());
        alphaState.setTestEnabled(((Boolean)hashMap.get("test")).booleanValue());
        alphaState.setEnabled(((Boolean)hashMap.get("enabled")).booleanValue());
        return alphaState;
    }

    private void readInObjects(HashMap<String, Object> hashMap) throws IOException {
        hashMap.clear();
        int n = this.myIn.readByte();
        block19: for (int i = 0; i < n; ++i) {
            String string = this.myIn.readUTF();
            byte by = this.myIn.readByte();
            switch (by) {
                case 2: {
                    hashMap.put(string, this.getColorBuffer());
                    continue block19;
                }
                case 4: {
                    hashMap.put(string, this.getIntArray());
                    continue block19;
                }
                case 3: {
                    hashMap.put(string, this.myIn.readUTF());
                    continue block19;
                }
                case 1: {
                    hashMap.put(string, this.getVec2fArray());
                    continue block19;
                }
                case 0: {
                    hashMap.put(string, this.getVec3fArray());
                    continue block19;
                }
                case 5: {
                    hashMap.put(string, this.getVec3f());
                    continue block19;
                }
                case 15: {
                    hashMap.put(string, this.getVec2f());
                    continue block19;
                }
                case 6: {
                    hashMap.put(string, this.getQuat());
                    continue block19;
                }
                case 7: {
                    hashMap.put(string, new Float(this.myIn.readFloat()));
                    continue block19;
                }
                case 8: {
                    hashMap.put(string, this.getColor());
                    continue block19;
                }
                case 9: {
                    hashMap.put(string, new URL(this.myIn.readUTF()));
                    continue block19;
                }
                case 10: {
                    hashMap.put(string, new Integer(this.myIn.readInt()));
                    continue block19;
                }
                case 11: {
                    hashMap.put(string, new Boolean(this.myIn.readBoolean()));
                    continue block19;
                }
                case 12: {
                    hashMap.put(string, this.getQuatArray());
                    continue block19;
                }
                case 13: {
                    hashMap.put(string, this.getByteArray());
                    continue block19;
                }
                case 14: {
                    hashMap.put(string, this.getShortArray());
                    continue block19;
                }
                case 16: {
                    hashMap.put(string, this.getMat3());
                    continue block19;
                }
                default: {
                    throw new IOException("Unknown data type:" + by);
                }
            }
        }
    }

    private Matrix3f getMat3() throws IOException {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.m00 = this.myIn.readFloat();
        matrix3f.m01 = this.myIn.readFloat();
        matrix3f.m02 = this.myIn.readFloat();
        matrix3f.m10 = this.myIn.readFloat();
        matrix3f.m11 = this.myIn.readFloat();
        matrix3f.m12 = this.myIn.readFloat();
        matrix3f.m20 = this.myIn.readFloat();
        matrix3f.m21 = this.myIn.readFloat();
        matrix3f.m22 = this.myIn.readFloat();
        return matrix3f;
    }

    private short[] getShortArray() throws IOException {
        int n = this.myIn.readInt();
        if (n == 0) {
            return null;
        }
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.myIn.readShort();
        }
        return sArray;
    }

    private byte[] getByteArray() throws IOException {
        int n = this.myIn.readInt();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.myIn.readByte();
        }
        return byArray;
    }

    private Quaternion[] getQuatArray() throws IOException {
        int n = this.myIn.readInt();
        if (n == 0) {
            return null;
        }
        Quaternion[] quaternionArray = new Quaternion[n];
        for (int i = 0; i < n; ++i) {
            quaternionArray[i] = new Quaternion(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
            if (!Float.isNaN(quaternionArray[i].x) || !Float.isNaN(quaternionArray[i].y) || !Float.isNaN(quaternionArray[i].z) || !Float.isNaN(quaternionArray[i].w)) continue;
            quaternionArray[i] = null;
        }
        return quaternionArray;
    }

    private Quaternion getQuat() throws IOException {
        return new Quaternion(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
    }

    private ColorRGBA getColor() throws IOException {
        return new ColorRGBA(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
    }

    private Vector2f getVec2f() throws IOException {
        return new Vector2f(this.myIn.readFloat(), this.myIn.readFloat());
    }

    private Vector3f getVec3f() throws IOException {
        return new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
    }

    private int[] getIntArray() throws IOException {
        int n = this.myIn.readInt();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.myIn.readInt();
        }
        return nArray;
    }

    private Vector2f[] getVec2fArray() throws IOException {
        int n = this.myIn.readInt();
        if (n == 0) {
            return null;
        }
        Vector2f[] vector2fArray = new Vector2f[n];
        for (int i = 0; i < n; ++i) {
            vector2fArray[i] = new Vector2f(this.myIn.readFloat(), this.myIn.readFloat());
            if (!Float.isNaN(vector2fArray[i].x) || !Float.isNaN(vector2fArray[i].y)) continue;
            vector2fArray[i] = null;
        }
        return vector2fArray;
    }

    private FloatBuffer getColorBuffer() throws IOException {
        int n = this.myIn.readInt();
        if (n == 0) {
            return null;
        }
        FloatBuffer floatBuffer = BufferUtils.createColorBuffer((int)n);
        for (int i = 0; i < n; ++i) {
            floatBuffer.put(this.myIn.readFloat()).put(this.myIn.readFloat()).put(this.myIn.readFloat()).put(this.myIn.readFloat());
        }
        return floatBuffer;
    }

    private Vector3f[] getVec3fArray() throws IOException {
        int n = this.myIn.readInt();
        if (n == 0) {
            return null;
        }
        Vector3f[] vector3fArray = new Vector3f[n];
        for (int i = 0; i < n; ++i) {
            vector3fArray[i] = new Vector3f(this.myIn.readFloat(), this.myIn.readFloat(), this.myIn.readFloat());
            if (!Float.isNaN(vector3fArray[i].x) || !Float.isNaN(vector3fArray[i].y) || !Float.isNaN(vector3fArray[i].z)) continue;
            vector3fArray[i] = null;
        }
        return vector3fArray;
    }

    private void readHeader() throws IOException {
        if (1234567L != this.myIn.readLong()) {
            throw new IOException("Binary Header doesn't match.  Maybe wrong file?");
        }
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void clearProperty(String string) {
        this.properties.remove(string);
    }
}

