/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLtoBinary {
    private DataOutputStream myOut;

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Correct way to use is: <FormatFile> <jmeoutputfile>");
            System.err.println("For example: runner.xml runner.jme");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (!file.canRead()) {
            System.err.println("Cannot read input file " + file);
            return;
        }
        try {
            System.out.println("Converting file " + file + " to " + file2);
            new XMLtoBinary().sendXMLtoBinary(new FileInputStream(file), new FileOutputStream(file2));
        }
        catch (IOException iOException) {
            System.err.println("Unable to convert:" + iOException);
            return;
        }
        System.out.println("Conversion complete!");
    }

    public void sendXMLtoBinary(InputStream inputStream, OutputStream outputStream) {
        this.myOut = new DataOutputStream(outputStream);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)new SAXConverter());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to do IO correctly:" + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("Serious parser configuration error:" + parserConfigurationException.getMessage());
        }
        catch (SAXParseException sAXParseException) {
            throw new RuntimeException(sAXParseException.toString() + '\n' + "Line: " + sAXParseException.getLineNumber() + '\n' + "Column: " + sAXParseException.getColumnNumber());
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Unknown sax error: " + sAXException.getMessage());
        }
    }

    private class SAXConverter
    extends DefaultHandler {
        private static final boolean DEBUG = false;

        private SAXConverter() {
        }

        public void startDocument() throws SAXException {
            try {
                XMLtoBinary.this.myOut.writeLong(1234567L);
            }
            catch (IOException iOException) {
                throw new SAXException("Unable to write header:" + iOException);
            }
        }

        public void endDocument() throws SAXException {
            try {
                XMLtoBinary.this.myOut.writeByte(2);
                XMLtoBinary.this.myOut.close();
            }
            catch (IOException iOException) {
                throw new SAXException("Unable to close binFile outStream:" + iOException);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                XMLtoBinary.this.myOut.writeByte(0);
                XMLtoBinary.this.myOut.writeUTF(string3);
                XMLtoBinary.this.myOut.writeByte(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getQName(i);
                    XMLtoBinary.this.myOut.writeUTF(string4);
                    this.processWrite(string3, string4, attributes.getValue(i));
                }
            }
            catch (IOException iOException) {
                throw new SAXException("Unable to write start element: " + string3 + " " + iOException);
            }
        }

        private void processWrite(String string, String string2, String string3) throws IOException {
            if ("data".equals(string2)) {
                if ("vertex".equals(string) || "normal".equals(string) || "origvertex".equals(string) || "orignormal".equals(string)) {
                    this.writeVector3fArray(string3);
                } else if ("color".equals(string)) {
                    this.writeColorArray(string3);
                } else if ("texturecoords".equals(string)) {
                    this.writeVector2fArray(string3);
                } else if ("index".equals(string) || "jointindex".equals(string)) {
                    this.writeIntArray(string3);
                } else if ("defcolor".equals(string)) {
                    this.writeColor(string3);
                } else {
                    this.writeString(string3);
                }
            } else if ("boundsphere".equals(string)) {
                if ("radius".equals(string2)) {
                    this.writeFloat(string3);
                } else if ("center".equals(string2)) {
                    this.writeVec3f(string3);
                }
            } else if ("clodrecords".equals(string)) {
                if ("numrec".equals(string2)) {
                    this.writeInt(string3);
                }
            } else if ("obb".equals(string)) {
                if ("xaxis".equals(string2) || "yaxis".equals(string2) || "zaxis".equals(string2) || "extent".equals(string2)) {
                    this.writeVec3f(string3);
                } else if ("center".equals(string2)) {
                    this.writeVec3f(string3);
                }
            } else if ("crecord".equals(string)) {
                if ("indexary".equals(string2)) {
                    this.writeIntArray(string3);
                } else if ("numi".equals(string2) || "numt".equals(string2) || "numv".equals(string2) || "vkeep".equals(string2) || "vthrow".equals(string2) || "index".equals(string2)) {
                    this.writeInt(string3);
                }
            } else if ("terrainblock".equals(string) || "terrainpage".equals(string)) {
                if ("tbsize".equals(string2) || "totsize".equals(string2) || "size".equals(string2) || "offamnt".equals(string2)) {
                    this.writeInt(string3);
                } else if ("step".equals(string2) || "stepscale".equals(string2) || "translation".equals(string2)) {
                    this.writeVec3f(string3);
                } else if ("isclod".equals(string2)) {
                    this.writeBoolean(string3);
                } else if ("offset".equals(string2)) {
                    this.writeVec2f(string3);
                } else if ("hmap".equals(string2)) {
                    this.writeIntArray(string3);
                }
                if ("disttol".equals(string2) || "trisppix".equals(string2)) {
                    this.writeFloat(string3);
                } else if ("name".equals(string2)) {
                    this.writeString(string3);
                }
            } else if ("areaclod".equals(string)) {
                if ("disttol".equals(string2) || "trisppix".equals(string2)) {
                    this.writeFloat(string3);
                } else if ("name".equals(string2)) {
                    this.writeString(string3);
                }
            } else if ("alphastate".equals(string)) {
                if ("srcfunc".equals(string2) || "dstfunc".equals(string2) || "testfunc".equals(string2)) {
                    this.writeInt(string3);
                } else if ("reference".equals(string2)) {
                    this.writeFloat(string3);
                } else if ("blend".equals(string2) || "test".equals(string2) || "enabled".equals(string2)) {
                    this.writeBoolean(string3);
                }
            } else if ("index".equals(string2)) {
                if ("sptscale".equals(string) || "sptrot".equals(string) || "spttrans".equals(string)) {
                    this.writeIntArray(string3);
                } else if ("joint".equals(string)) {
                    this.writeInt(string3);
                } else {
                    this.writeString(string3);
                }
            } else if ("loc".equals(string2) || "dir".equals(string2) || "scale".equals(string2) || "translation".equals(string2) || "trans".equals(string2) || "localvec".equals(string2) || "origcent".equals(string2) || "origext".equals(string2) || "nowcent".equals(string2) || "nowext".equals(string2)) {
                this.writeVec3f(string3);
            } else if ("rotation".equals(string2) || "rot".equals(string2)) {
                this.writeQuat(string3);
            } else if ("localrot".equals(string2)) {
                this.writeMatrix3(string3);
            } else if ("alpha".equals(string2) || "shiny".equals(string2) || "time".equals(string2) || "width".equals(string2)) {
                this.writeFloat(string3);
            } else if ("fps".equals(string2) || "speed".equals(string2) || "fconstant".equals(string2) || "flinear".equals(string2) || "fquadratic".equals(string2) || "fangle".equals(string2) || "fexponent".equals(string2)) {
                this.writeFloat(string3);
            } else if ("ambient".equals(string2) || "diffuse".equals(string2) || "emissive".equals(string2) || "specular".equals(string2)) {
                this.writeColor(string3);
            } else if ("URL".equals(string2)) {
                this.writeURL(string3);
            } else if ("isattenuate".equals(string2)) {
                this.writeBoolean(string3);
            } else if ("rptype".equals(string2) || "numJoints".equals(string2) || "parentindex".equals(string2)) {
                this.writeInt(string3);
            } else if ("v3farray".equals(string2) || "scalevalues".equals(string2) || "transvalues".equals(string2)) {
                this.writeVector3fArray(string3);
            } else if ("quatarray".equals(string2) || "rotvalues".equals(string2)) {
                this.writeQuatArray(string3);
            } else if ("q3norm".equals(string2)) {
                this.writeShortArray(string3);
            } else if ("q3vert".equals(string2)) {
                this.writeByteArray(string3);
            } else if ("texnum".equals(string2) || "wrap".equals(string2) || "parnum".equals(string2) || "obnum".equals(string2) || "facetype".equals(string2) || "numobjects".equals(string2)) {
                this.writeInt(string3);
            } else {
                this.writeString(string3);
            }
        }

        private void writeShortArray(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(14);
            if (string == null || string.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] stringArray = this.removeDoubleWhiteSpaces(string).trim().split(" ");
            if (stringArray.length == 1 && "".equals(stringArray[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            XMLtoBinary.this.myOut.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                XMLtoBinary.this.myOut.writeShort(Short.parseShort(stringArray[i]));
            }
        }

        private void writeByteArray(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(13);
            if (string == null || string.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] stringArray = this.removeDoubleWhiteSpaces(string).trim().split(" ");
            if (stringArray.length == 1 && "".equals(stringArray[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            XMLtoBinary.this.myOut.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                XMLtoBinary.this.myOut.writeShort(Byte.parseByte(stringArray[i]));
            }
        }

        private void writeQuatArray(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(12);
            if (string == null || string.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] stringArray = this.removeDoubleWhiteSpaces(string).trim().split(" ");
            if (stringArray.length == 1 && "".equals(stringArray[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            if (stringArray.length % 4 != 0) {
                throw new IOException("Quat length not modulus of 4: " + stringArray.length);
            }
            XMLtoBinary.this.myOut.writeInt(stringArray.length / 4);
            for (int i = 0; i < stringArray.length / 4; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 4 + 0]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 4 + 1]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 4 + 2]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 4 + 3]));
            }
        }

        private void writeBoolean(String string) throws IOException {
            boolean bl;
            if ("true".equals(string)) {
                bl = true;
            } else if ("false".equals(string)) {
                bl = false;
            } else {
                throw new IOException("Parameter must be true or false, not " + string);
            }
            XMLtoBinary.this.myOut.writeByte(11);
            XMLtoBinary.this.myOut.writeBoolean(bl);
        }

        private void writeInt(String string) throws IOException {
            XMLtoBinary.this.myOut.write(10);
            XMLtoBinary.this.myOut.writeInt(Integer.parseInt(string));
        }

        private void writeURL(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(9);
            XMLtoBinary.this.myOut.writeUTF(string);
        }

        private void writeColor(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(8);
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length != 4) {
                throw new IOException("ilformated Color:" + string);
            }
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[0]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[1]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[2]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[3]));
        }

        private void writeFloat(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(7);
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(string));
        }

        private void writeMatrix3(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(16);
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length != 9) {
                throw new IOException("ilformated Matrix3:" + string);
            }
            for (int i = 0; i < 9; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i]));
            }
        }

        private void writeQuat(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(6);
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length != 4) {
                throw new IOException("ilformated Quat:" + string);
            }
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[0]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[1]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[2]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[3]));
        }

        private void writeVec3f(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(5);
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length != 3) {
                throw new IOException("ilformated Vector3f:" + string);
            }
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[0]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[1]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[2]));
        }

        private void writeVec2f(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(15);
            String[] stringArray = string.trim().split(" ");
            if (stringArray.length != 2) {
                throw new IOException("ilformated Vector2f:" + string);
            }
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[0]));
            XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[1]));
        }

        private void writeString(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(3);
            XMLtoBinary.this.myOut.writeUTF(string);
        }

        private void writeIntArray(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(4);
            if (string == null || string.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] stringArray = this.removeDoubleWhiteSpaces(string).trim().split(" ");
            if (stringArray.length == 1 && "".equals(stringArray[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            XMLtoBinary.this.myOut.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                XMLtoBinary.this.myOut.writeInt(Integer.parseInt(stringArray[i]));
            }
        }

        private void writeVector2fArray(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(1);
            if (string == null || string.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] stringArray = this.removeDoubleWhiteSpaces(string).trim().split(" ");
            if (stringArray.length == 1 && "".equals(stringArray[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            if (stringArray.length % 2 != 0) {
                throw new IOException("Vector2f length not modulus of 2: " + stringArray.length);
            }
            XMLtoBinary.this.myOut.writeInt(stringArray.length / 2);
            for (int i = 0; i < stringArray.length / 2; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 2 + 0]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 2 + 1]));
            }
        }

        public void writeColorArray(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(2);
            if (string == null || string.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] stringArray = this.removeDoubleWhiteSpaces(string).trim().split(" ");
            if (stringArray.length == 1 && "".equals(stringArray[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            if (stringArray.length % 4 != 0) {
                throw new IOException("Color length not modulus of 4: " + stringArray.length);
            }
            XMLtoBinary.this.myOut.writeInt(stringArray.length / 4);
            for (int i = 0; i < stringArray.length / 4; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 4 + 0]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 4 + 1]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 4 + 2]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 4 + 3]));
            }
        }

        private void writeVector3fArray(String string) throws IOException {
            XMLtoBinary.this.myOut.writeByte(0);
            if (string == null || string.length() == 0) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            String[] stringArray = this.removeDoubleWhiteSpaces(string).trim().split(" ");
            if (stringArray.length == 1 && "".equals(stringArray[0])) {
                XMLtoBinary.this.myOut.writeInt(0);
                return;
            }
            if (stringArray.length % 3 != 0) {
                throw new IOException("Vector3f length not modulus of 3: " + stringArray.length);
            }
            XMLtoBinary.this.myOut.writeInt(stringArray.length / 3);
            for (int i = 0; i < stringArray.length / 3; ++i) {
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 3 + 0]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 3 + 1]));
                XMLtoBinary.this.myOut.writeFloat(Float.parseFloat(stringArray[i * 3 + 2]));
            }
        }

        private String removeDoubleWhiteSpaces(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isWhitespace(string.charAt(i))) {
                    if (!bl && stringBuffer.length() != 0) {
                        stringBuffer.append(' ');
                    }
                    bl = true;
                    continue;
                }
                stringBuffer.append(string.charAt(i));
                bl = false;
            }
            return stringBuffer.toString();
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                XMLtoBinary.this.myOut.writeByte(1);
                XMLtoBinary.this.myOut.writeUTF(string3);
            }
            catch (IOException iOException) {
                throw new SAXException("Unable to write end element: " + string3 + " " + iOException);
            }
        }
    }
}

