/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.util;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.game.StandardGame;
import com.jmex.game.state.DebugGameState;
import com.jmex.game.state.GameState;
import com.jmex.game.state.GameStateManager;
import com.jmex.game.state.load.LoadingGameState;
import com.jmex.model.XMLparser.Converters.AseToJme;
import com.jmex.model.XMLparser.Converters.FormatConverter;
import com.jmex.model.XMLparser.Converters.MaxToJme;
import com.jmex.model.XMLparser.Converters.Md2ToJme;
import com.jmex.model.XMLparser.Converters.Md3ToJme;
import com.jmex.model.XMLparser.Converters.MilkToJme;
import com.jmex.model.XMLparser.Converters.ObjToJme;
import com.jmex.model.collada.ColladaImporter;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class ModelLoader {
    private static Map<String, ModelLoaderCallable> loaders = new HashMap<String, ModelLoaderCallable>();

    public static void main(String[] stringArray) {
        block14: {
            try {
                JFileChooser jFileChooser = new JFileChooser();
                Preferences preferences = Preferences.userNodeForPackage(ModelLoader.class);
                File file = new File(preferences.get("StartDirectory", "."));
                jFileChooser.setCurrentDirectory(file);
                if (jFileChooser.showOpenDialog(null) != 0) break block14;
                File file2 = jFileChooser.getSelectedFile();
                if (ModelLoader.isValidModelFile(file2)) {
                    preferences.put("StartDirectory", file2.getAbsolutePath());
                    StandardGame standardGame = new StandardGame("Model Loader");
                    try {
                        standardGame.getSettings().clear();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    standardGame.start();
                    GameTaskQueueManager.getManager().update((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return null;
                        }
                    });
                    DebugGameState debugGameState = new DebugGameState();
                    GameStateManager.getInstance().attachChild((GameState)debugGameState);
                    debugGameState.setActive(true);
                    LoadingGameState loadingGameState = new LoadingGameState();
                    GameStateManager.getInstance().attachChild((GameState)loadingGameState);
                    loadingGameState.setActive(true);
                    loadingGameState.setProgress(0.5f, "Loading Model: " + file2.getName());
                    long l = System.currentTimeMillis();
                    Node node = ModelLoader.loadModel(file2);
                    ModelLoader.outputElapsed(l);
                    if (node != null) {
                        node.updateRenderState();
                        if (file2.getName().toLowerCase().endsWith(".jme")) {
                            loadingGameState.setProgress(1.0f, "Loaded Successfully");
                        } else {
                            loadingGameState.setProgress(0.8f, "Loaded Successfully - Saving");
                            try {
                                BinaryExporter.getInstance().save((Savable)node, ModelLoader.createJMEFile(file2.getAbsoluteFile()));
                                loadingGameState.setProgress(1.0f, "Binary File Written Successfully");
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                loadingGameState.setProgress(0.9f, "Binary Save Failure");
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                                loadingGameState.setProgress(1.0f);
                            }
                        }
                        debugGameState.getRootNode().attachChild((Spatial)ModelLoader.scale(node));
                        debugGameState.getRootNode().updateRenderState();
                        break block14;
                    }
                    loadingGameState.setProgress(0.9f, "Model Not Loaded");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    loadingGameState.setProgress(1.0f);
                    break block14;
                }
                JOptionPane.showMessageDialog(null, "Selected file's extension is unknown model type: " + file2.getName());
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                JFrame jFrame = new JFrame();
                jFrame.setTitle("ModelLoader - StackTrace");
                jFrame.setDefaultCloseOperation(3);
                JTextPane jTextPane = new JTextPane();
                jTextPane.setPreferredSize(new Dimension(400, 400));
                jTextPane.setContentType("text/plain");
                jTextPane.setText(stringWriter.getBuffer().toString());
                jFrame.setContentPane(new JScrollPane(jTextPane));
                jFrame.pack();
                jFrame.setLocationRelativeTo(null);
                jFrame.setVisible(true);
            }
        }
    }

    private static File createJMEFile(File file) {
        String string = file.getName();
        if (string.indexOf(46) != -1) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        string = string + ".jme";
        return new File(file.getParentFile(), string);
    }

    private static void outputElapsed(long l) {
        float f = (float)(System.currentTimeMillis() - l) / 1000.0f;
        System.out.println("Took " + f + " seconds to load the model.");
    }

    public static Node loadModel(File file) throws Exception {
        String string = ModelLoader.extensionOf(file);
        ModelLoaderCallable modelLoaderCallable = loaders.get(string);
        if (modelLoaderCallable == null) {
            throw new UnsupportedOperationException("Unknown file type: " + file.getName());
        }
        modelLoaderCallable.setFile(file);
        Future future = GameTaskQueueManager.getManager().update((Callable)modelLoaderCallable);
        return (Node)future.get();
    }

    private static String extensionOf(File file) {
        String string = file.getName().toUpperCase();
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(n + 1) : "";
        return string2;
    }

    private static Node scale(Node node) {
        if (node != null) {
            node.updateGeometricState(0.0f, true);
            BoundingVolume boundingVolume = node.getWorldBound();
            if (boundingVolume == null) {
                node.setModelBound((BoundingVolume)new BoundingBox());
                node.updateModelBound();
                node.updateGeometricState(0.0f, true);
                boundingVolume = node.getWorldBound();
            }
            if (boundingVolume != null) {
                Vector3f vector3f = boundingVolume.getCenter();
                BoundingBox boundingBox = new BoundingBox(vector3f, 0.0f, 0.0f, 0.0f);
                boundingBox.mergeLocal(boundingVolume);
                Vector3f vector3f2 = boundingBox.getExtent(null);
                float f = Math.max(Math.max(vector3f2.x, vector3f2.y), vector3f2.z);
                if (f != 0.0f) {
                    Node node2 = new Node("scaled model");
                    node2.attachChild((Spatial)node);
                    node2.setLocalScale(5.0f / f);
                    node = node2;
                }
            }
        }
        return node;
    }

    public static boolean isValidModelFile(File file) {
        return loaders.containsKey(ModelLoader.extensionOf(file));
    }

    static {
        loaders.put("DAE", new DAECallable());
        loaders.put("JME", new JMECallable());
        loaders.put("OBJ", new OBJCallable());
        loaders.put("3DS", new TDSCallable());
        loaders.put("ASE", new ASECallable());
        loaders.put("MD2", new MD2Callable());
        loaders.put("MD3", new MD3Callable());
        loaders.put("MS3D", new MilkCallable());
    }

    private static class MilkCallable
    implements ModelLoaderCallable {
        private File file;

        private MilkCallable() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Node call() throws Exception {
            MilkToJme milkToJme = new MilkToJme();
            URL uRL = this.file.toURI().toURL();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((FormatConverter)milkToJme).convert(uRL.openStream(), byteArrayOutputStream);
            Node node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return node;
        }
    }

    private static class MD3Callable
    implements ModelLoaderCallable {
        private File file;

        private MD3Callable() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Node call() throws Exception {
            Md3ToJme md3ToJme = new Md3ToJme();
            URL uRL = this.file.toURI().toURL();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((FormatConverter)md3ToJme).convert(uRL.openStream(), byteArrayOutputStream);
            Node node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return node;
        }
    }

    private static class MD2Callable
    implements ModelLoaderCallable {
        private File file;

        private MD2Callable() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Node call() throws Exception {
            Md2ToJme md2ToJme = new Md2ToJme();
            URL uRL = this.file.toURI().toURL();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((FormatConverter)md2ToJme).convert(uRL.openStream(), byteArrayOutputStream);
            Node node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return node;
        }
    }

    private static class ASECallable
    implements ModelLoaderCallable {
        private File file;

        private ASECallable() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Node call() throws Exception {
            AseToJme aseToJme = new AseToJme();
            URL uRL = this.file.toURI().toURL();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((FormatConverter)aseToJme).convert(uRL.openStream(), byteArrayOutputStream);
            Node node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return node;
        }
    }

    private static class TDSCallable
    implements ModelLoaderCallable {
        private File file;

        private TDSCallable() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Node call() throws Exception {
            MaxToJme maxToJme = new MaxToJme();
            URL uRL = this.file.toURI().toURL();
            maxToJme.setProperty("texurl", uRL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((FormatConverter)maxToJme).convert(uRL.openStream(), byteArrayOutputStream);
            Node node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return node;
        }
    }

    private static class OBJCallable
    implements ModelLoaderCallable {
        private File file;

        private OBJCallable() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Node call() throws Exception {
            ObjToJme objToJme = new ObjToJme();
            URL uRL = this.file.toURI().toURL();
            objToJme.setProperty("mtllib", uRL);
            objToJme.setProperty("texdir", uRL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((FormatConverter)objToJme).convert(uRL.openStream(), byteArrayOutputStream);
            Savable savable = BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            if (savable instanceof Node) {
                return (Node)savable;
            }
            Node node = new Node("Imported Model " + this.file.getName());
            node.attachChild((Spatial)savable);
            return node;
        }
    }

    private static class DAECallable
    implements ModelLoaderCallable {
        private File file;

        private DAECallable() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Node call() throws Exception {
            ColladaImporter.load((InputStream)this.file.toURI().toURL().openStream(), (URL)this.file.getAbsoluteFile().getParentFile().toURI().toURL(), (String)"Model");
            Node node = ColladaImporter.getModel();
            return node;
        }
    }

    private static class JMECallable
    implements ModelLoaderCallable {
        private File file;

        private JMECallable() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public Node call() throws Exception {
            return (Node)BinaryImporter.getInstance().load(this.file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ModelLoaderCallable
    extends Callable<Node> {
        public void setFile(File var1);
    }
}

