/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada;

import com.jme.app.SimpleHeadlessApp;
import com.jme.scene.Spatial;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jmex.model.collada.ColladaImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ColladaToFate
extends SimpleHeadlessApp {
    Spatial collada;
    static String in;
    static String texDir;
    static String outDir;

    public static void main(String[] stringArray) {
        if (stringArray.length < 3 || stringArray.length > 3) {
            System.out.println("USAGE: ColladaToFate <COLLADA File> <Texture Directory> <Fate File>");
            System.exit(1);
        }
        in = stringArray[0];
        texDir = stringArray[1];
        outDir = stringArray[2];
        File file = new File(outDir);
        if (!file.exists()) {
            file.mkdir();
        }
        ColladaToFate colladaToFate = new ColladaToFate();
        colladaToFate.start();
    }

    protected void simpleInitGame() {
        long l = System.nanoTime();
        this.writeFile(in, texDir);
        this.finished = true;
        long l2 = System.nanoTime();
        System.out.println("Conversion took: " + (l2 - l) / 1000000000L + " seconds.");
    }

    protected void writeFile(String string2, String string3) {
        File file = new File(string2);
        if (file.isDirectory()) {
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            System.out.println(string2 + " is a Directory, getting subfiles: ");
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("Sending: " + string2 + stringArray[i]);
                this.writeFile(string2 + stringArray[i], string3);
            }
            return;
        }
        if (file.getName().toUpperCase().endsWith(".DAE")) {
            this.collada = null;
            System.gc();
            System.out.println("Found Collada file, converting: " + string2);
            String string4 = outDir + file.getName().substring(0, file.getName().toUpperCase().indexOf(".DAE")) + ".fate";
            System.out.println("Storing as: " + string4);
            URL uRL = null;
            String string5 = file.getName().substring(0, file.getName().indexOf("."));
            try {
                uRL = new File(texDir).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            if (fileInputStream == null) {
                System.out.println("Unable to find file");
                System.exit(0);
            }
            try {
                ColladaImporter.load(fileInputStream, uRL, string5);
                this.collada = ColladaImporter.getModel();
                ColladaImporter.cleanUp();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.collada.updateGeometricState(0.0f, true);
            this.collada.updateRenderState();
            try {
                File file2 = new File(string4);
                if (file2.exists()) {
                    file2.delete();
                }
                BinaryExporter.getInstance().save((Savable)this.collada, file2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

