/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeNumber;
import com.jmex.model.collada.types.TypesIncompatibleException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaByte
implements SchemaTypeNumber {
    private static final long serialVersionUID = 1L;
    protected byte value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaByte() {
        this.setEmpty();
    }

    public SchemaByte(SchemaByte schemaByte) {
        this.value = schemaByte.value;
        this.isempty = schemaByte.isempty;
        this.isnull = schemaByte.isnull;
    }

    public SchemaByte(int n) {
        this.setValue(n);
    }

    public SchemaByte(String string2) {
        this.parse(string2);
    }

    public SchemaByte(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaByte(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = (byte)n;
        this.isempty = false;
        this.isnull = false;
    }

    public void parse(String string2) {
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            this.isempty = false;
            this.isnull = false;
            this.value = Byte.parseByte(string2);
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else {
            this.isnull = false;
            this.isempty = false;
            if (schemaType instanceof SchemaTypeNumber) {
                this.value = (byte)((SchemaTypeNumber)schemaType).intValue();
            } else {
                throw new TypesIncompatibleException(schemaType, this);
            }
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = 0;
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = 0;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaByte)) {
            return false;
        }
        return this.value == ((SchemaByte)object).value;
    }

    public Object clone() {
        return new SchemaByte(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        return Byte.toString(this.value);
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaByte)object);
    }

    public int compareTo(SchemaByte schemaByte) {
        return new Byte(this.value).compareTo(new Byte(schemaByte.value));
    }

    public int numericType() {
        return 1;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }
}

