/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaDuration;
import com.jmex.model.collada.types.SchemaTypeCalendar;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.TypesIncompatibleException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class SchemaCalendarBase
implements SchemaTypeCalendar {
    public static final int TZ_MISSING = 0;
    public static final int TZ_UTC = 1;
    public static final int TZ_OFFSET = 2;
    protected int year;
    protected int month;
    protected int day;
    protected int hour;
    protected int minute;
    protected int second;
    protected double partsecond;
    protected int hasTZ;
    protected int offsetTZ;
    protected boolean isempty;

    public SchemaCalendarBase() {
        this.setEmpty();
    }

    public void setNull() {
        this.setEmpty();
    }

    public void setEmpty() {
        this.isempty = true;
        this.setInternalValues(0, 0, 0, 0, 0, 0, 0.0, 0, 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaCalendarBase)) {
            return false;
        }
        SchemaCalendarBase schemaCalendarBase = (SchemaCalendarBase)object;
        if (this.year != schemaCalendarBase.year) {
            return false;
        }
        if (this.month != schemaCalendarBase.month) {
            return false;
        }
        if (this.day != schemaCalendarBase.day) {
            return false;
        }
        if (this.hour != schemaCalendarBase.hour) {
            return false;
        }
        if (this.minute != schemaCalendarBase.minute) {
            return false;
        }
        if (this.second != schemaCalendarBase.second) {
            return false;
        }
        if (this.partsecond != schemaCalendarBase.partsecond) {
            return false;
        }
        if (this.hasTZ != schemaCalendarBase.hasTZ) {
            return false;
        }
        return this.offsetTZ == schemaCalendarBase.offsetTZ;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.getApproximatedTotal());
    }

    public String toDateString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new DecimalFormat("0000").format(this.year));
        stringBuffer.append("-");
        stringBuffer.append(new DecimalFormat("00").format(this.month));
        stringBuffer.append("-");
        stringBuffer.append(new DecimalFormat("00").format(this.day));
        return stringBuffer.toString();
    }

    public String toTimeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new DecimalFormat("00").format(this.hour));
        stringBuffer.append(":");
        stringBuffer.append(new DecimalFormat("00").format(this.minute));
        stringBuffer.append(":");
        stringBuffer.append(new DecimalFormat("00").format(this.second));
        if (this.partsecond > 0.0 && this.partsecond < 1.0) {
            String string2 = new DecimalFormat("0.0###############").format(this.partsecond);
            stringBuffer.append(".");
            stringBuffer.append(string2.substring(2, string2.length()));
        }
        if (this.hasTZ == 1) {
            stringBuffer.append("Z");
        } else if (this.hasTZ == 2) {
            int n = this.offsetTZ;
            if (this.offsetTZ < 0) {
                stringBuffer.append("-");
                n = -this.offsetTZ;
            } else {
                stringBuffer.append("+");
            }
            stringBuffer.append(new DecimalFormat("00").format(n / 60));
            stringBuffer.append(":");
            stringBuffer.append(new DecimalFormat("00").format(n % 60));
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return true;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isEmpty();
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaCalendarBase)object);
    }

    public int compareTo(SchemaCalendarBase schemaCalendarBase) {
        return (int)(this.getApproximatedTotal() - schemaCalendarBase.getApproximatedTotal());
    }

    protected void parseDate(String string2) throws StringParseException {
        if (string2.length() == 0) {
            this.isempty = true;
        } else {
            if (string2.length() < 10) {
                throw new StringParseException("date-part of string is too short", 0);
            }
            try {
                int n = 0;
                if (string2.substring(0, 1).equals("-")) {
                    n = 1;
                }
                this.year = Integer.parseInt(string2.substring(0, n + 4));
                if (!string2.substring(n + 4, n + 5).equals("-")) {
                    throw new StringParseException("invalid date format", 2);
                }
                this.month = Integer.parseInt(string2.substring(n + 5, n + 7));
                if (!string2.substring(n + 7, n + 8).equals("-")) {
                    throw new StringParseException("invalid date format", 2);
                }
                this.day = Integer.parseInt(string2.substring(n + 8, string2.length()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException("invalid date format", 2);
            }
            this.isempty = false;
        }
    }

    protected void parseTime(String string2) throws StringParseException {
        if (string2.length() < 8) {
            throw new StringParseException("time-part of string is too short", 0);
        }
        try {
            int n = 0;
            this.hour = Integer.parseInt(string2.substring(n, n + 2));
            if (!string2.substring(n + 2, n + 3).equals(":")) {
                throw new StringParseException("invalid date format", 2);
            }
            this.minute = Integer.parseInt(string2.substring(n + 3, n + 5));
            if (!string2.substring(n + 5, n + 6).equals(":")) {
                throw new StringParseException("invalid date format", 2);
            }
            this.second = Integer.parseInt(string2.substring(n + 6, n + 8));
            int n2 = n + 8;
            this.partsecond = 0.0;
            if (string2.length() > n + 8) {
                n = n2;
                int n3 = string2.length();
                int n4 = string2.indexOf("Z", n);
                if (n4 > -1 && n4 < n3) {
                    n3 = n4;
                }
                if ((n4 = string2.indexOf("+", n)) > -1 && n4 < n3) {
                    n3 = n4;
                }
                if ((n4 = string2.indexOf("-", n)) > -1 && n4 < n3) {
                    n3 = n4;
                }
                n2 = n3;
                this.partsecond = Double.parseDouble("0" + string2.substring(n, n3));
            }
            this.hasTZ = 0;
            this.offsetTZ = 0;
            if (string2.length() > n2 && string2.substring(n2, n2 + 1).equals("Z")) {
                this.hasTZ = 1;
            } else if (string2.length() == n2 + 6) {
                this.hasTZ = 2;
                this.offsetTZ = Integer.parseInt(string2.substring(n2 + 1, n2 + 3)) * 60 + Integer.parseInt(string2.substring(n2 + 4, n2 + 6));
                if (string2.substring(n2, n2 + 1).equals("-")) {
                    this.offsetTZ = -this.offsetTZ;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new StringParseException("invalid number format", 2);
        }
        this.isempty = false;
    }

    public double getApproximatedTotal() {
        return (double)this.second + 60.0 * ((double)this.minute + 60.0 * ((double)this.hour + 24.0 * ((double)this.day + 31.0 * ((double)this.month + 12.0 * (double)this.year)))) + this.partsecond;
    }

    public Date getDate() {
        String string2 = this.toDateString() + " " + this.toTimeString();
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string2);
        }
        catch (ParseException parseException) {
            throw new StringParseException("Could not convert to date.", 0);
        }
    }

    protected void setInternalValues(int n, int n2, int n3, int n4, int n5, int n6, double d, int n7, int n8) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.partsecond = d;
        this.hasTZ = n7;
        this.offsetTZ = n8;
        this.isempty = false;
    }

    public SchemaDuration durationValue() {
        throw new TypesIncompatibleException(this, new SchemaDuration("PT"));
    }
}

