/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaCalendarBase;
import com.jmex.model.collada.types.SchemaDateTime;
import com.jmex.model.collada.types.SchemaString;
import com.jmex.model.collada.types.SchemaTime;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeCalendar;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.TypesIncompatibleException;
import java.util.Calendar;

public class SchemaDate
extends SchemaCalendarBase {
    private static final long serialVersionUID = 1L;

    public SchemaDate() {
        this.setEmpty();
    }

    public SchemaDate(SchemaDate schemaDate) {
        this.year = schemaDate.year;
        this.month = schemaDate.month;
        this.day = schemaDate.day;
        this.hour = schemaDate.hour;
        this.minute = schemaDate.minute;
        this.second = schemaDate.second;
        this.partsecond = schemaDate.partsecond;
        this.hasTZ = schemaDate.hasTZ;
        this.offsetTZ = schemaDate.offsetTZ;
        this.isempty = schemaDate.isempty;
    }

    public SchemaDate(SchemaDateTime schemaDateTime) {
        this.year = schemaDateTime.year;
        this.month = schemaDateTime.month;
        this.day = schemaDateTime.day;
        this.hour = schemaDateTime.hour;
        this.minute = schemaDateTime.minute;
        this.second = schemaDateTime.second;
        this.partsecond = schemaDateTime.partsecond;
        this.hasTZ = schemaDateTime.hasTZ;
        this.offsetTZ = schemaDateTime.offsetTZ;
        this.isempty = schemaDateTime.isempty;
    }

    public SchemaDate(int n, int n2, int n3) {
        this.setInternalValues(n, n2, n3, 0, 0, 0, 0.0, 0, 0);
        this.isempty = false;
    }

    public SchemaDate(Calendar calendar) {
        this.setValue(calendar);
    }

    public SchemaDate(String string2) {
        this.parse(string2);
    }

    public SchemaDate(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaDate(SchemaTypeCalendar schemaTypeCalendar) {
        this.assign(schemaTypeCalendar);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Calendar getValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year, this.month - 1, this.day);
        return calendar;
    }

    public void setYear(int n) {
        this.year = n;
        this.isempty = false;
    }

    public void setMonth(int n) {
        this.month = n;
        this.isempty = false;
    }

    public void setDay(int n) {
        this.day = n;
        this.isempty = false;
    }

    public void setValue(Calendar calendar) {
        if (calendar == null) {
            this.setEmpty();
        } else {
            this.setInternalValues(calendar.get(1), calendar.get(2) + 1, calendar.get(5), 0, 0, 0, 0.0, 0, 0);
            this.isempty = false;
        }
    }

    public void parse(String string2) throws StringParseException {
        if (string2 == null || string2.length() == 0) {
            this.setEmpty();
        } else {
            this.parseDate(string2);
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull() || schemaType.isEmpty()) {
            this.setEmpty();
        } else {
            this.isempty = false;
            if (schemaType instanceof SchemaDate) {
                this.year = ((SchemaDate)schemaType).year;
                this.month = ((SchemaDate)schemaType).month;
                this.day = ((SchemaDate)schemaType).day;
            } else if (schemaType instanceof SchemaDateTime) {
                this.year = ((SchemaDateTime)schemaType).year;
                this.month = ((SchemaDateTime)schemaType).month;
                this.day = ((SchemaDateTime)schemaType).day;
            } else if (schemaType instanceof SchemaString) {
                this.parse(((Object)schemaType).toString());
            } else {
                throw new TypesIncompatibleException(schemaType, this);
            }
        }
    }

    public void setEmpty() {
        this.setValue(Calendar.getInstance());
        this.isempty = true;
    }

    public Object clone() {
        return new SchemaDate(this);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return this.toDateString();
    }

    public static SchemaDate now() {
        return new SchemaDate(Calendar.getInstance());
    }

    public int calendarType() {
        return 2;
    }

    public SchemaDateTime dateTimeValue() {
        return new SchemaDateTime(this);
    }

    public SchemaDate dateValue() {
        return new SchemaDate(this);
    }

    public SchemaTime timeValue() {
        throw new TypesIncompatibleException(this, new SchemaTime("2003-07-28"));
    }
}

