/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaInteger;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeNumber;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.TypesIncompatibleException;
import com.jmex.model.collada.types.ValuesNotConvertableException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaFloat
implements SchemaTypeNumber {
    private static final long serialVersionUID = 1L;
    protected float value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaFloat() {
        this.setEmpty();
    }

    public SchemaFloat(SchemaFloat schemaFloat) {
        this.value = schemaFloat.value;
        this.isempty = schemaFloat.isempty;
        this.isnull = schemaFloat.isnull;
    }

    public SchemaFloat(float f) {
        this.setValue(f);
    }

    public SchemaFloat(double d) {
        this.setValue((float)d);
    }

    public SchemaFloat(String string2) {
        this.parse(string2);
    }

    public SchemaFloat(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaFloat(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float f) {
        this.value = f;
        this.isempty = false;
        this.isnull = false;
    }

    public void parse(String string2) {
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            try {
                this.value = Float.parseFloat(string2);
                this.isempty = false;
                this.isnull = false;
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException(numberFormatException);
            }
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTypeNumber) {
            this.value = ((SchemaTypeNumber)schemaType).floatValue();
            this.isempty = false;
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = 0.0f;
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = 0.0f;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaFloat)) {
            return false;
        }
        return this.value == ((SchemaFloat)object).value;
    }

    public Object clone() {
        return new SchemaFloat(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        String string2 = Float.toString(this.value);
        if (string2.length() > 2 && string2.substring(string2.length() - 2, string2.length()).equals(".0")) {
            return string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value != 0.0f && this.value != Float.NaN;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaFloat)object);
    }

    public int compareTo(SchemaFloat schemaFloat) {
        return Float.compare(this.value, schemaFloat.value);
    }

    public int numericType() {
        return 4;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public BigInteger bigIntegerValue() {
        try {
            return new BigInteger(this.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaInteger(0L));
        }
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }
}

