/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeNumber;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.TypesIncompatibleException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaLong
implements SchemaTypeNumber {
    private static final long serialVersionUID = 1L;
    protected long value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaLong() {
        this.setEmpty();
    }

    public SchemaLong(SchemaLong schemaLong) {
        this.value = schemaLong.value;
        this.isempty = schemaLong.isempty;
        this.isnull = schemaLong.isnull;
    }

    public SchemaLong(long l) {
        this.setValue(l);
    }

    public SchemaLong(String string2) {
        this.parse(string2);
    }

    public SchemaLong(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaLong(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long l) {
        this.value = l;
        this.isempty = false;
        this.isnull = false;
    }

    public void parse(String string2) {
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            try {
                this.value = Long.parseLong(string2);
                this.isempty = false;
                this.isnull = false;
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException(numberFormatException);
            }
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTypeNumber) {
            this.value = ((SchemaTypeNumber)schemaType).longValue();
            this.isempty = false;
            this.isnull = false;
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = 0L;
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = 0L;
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaLong)) {
            return false;
        }
        return this.value == ((SchemaLong)object).value;
    }

    public Object clone() {
        return new SchemaLong(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        return Long.toString(this.value);
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value != 0L;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaLong)object);
    }

    public int compareTo(SchemaLong schemaLong) {
        return new Long(this.value).compareTo(new Long(schemaLong.value));
    }

    public int numericType() {
        return 2;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }
}

