/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaDate;
import com.jmex.model.collada.types.SchemaDateTime;
import com.jmex.model.collada.types.SchemaDecimal;
import com.jmex.model.collada.types.SchemaDouble;
import com.jmex.model.collada.types.SchemaDuration;
import com.jmex.model.collada.types.SchemaFloat;
import com.jmex.model.collada.types.SchemaInt;
import com.jmex.model.collada.types.SchemaInteger;
import com.jmex.model.collada.types.SchemaLong;
import com.jmex.model.collada.types.SchemaTime;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeCalendar;
import com.jmex.model.collada.types.SchemaTypeNumber;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.ValuesNotConvertableException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaString
implements SchemaTypeNumber,
SchemaTypeCalendar {
    private static final long serialVersionUID = 1L;
    protected String value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaString() {
        this.setEmpty();
    }

    public SchemaString(SchemaString schemaString) {
        this.value = schemaString.value;
        this.isempty = schemaString.isempty;
        this.isnull = schemaString.isnull;
    }

    public SchemaString(String string2) {
        this.setValue(string2);
    }

    public SchemaString(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaString(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public SchemaString(SchemaTypeCalendar schemaTypeCalendar) {
        this.assign(schemaTypeCalendar);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string2) {
        if (string2 == null) {
            this.isempty = true;
            this.value = "";
            return;
        }
        this.value = string2;
        this.isempty = this.value.length() == 0;
    }

    public void parse(String string2) {
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            this.setValue(string2);
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else {
            this.value = ((Object)schemaType).toString();
            this.isempty = this.value.length() == 0;
            this.isnull = false;
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = "";
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = "";
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaString)) {
            return false;
        }
        return this.value.equals(((SchemaString)object).value);
    }

    public Object clone() {
        if (this.isnull) {
            SchemaString schemaString = new SchemaString();
            schemaString.setNull();
            return schemaString;
        }
        if (this.isempty) {
            return new SchemaString();
        }
        return new SchemaString(new String(this.value));
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        return this.value;
    }

    public int length() {
        return this.value.length();
    }

    public boolean booleanValue() {
        if (this.value == null || this.value.length() == 0 || this.value.compareToIgnoreCase("false") == 0) {
            return false;
        }
        if (this.isValueNumeric()) {
            return this.bigDecimalValue().compareTo(BigDecimal.valueOf(0L)) != 0;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaString)object);
    }

    public int compareTo(SchemaString schemaString) {
        return this.value.compareTo(schemaString.value);
    }

    public boolean isValueNumeric() {
        try {
            BigDecimal bigDecimal = new BigDecimal(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public int numericType() {
        return 6;
    }

    public int intValue() {
        if (this.isnull || this.isempty || this.value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaInt(0));
        }
    }

    public long longValue() {
        if (this.isnull || this.isempty || this.value.length() == 0) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaLong(0L));
        }
    }

    public BigInteger bigIntegerValue() {
        if (this.isnull || this.isempty || this.value.length() == 0) {
            return new BigInteger("0");
        }
        try {
            return new BigInteger(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaInteger(0L));
        }
    }

    public float floatValue() {
        if (this.isnull || this.isempty || this.value.length() == 0) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaFloat(0.0f));
        }
    }

    public double doubleValue() {
        if (this.isnull || this.isempty || this.value.length() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaDouble(0.0));
        }
    }

    public BigDecimal bigDecimalValue() {
        if (this.isnull || this.isempty || this.value.length() == 0) {
            return new BigDecimal(0);
        }
        try {
            return new BigDecimal(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaDecimal(0.0));
        }
    }

    public int calendarType() {
        return -1;
    }

    public SchemaDuration durationValue() {
        try {
            return new SchemaDuration(this.value);
        }
        catch (StringParseException stringParseException) {
            throw new ValuesNotConvertableException(this, new SchemaDuration("PT"));
        }
    }

    public SchemaDateTime dateTimeValue() {
        try {
            return new SchemaDateTime(this.value);
        }
        catch (StringParseException stringParseException) {
            throw new ValuesNotConvertableException(this, new SchemaDateTime("2003-08-06T00:00:00"));
        }
    }

    public SchemaDate dateValue() {
        try {
            return new SchemaDate(this.value);
        }
        catch (StringParseException stringParseException) {
            throw new ValuesNotConvertableException(this, new SchemaDate("2003-08-06"));
        }
    }

    public SchemaTime timeValue() {
        try {
            return new SchemaTime(this.value);
        }
        catch (StringParseException stringParseException) {
            throw new ValuesNotConvertableException(this, new SchemaTime("00:00:00"));
        }
    }
}

