/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaBoolean;
import com.jmex.model.collada.types.SchemaByte;
import com.jmex.model.collada.types.SchemaDate;
import com.jmex.model.collada.types.SchemaDateTime;
import com.jmex.model.collada.types.SchemaDecimal;
import com.jmex.model.collada.types.SchemaDuration;
import com.jmex.model.collada.types.SchemaInt;
import com.jmex.model.collada.types.SchemaInteger;
import com.jmex.model.collada.types.SchemaString;
import com.jmex.model.collada.types.SchemaTime;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.StringParseException;
import java.math.BigDecimal;

public class SchemaTypeFactory {
    public static SchemaType createInstanceByString(String string2) {
        if (string2 == null) {
            SchemaString schemaString = new SchemaString();
            schemaString.setNull();
            return schemaString;
        }
        if (string2.length() == 0) {
            return new SchemaString();
        }
        if (string2.compareToIgnoreCase("false") == 0) {
            return new SchemaBoolean(false);
        }
        if (string2.compareToIgnoreCase("true") == 0) {
            return new SchemaBoolean(true);
        }
        try {
            SchemaDateTime schemaDateTime = new SchemaDateTime(string2);
            return schemaDateTime;
        }
        catch (StringParseException stringParseException) {
            try {
                SchemaDuration schemaDuration = new SchemaDuration(string2);
                return schemaDuration;
            }
            catch (StringParseException stringParseException2) {
                try {
                    SchemaDate schemaDate = new SchemaDate(string2);
                    return schemaDate;
                }
                catch (StringParseException stringParseException3) {
                    try {
                        SchemaTime schemaTime = new SchemaTime(string2);
                        return schemaTime;
                    }
                    catch (StringParseException stringParseException4) {
                        try {
                            BigDecimal bigDecimal = new BigDecimal(string2);
                            if (bigDecimal.scale() <= 0) {
                                if (bigDecimal.compareTo(new BigDecimal(Integer.MAX_VALUE)) <= 0 && bigDecimal.compareTo(new BigDecimal(Integer.MIN_VALUE)) >= 0) {
                                    return new SchemaInt(bigDecimal.intValue());
                                }
                                return new SchemaInteger(bigDecimal.toBigInteger());
                            }
                            return new SchemaDecimal(bigDecimal);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return new SchemaString(string2);
                        }
                    }
                }
            }
        }
    }

    public static SchemaType createInstanceByObject(Object object) {
        if (object instanceof Boolean) {
            return new SchemaBoolean((Boolean)object);
        }
        if (object instanceof Byte) {
            return new SchemaByte(((Byte)object).byteValue());
        }
        return new SchemaString(object.toString());
    }
}

