/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.xml;

import com.jmex.model.collada.xml.Document;
import com.jmex.model.collada.xml.XmlException;
import java.io.Serializable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final short Attribute = 0;
    protected static final short Element = 1;
    protected static final short Text = 2;
    protected static final short CData = 3;
    protected static final short Comment = 4;
    protected static final short ProcessingInstruction = 5;
    protected org.w3c.dom.Node domNode = null;

    public Node(Node node) {
        this.domNode = node.domNode;
    }

    public Node(org.w3c.dom.Node node) {
        this.domNode = node;
    }

    public Node(org.w3c.dom.Document document) {
        this.domNode = document.getDocumentElement();
    }

    public Node(Document document, String string2, String string3, String string4) {
        this.domNode = document.createRootElement(string2, string4);
        this.mapPrefix(string3, string2);
        document.declareNamespaces(this);
    }

    public org.w3c.dom.Node getDomNode() {
        return this.domNode;
    }

    protected static String getDomNodeValue(org.w3c.dom.Node node) {
        if (node == null) {
            return null;
        }
        String string2 = node.getNodeValue();
        if (string2 != null) {
            return string2;
        }
        return Node.getInnerText(node);
    }

    protected static String getInnerText(org.w3c.dom.Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3) {
                stringBuffer.append(node2.getNodeValue());
                continue;
            }
            if (node2.getNodeType() == 1) {
                stringBuffer.append(Node.getInnerText(node2));
                continue;
            }
            if (node2.getNodeType() != 4) continue;
            stringBuffer.append(node2.getNodeValue());
        }
        return stringBuffer.toString();
    }

    public static String getNodeTextValue(org.w3c.dom.Node node) {
        return Node.getDomNodeValue(node);
    }

    protected static void setDomNodeValue(org.w3c.dom.Node node, String string2) {
        if (node == null) {
            return;
        }
        if (node.getNodeValue() != null) {
            node.setNodeValue(string2);
            return;
        }
        org.w3c.dom.Node node2 = node.getFirstChild();
        if (node2 == null || node2.getNodeType() != 3) {
            node.appendChild(node.getOwnerDocument().createTextNode(string2));
            return;
        }
    }

    public void mapPrefix(String string2, String string3) {
        if (string3 == null || string3.equals("")) {
            return;
        }
        Element element = (Element)this.domNode;
        if (string2 == null || string2.equals("")) {
            element.setAttribute("xmlns", string3);
        } else {
            element.setAttribute("xmlns:" + string2, string3);
        }
    }

    public void assign(Node node) {
        Node.setDomNodeValue(this.domNode, Node.getDomNodeValue(node.domNode).toString());
    }

    protected void declareNamespace(String string2, String string3) {
        if (string3 == null || string3.equals("")) {
            return;
        }
        Element element = this.domNode.getOwnerDocument().getDocumentElement();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!attr.getValue().equals(string3) || !attr.getName().startsWith("xmlns")) continue;
                return;
            }
        }
        if (string2 == null || string2.equals("")) {
            element.setAttribute("xmlns", string3);
        } else {
            element.setAttribute("xmlns:" + string2, string3);
        }
    }

    protected org.w3c.dom.Node appendDomChild(int n, String string2, String string3, String string4) {
        switch (n) {
            case 0: {
                Attr attr = this.domNode.getOwnerDocument().createAttributeNS(string2, string3);
                attr.setNodeValue(string4);
                this.domNode.getAttributes().setNamedItemNS(attr);
                return attr;
            }
            case 1: {
                Element element = this.domNode.getOwnerDocument().createElementNS(string2, string3);
                if (string4 != null && string4.length() != 0) {
                    element.appendChild(this.domNode.getOwnerDocument().createTextNode(string4));
                }
                this.domNode.appendChild(element);
                return element;
            }
            case 2: {
                Text text = this.domNode.getOwnerDocument().createTextNode(string4);
                this.domNode.appendChild(text);
                return text;
            }
            case 3: {
                CDATASection cDATASection = this.domNode.getOwnerDocument().createCDATASection(string4);
                this.domNode.appendChild(cDATASection);
                return cDATASection;
            }
            case 4: {
                Comment comment = this.domNode.getOwnerDocument().createComment(string4);
                this.domNode.appendChild(comment);
                return comment;
            }
            case 5: {
                ProcessingInstruction processingInstruction = this.domNode.getOwnerDocument().createProcessingInstruction(string3, string4);
                this.domNode.appendChild(processingInstruction);
                return processingInstruction;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected boolean domNodeNameEquals(org.w3c.dom.Node node, String string2, String string3) {
        String string4;
        if (node == null) {
            return false;
        }
        if (string3 == null) {
            return true;
        }
        String string5 = node.getNamespaceURI() == null ? "" : node.getNamespaceURI();
        String string6 = string4 = node.getLocalName() == null ? "" : node.getLocalName();
        if (string2 == null) {
            string2 = "";
        }
        return string5.equals(string2) && string4.equals(string3);
    }

    protected int getDomChildCount(int n, String string2, String string3) {
        switch (n) {
            case 0: {
                try {
                    return ((Element)this.domNode).hasAttributeNS(string2, string3) ? 1 : 0;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n2 = nodeList.getLength();
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    if (!this.domNodeNameEquals(node, string2, string3)) continue;
                    ++n3;
                }
                return n3;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected boolean hasDomChild(int n, String string2, String string3) {
        switch (n) {
            case 0: {
                return ((Element)this.domNode).hasAttributeNS(string2, string3);
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n2 = nodeList.getLength();
                for (int i = 0; i < n2; ++i) {
                    if (!this.domNodeNameEquals(nodeList.item(i), string2, string3)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node getDomChildAt(int n, String string2, String string3, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                return this.domNode.getAttributes().getNamedItemNS(string2, string3);
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n4 = nodeList.getLength();
                for (int i = 0; i < n4; ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    if (!this.domNodeNameEquals(node, string2, string3) || n3++ != n2) continue;
                    return node;
                }
                throw new XmlException("Index out of range");
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node getDomFirstChild(int n, String string2, String string3) {
        switch (n) {
            case 0: {
                if (!((Element)this.domNode).hasAttributeNS(string2, string3)) {
                    return null;
                }
                return this.domNode.getAttributes().getNamedItemNS(string2, string3);
            }
            case 1: {
                if (!this.domNode.hasChildNodes()) {
                    return null;
                }
                for (org.w3c.dom.Node node = this.domNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !this.domNodeNameEquals(node, string2, string3)) continue;
                    org.w3c.dom.Node node2 = node;
                    node = null;
                    return node2;
                }
                return null;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node getDomNextChild(int n, String string2, String string3, org.w3c.dom.Node node) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                org.w3c.dom.Node node2 = node;
                if (node2 != null) {
                    node2 = node2.getNextSibling();
                }
                while (node2 != null) {
                    if (this.domNodeNameEquals(node2, string2, string3)) {
                        return node2;
                    }
                    node2 = node2.getNextSibling();
                }
                return null;
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node getDomChild(int n, String string2, String string3) {
        return this.getDomChildAt(n, string2, string3, 0);
    }

    protected org.w3c.dom.Node insertDomChildAt(int n, String string2, String string3, int n2, String string4) {
        if (n == 0) {
            return this.appendDomChild(n, string2, string3, string4);
        }
        Element element = this.domNode.getOwnerDocument().createElementNS(string2, string3);
        element.appendChild(this.domNode.getOwnerDocument().createTextNode(string4));
        return this.domNode.insertBefore(element, this.getDomChildAt(1, string2, string3, n2));
    }

    protected org.w3c.dom.Node insertDomElementAt(String string2, String string3, int n, Node node) {
        node.domNode = this.domNode.insertBefore(this.cloneDomElementAs(string2, string3, node), this.getDomChildAt(1, string2, string3, n));
        return node.domNode;
    }

    protected org.w3c.dom.Node replaceDomChildAt(int n, String string2, String string3, int n2, String string4) {
        if (n == 0) {
            return this.appendDomChild(n, string2, string3, string4);
        }
        Element element = this.domNode.getOwnerDocument().createElementNS(string2, string3);
        element.appendChild(this.domNode.getOwnerDocument().createTextNode(string4));
        return this.domNode.replaceChild(element, this.getDomChildAt(1, string2, string3, n2));
    }

    protected org.w3c.dom.Node replaceDomElementAt(String string2, String string3, int n, Node node) {
        node.domNode = this.domNode.replaceChild(this.cloneDomElementAs(string2, string3, node), this.getDomChildAt(1, string2, string3, n));
        return node.domNode;
    }

    protected org.w3c.dom.Node setDomChildAt(int n, String string2, String string3, String string4, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                Attr attr = ((Element)this.domNode).getAttributeNodeNS(string2, string3);
                ((Element)this.domNode).setAttributeNS(string2, string3, string4);
                return attr;
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n4 = nodeList.getLength();
                for (int i = 0; i < n4; ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    if (!this.domNodeNameEquals(node, string2, string3) || n3++ != n2) continue;
                    return node.replaceChild(node.getOwnerDocument().createTextNode(string4), node.getFirstChild());
                }
                throw new XmlException("Index out of range");
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node setDomChild(int n, String string2, String string3, String string4) {
        if (n == 0 || this.getDomChildCount(n, string2, string3) > 0) {
            return this.setDomChildAt(n, string2, string3, string4, 0);
        }
        this.appendDomChild(n, string2, string3, string4);
        return null;
    }

    protected org.w3c.dom.Node removeDomChildAt(int n, String string2, String string3, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                return this.domNode.getAttributes().removeNamedItemNS(string2, string3);
            }
            case 1: {
                NodeList nodeList = this.domNode.getChildNodes();
                int n4 = nodeList.getLength();
                for (int i = 0; i < n4; ++i) {
                    org.w3c.dom.Node node = nodeList.item(i);
                    if (!this.domNodeNameEquals(node, string2, string3) || n3++ != n2) continue;
                    return this.domNode.removeChild(node);
                }
                throw new XmlException("Index out of range");
            }
        }
        throw new XmlException("Unknown type");
    }

    protected org.w3c.dom.Node appendDomElement(String string2, String string3, Node node) {
        node.domNode = this.domNode.appendChild(this.cloneDomElementAs(string2, string3, node));
        return node.domNode;
    }

    protected Element cloneDomElementAs(String string2, String string3, Node node) {
        Element element = this.domNode.getOwnerDocument().createElementNS(string2, string3);
        Element element2 = (Element)node.domNode;
        org.w3c.dom.Document document = element.getOwnerDocument();
        NodeList nodeList = element2.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            element.appendChild(document.importNode(nodeList.item(i), true));
        }
        NamedNodeMap namedNodeMap = element2.getAttributes();
        NamedNodeMap namedNodeMap2 = element.getAttributes();
        n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            namedNodeMap2.setNamedItemNS(document.importNode(namedNodeMap.item(i), false));
        }
        return element;
    }

    protected void cloneInto(Element element) {
        Object object;
        while (this.domNode.getFirstChild() != null) {
            object = element.getOwnerDocument().importNode(this.domNode.getFirstChild(), true);
            element.appendChild((org.w3c.dom.Node)object);
            this.domNode.removeChild(this.domNode.getFirstChild());
        }
        object = ((Element)this.domNode).getAttributes();
        NamedNodeMap namedNodeMap = element.getAttributes();
        while (object.getLength() > 0) {
            org.w3c.dom.Node node = object.item(0);
            namedNodeMap.setNamedItem(element.getOwnerDocument().importNode(node, true));
            object.removeNamedItem(node.getNodeName());
        }
        this.domNode = element;
    }

    protected static String lookupPrefix(org.w3c.dom.Node node, String string2) {
        if (node == null || string2 == null || string2.equals("")) {
            return null;
        }
        if (node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    String string3 = attr.getName();
                    String string4 = attr.getValue();
                    if (string4 == null || !string4.equals(string2) || !string3.startsWith("xmlns:")) continue;
                    return string3.substring(6);
                }
            }
            return Node.lookupPrefix(node.getParentNode(), string2);
        }
        if (node.getNodeType() == 2) {
            return Node.lookupPrefix(((Attr)node).getOwnerElement(), string2);
        }
        return null;
    }

    protected static String lookupDefaultNamespace(org.w3c.dom.Node node) {
        Attr attr;
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 1 && (attr = ((Element)node).getAttributeNode("xmlns")) != null) {
            return attr.getValue();
        }
        return Node.lookupDefaultNamespace(node.getParentNode());
    }

    protected static void internalAdjustPrefix(org.w3c.dom.Node node, boolean bl) {
        Element element;
        if (node == null) {
            return;
        }
        if (bl) {
            String string2 = Node.lookupPrefix(node, node.getNamespaceURI());
            if (string2 != null) {
                node.setPrefix(string2);
            }
        } else if (node.getNodeType() == 1 && Node.lookupDefaultNamespace(element = (Element)node) != null) {
            element.setAttribute("xmlns", "");
        }
    }

    public abstract void adjustPrefix();
}

