/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects;

import com.jme.intersection.BoundingPickResults;
import com.jme.intersection.PickResults;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jmex.effects.FlareQuad;
import java.io.IOException;
import java.util.ArrayList;

public class LensFlare
extends Node {
    private static final long serialVersionUID = 1L;
    private Vector2f midPoint;
    private Vector3f flarePoint;
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private float intensity = 1.0f;
    private float maxNotOccludedOffset;
    private float minNotOccludedOffset;
    private Ray secondRay = new Ray();
    private Vector2f secondScreenPos = new Vector2f();
    private Vector3f flaresWorldAxis = new Vector3f();
    private Node rootNode;
    private Ray pickRay = new Ray();
    private PickResults pickResults = new BoundingPickResults(){

        public void addPick(Ray ray, GeomBatch geomBatch) {
            LensFlare.this.pickBoundsGeoms.add(geomBatch);
        }
    };
    private Vector2f screenPos = new Vector2f();
    private ArrayList<Integer> pickTriangles = new ArrayList();
    private ArrayList<GeomBatch> pickBoundsGeoms = new ArrayList();
    private ArrayList<GeomBatch> occludingTriMeshes = new ArrayList();

    public LensFlare() {
    }

    public LensFlare(String string) {
        super(string);
        this.init();
    }

    private void init() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.midPoint = new Vector2f((float)(displaySystem.getWidth() >> 1), (float)(displaySystem.getHeight() >> 1));
        for (int i = 0; i < 17; ++i) {
            this.setRenderState(Renderer.defaultStateList[i]);
        }
        AlphaState alphaState = displaySystem.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        this.setRenderState((RenderState)alphaState);
        this.setRenderQueueMode(4);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
    }

    public Vector2f getMidPoint() {
        return this.midPoint;
    }

    public void setMidPoint(Vector2f vector2f) {
        this.midPoint = vector2f;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float f) {
        this.intensity = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
    }

    public void onDraw(Renderer renderer) {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.midPoint.set((float)(renderer.getWidth() >> 1), (float)(renderer.getHeight() >> 1));
        this.flarePoint = displaySystem.getScreenCoordinates(this.worldTranslation, this.flarePoint).subtractLocal(this.midPoint.x, this.midPoint.y, 0.0f);
        if (this.flarePoint.z >= 1.0f) {
            this.setCullMode(2);
            return;
        }
        this.setCullMode(1);
        super.onDraw(renderer);
    }

    public void draw(Renderer renderer) {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        float f = this.getIntensity();
        if (displaySystem.getWidth() != renderer.getWidth() || displaySystem.getHeight() != renderer.getHeight()) {
            float f2 = (float)displaySystem.getWidth() / (float)renderer.getWidth();
            this.flarePoint.x *= f2;
            float f3 = (float)displaySystem.getHeight() / (float)renderer.getHeight();
            this.flarePoint.y *= f3;
            this.midPoint.x *= f2;
            this.midPoint.y *= f3;
            this.scale.x = f;
            this.scale.y = f * f3 / f2;
            this.scale.z = f;
        } else {
            this.scale.x = f;
            this.scale.y = f;
            this.scale.z = f;
        }
        if (this.rootNode != null) {
            this.pickResults.clear();
            Vector3f vector3f = this.pickRay.getOrigin();
            this.screenPos.set(this.flarePoint.x + this.midPoint.x, this.flarePoint.y + this.midPoint.y);
            displaySystem.getWorldCoordinates(this.screenPos, 0.0f, vector3f);
            this.pickRay.getDirection().set(this.getWorldTranslation()).subtractLocal(vector3f).normalizeLocal();
            this.pickBoundsGeoms.clear();
            this.rootNode.findPick(this.pickRay, this.pickResults);
            this.setIntensity(1.0f);
            this.occludingTriMeshes.clear();
            for (int i = this.pickBoundsGeoms.size() - 1; i >= 0; --i) {
                GeomBatch geomBatch = this.pickBoundsGeoms.get(i);
                if (geomBatch.getParentGeom().getWorldTranslation().equals((Object)this.getWorldTranslation()) || (geomBatch.getParentGeom().getParent().getType() & 0x10) != 0 || geomBatch.getRenderQueueMode() == 3) continue;
                if ((geomBatch.getType() & 4) != 0) {
                    this.occludingTriMeshes.add(geomBatch);
                    continue;
                }
                this.setIntensity(0.0f);
                break;
            }
            if (this.occludingTriMeshes.size() > 0 && this.getIntensity() > 0.0f) {
                this.checkRealOcclusion();
            }
        }
        int n = this.getQuantity();
        while (--n >= 0) {
            FlareQuad flareQuad = (FlareQuad)this.getChild(n);
            flareQuad.setLocalScale(this.scale);
            flareQuad.updatePosition(this.flarePoint, this.midPoint);
        }
        super.draw(renderer);
    }

    private void checkRealOcclusion() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.secondRay.direction.set(this.pickRay.direction);
        float f = this.flarePoint.length();
        this.secondScreenPos.x = this.screenPos.x + this.flarePoint.x / f;
        this.secondScreenPos.y = this.screenPos.y + this.flarePoint.y / f;
        displaySystem.getWorldCoordinates(this.secondScreenPos, 0.0f, this.flaresWorldAxis);
        this.flaresWorldAxis.subtractLocal(this.pickRay.origin).normalizeLocal().multLocal(0.01f);
        this.secondRay.origin.set(this.flaresWorldAxis).multLocal(-25.0f).addLocal(this.pickRay.origin);
        this.maxNotOccludedOffset = -25.0f;
        this.minNotOccludedOffset = -25.0f;
        while (this.isRayCatched(this.secondRay) && this.maxNotOccludedOffset < 25.0f) {
            this.secondRay.origin.addLocal(this.flaresWorldAxis);
            this.minNotOccludedOffset += 1.0f;
            this.maxNotOccludedOffset += 1.0f;
        }
        if (this.maxNotOccludedOffset < 25.0f) {
            do {
                this.secondRay.origin.addLocal(this.flaresWorldAxis);
                this.maxNotOccludedOffset += 1.0f;
            } while (!this.isRayCatched(this.secondRay) && this.maxNotOccludedOffset < 25.0f);
        }
        this.setIntensity(Math.abs(this.maxNotOccludedOffset - this.minNotOccludedOffset) / 12.0f);
    }

    private boolean isRayCatched(Ray ray) {
        this.pickTriangles.clear();
        for (int i = this.occludingTriMeshes.size() - 1; i >= 0; --i) {
            TriangleBatch triangleBatch = (TriangleBatch)this.occludingTriMeshes.get(i);
            triangleBatch.findTrianglePick(ray, this.pickTriangles);
            if (this.pickTriangles.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public int attachChild(Spatial spatial) {
        if (!(spatial instanceof FlareQuad)) {
            throw new JmeException("Only children of type FlareQuad may be attached to LensFlare.");
        }
        return super.attachChild(spatial);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node node) {
        Node node2 = this.rootNode;
        if (node2 != node) {
            this.rootNode = node;
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.midPoint, "midPoint", (Savable)new Vector2f());
        outputCapsule.write((Savable)this.flarePoint, "flarePoint", (Savable)Vector3f.ZERO);
        outputCapsule.write((Savable)this.scale, "scale", (Savable)Vector3f.UNIT_XYZ);
        outputCapsule.write(this.intensity, "intensity", 1.0f);
        outputCapsule.write((Savable)this.rootNode, "rootNode", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule((Savable)this);
        this.midPoint = (Vector2f)inputCapsule.readSavable("midPoint", (Savable)new Vector2f());
        this.flarePoint = (Vector3f)inputCapsule.readSavable("flarePoint", (Savable)new Vector3f(Vector3f.ZERO));
        this.scale = (Vector3f)inputCapsule.readSavable("scale", (Savable)new Vector3f(Vector3f.UNIT_XYZ));
        this.intensity = inputCapsule.readFloat("intensity", 1.0f);
        this.rootNode = (Node)inputCapsule.readSavable("rootNode", null);
    }
}

