/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.water;

import com.jme.image.Texture;
import com.jme.math.Plane;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.renderer.pass.Pass;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.ClipState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;

public class WaterRenderPass
extends Pass {
    private static final long serialVersionUID = 1L;
    private Camera cam;
    private float tpf;
    private float reflectionThrottle = 0.02f;
    private float refractionThrottle = 0.02f;
    private float reflectionTime = 0.0f;
    private float refractionTime = 0.0f;
    private boolean useFadeToFogColor = false;
    private TextureRenderer tRenderer;
    private Texture textureReflect;
    private Texture textureRefract;
    private Texture textureDepth;
    private ArrayList<Spatial> renderList;
    private ArrayList<Texture> texArray = new ArrayList();
    private Node skyBox;
    private GLSLShaderObjectsState waterShader;
    private CullState cullBackFace;
    private TextureState textureState;
    private AlphaState as1;
    private ClipState clipState;
    private Plane waterPlane;
    private Vector3f tangent;
    private Vector3f binormal;
    private Vector3f calcVect = new Vector3f();
    private float clipBias;
    private ColorRGBA waterColorStart;
    private ColorRGBA waterColorEnd;
    private float heightFalloffStart;
    private float heightFalloffSpeed;
    private float waterMaxAmplitude;
    private float speedReflection;
    private float speedRefraction;
    private boolean aboveWater;
    private float normalTranslation = 0.0f;
    private float refractionTranslation = 0.0f;
    private boolean supported = true;
    private boolean useProjectedShader = false;
    private boolean useRefraction = false;
    private boolean useReflection = true;
    private int renderScale;
    public static String simpleShaderStr = "com/jmex/effects/water/data/flatwatershader";
    public static String simpleShaderRefractionStr = "com/jmex/effects/water/data/flatwatershader_refraction";
    public static String projectedShaderStr = "com/jmex/effects/water/data/projectedwatershader";
    public static String projectedShaderRefractionStr = "com/jmex/effects/water/data/projectedwatershader_refraction";
    private String currentShaderStr;
    public static String normalMapTexture = "com/jmex/effects/water/data/normalmap3.dds";
    public static String dudvMapTexture = "com/jmex/effects/water/data/dudvmap.png";
    public static String foamMapTexture = "com/jmex/effects/water/data/oceanfoam.png";
    public static String fallbackMapTexture = "com/jmex/effects/water/data/water2.png";
    private Vector3f tmpLocation = new Vector3f();
    private Vector3f camReflectPos = new Vector3f();
    private Vector3f camReflectDir = new Vector3f();
    private Vector3f camReflectUp = new Vector3f();
    private Vector3f camReflectLeft = new Vector3f();
    private Vector3f camLocation = new Vector3f();

    public void resetParameters() {
        this.waterPlane = new Plane(new Vector3f(0.0f, 1.0f, 0.0f), 0.0f);
        this.tangent = new Vector3f(1.0f, 0.0f, 0.0f);
        this.binormal = new Vector3f(0.0f, 0.0f, 1.0f);
        this.waterMaxAmplitude = 1.0f;
        this.clipBias = 0.0f;
        this.waterColorStart = new ColorRGBA(0.0f, 0.0f, 0.1f, 1.0f);
        this.waterColorEnd = new ColorRGBA(0.0f, 0.3f, 0.1f, 1.0f);
        this.heightFalloffStart = 300.0f;
        this.heightFalloffSpeed = 500.0f;
        this.speedReflection = 0.1f;
        this.speedRefraction = -0.05f;
    }

    public void cleanup() {
        if (this.isSupported()) {
            this.tRenderer.cleanup();
        }
    }

    public boolean isSupported() {
        return this.supported;
    }

    public WaterRenderPass(Camera camera, int n, boolean bl, boolean bl2) {
        this.cam = camera;
        this.useProjectedShader = bl;
        this.useRefraction = bl2;
        this.renderScale = n;
        this.resetParameters();
        this.initialize();
    }

    private void initialize() {
        Texture texture;
        if (this.useRefraction && this.useProjectedShader && TextureState.getNumberOfFragmentUnits() < 6 || this.useRefraction && TextureState.getNumberOfFragmentUnits() < 5) {
            this.useRefraction = false;
            LoggingSystem.getLogger().log(Level.INFO, "Not enough textureunits, falling back to non refraction water");
        }
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.waterShader = displaySystem.getRenderer().createGLSLShaderObjectsState();
        if (!this.waterShader.isSupported()) {
            this.supported = false;
        }
        this.cullBackFace = displaySystem.getRenderer().createCullState();
        this.cullBackFace.setEnabled(true);
        this.cullBackFace.setCullMode(0);
        this.clipState = displaySystem.getRenderer().createClipState();
        if (this.isSupported()) {
            this.tRenderer = displaySystem.createTextureRenderer(displaySystem.getWidth() / this.renderScale, displaySystem.getHeight() / this.renderScale, 2);
            if (this.tRenderer.isSupported()) {
                this.tRenderer.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
                this.tRenderer.getCamera().setFrustum(this.cam.getFrustumNear(), this.cam.getFrustumFar(), this.cam.getFrustumLeft(), this.cam.getFrustumRight(), this.cam.getFrustumTop(), this.cam.getFrustumBottom());
                this.textureReflect = new Texture();
                this.textureReflect.setWrap(4);
                this.textureReflect.setFilter(1);
                this.textureReflect.setScale(new Vector3f(-1.0f, 1.0f, 1.0f));
                this.textureReflect.setTranslation(new Vector3f(1.0f, 0.0f, 0.0f));
                this.tRenderer.setupTexture(this.textureReflect);
                this.textureRefract = new Texture();
                this.textureRefract.setWrap(4);
                this.textureRefract.setFilter(1);
                this.tRenderer.setupTexture(this.textureRefract);
                this.textureDepth = new Texture();
                this.textureDepth.setWrap(4);
                this.textureDepth.setFilter(1);
                this.textureDepth.setRTTSource(2);
                this.tRenderer.setupTexture(this.textureDepth);
                this.textureState = displaySystem.getRenderer().createTextureState();
                this.textureState.setEnabled(true);
                texture = TextureManager.loadTexture((URL)WaterRenderPass.class.getClassLoader().getResource(normalMapTexture), (int)6, (int)1);
                this.textureState.setTexture(texture, 0);
                texture.setWrap(3);
                this.textureState.setTexture(this.textureReflect, 1);
                texture = TextureManager.loadTexture((URL)WaterRenderPass.class.getClassLoader().getResource(dudvMapTexture), (int)6, (int)1, (int)-2, (float)1.0f, (boolean)false);
                this.textureState.setTexture(texture, 2);
                texture.setWrap(3);
                if (this.useRefraction) {
                    this.textureState.setTexture(this.textureRefract, 3);
                    this.textureState.setTexture(this.textureDepth, 4);
                }
                if (this.useProjectedShader) {
                    texture = TextureManager.loadTexture((URL)WaterRenderPass.class.getClassLoader().getResource(foamMapTexture), (int)6, (int)1);
                    if (this.useRefraction) {
                        this.textureState.setTexture(texture, 5);
                    } else {
                        this.textureState.setTexture(texture, 3);
                    }
                    texture.setWrap(3);
                }
                this.clipState.setEnabled(true);
                this.clipState.setEnableClipPlane(0, true);
                this.reloadShader();
            } else {
                this.supported = false;
            }
        }
        if (!this.isSupported()) {
            this.textureState = displaySystem.getRenderer().createTextureState();
            this.textureState.setEnabled(true);
            texture = TextureManager.loadTexture((URL)WaterRenderPass.class.getClassLoader().getResource(fallbackMapTexture), (int)6, (int)1);
            this.textureState.setTexture(texture, 0);
            texture.setWrap(3);
            this.as1 = displaySystem.getRenderer().createAlphaState();
            this.as1.setBlendEnabled(true);
            this.as1.setSrcFunction(4);
            this.as1.setDstFunction(5);
            this.as1.setEnabled(true);
        }
    }

    protected void doUpdate(float f) {
        super.doUpdate(f);
        this.tpf = f;
    }

    public void doRender(Renderer renderer) {
        this.normalTranslation += this.speedReflection * this.tpf;
        this.refractionTranslation += this.speedRefraction * this.tpf;
        float f = this.waterPlane.pseudoDistance(this.cam.getLocation());
        boolean bl = this.aboveWater = f >= 0.0f;
        if (this.isSupported()) {
            this.waterShader.clearUniforms();
            this.waterShader.setUniform("tangent", this.tangent.x, this.tangent.y, this.tangent.z);
            this.waterShader.setUniform("binormal", this.binormal.x, this.binormal.y, this.binormal.z);
            this.waterShader.setUniform("useFadeToFogColor", this.useFadeToFogColor ? 1 : 0);
            this.waterShader.setUniform("normalMap", 0);
            this.waterShader.setUniform("reflection", 1);
            this.waterShader.setUniform("dudvMap", 2);
            if (this.useRefraction) {
                this.waterShader.setUniform("refraction", 3);
                this.waterShader.setUniform("depthMap", 4);
            }
            this.waterShader.setUniform("waterColor", this.waterColorStart.r, this.waterColorStart.g, this.waterColorStart.b, this.waterColorStart.a);
            this.waterShader.setUniform("waterColorEnd", this.waterColorEnd.r, this.waterColorEnd.g, this.waterColorEnd.b, this.waterColorEnd.a);
            this.waterShader.setUniform("normalTranslation", this.normalTranslation);
            this.waterShader.setUniform("refractionTranslation", this.refractionTranslation);
            this.waterShader.setUniform("abovewater", this.aboveWater ? 1 : 0);
            if (this.useProjectedShader) {
                this.waterShader.setUniform("cameraPos", this.cam.getLocation().x, this.cam.getLocation().y, this.cam.getLocation().z);
                if (this.useRefraction) {
                    this.waterShader.setUniform("foamMap", 5);
                } else {
                    this.waterShader.setUniform("foamMap", 3);
                }
                this.waterShader.setUniform("waterHeight", this.waterPlane.getConstant());
                this.waterShader.setUniform("amplitude", this.waterMaxAmplitude);
                this.waterShader.setUniform("heightFalloffStart", this.heightFalloffStart);
                this.waterShader.setUniform("heightFalloffSpeed", this.heightFalloffSpeed);
            }
            this.waterShader.apply();
            float f2 = this.clipBias + this.waterMaxAmplitude - this.waterPlane.getConstant();
            Vector3f vector3f = this.waterPlane.getNormal();
            this.clipState.setClipPlaneEquation(0, (double)vector3f.x, (double)vector3f.y, (double)vector3f.z, (double)f2);
            this.clipState.setEnabled(true);
            if (this.useReflection) {
                this.renderReflection();
            }
            this.clipState.setClipPlaneEquation(0, (double)(-vector3f.x), (double)(-vector3f.y), (double)(-vector3f.z), (double)(-f2));
            if (this.useRefraction && this.aboveWater) {
                this.renderRefraction();
            }
            this.clipState.setEnabled(false);
        } else {
            this.textureState.getTexture().setTranslation(new Vector3f(0.0f, this.normalTranslation, 0.0f));
        }
    }

    public void reloadShader() {
        this.currentShaderStr = this.useProjectedShader ? (this.useRefraction ? projectedShaderRefractionStr : projectedShaderStr) : (this.useRefraction ? simpleShaderRefractionStr : simpleShaderStr);
        GLSLShaderObjectsState gLSLShaderObjectsState = DisplaySystem.getDisplaySystem().getRenderer().createGLSLShaderObjectsState();
        try {
            gLSLShaderObjectsState.load(WaterRenderPass.class.getClassLoader().getResource(this.currentShaderStr + ".vert"), WaterRenderPass.class.getClassLoader().getResource(this.currentShaderStr + ".frag"));
            gLSLShaderObjectsState.apply();
            Util.checkGLError();
        }
        catch (OpenGLException openGLException) {
            openGLException.printStackTrace();
            return;
        }
        this.waterShader.load(WaterRenderPass.class.getClassLoader().getResource(this.currentShaderStr + ".vert"), WaterRenderPass.class.getClassLoader().getResource(this.currentShaderStr + ".frag"));
        LoggingSystem.getLogger().log(Level.INFO, "Shader reloaded...");
    }

    public void setWaterEffectOnSpatial(Spatial spatial) {
        spatial.setRenderState((RenderState)this.cullBackFace);
        if (this.isSupported()) {
            spatial.setRenderQueueMode(1);
            spatial.setRenderState((RenderState)this.waterShader);
            spatial.setRenderState((RenderState)this.textureState);
        } else {
            spatial.setRenderQueueMode(3);
            spatial.setLightCombineMode(0);
            spatial.setRenderState((RenderState)this.textureState);
            spatial.setRenderState((RenderState)this.as1);
        }
        spatial.updateRenderState();
    }

    private void renderReflection() {
        this.reflectionTime += this.tpf;
        if (this.reflectionTime < this.reflectionThrottle) {
            return;
        }
        this.reflectionTime = 0.0f;
        if (this.aboveWater) {
            this.camLocation.set(this.cam.getLocation());
            float f = this.waterPlane.pseudoDistance(this.camLocation);
            this.calcVect.set(this.waterPlane.getNormal()).multLocal(f * 2.0f);
            this.camReflectPos.set(this.camLocation.subtractLocal(this.calcVect));
            this.camLocation.set(this.cam.getLocation()).addLocal(this.cam.getDirection());
            f = this.waterPlane.pseudoDistance(this.camLocation);
            this.calcVect.set(this.waterPlane.getNormal()).multLocal(f * 2.0f);
            this.camReflectDir.set(this.camLocation.subtractLocal(this.calcVect)).subtractLocal(this.camReflectPos).normalizeLocal();
            this.camLocation.set(this.cam.getLocation()).addLocal(this.cam.getUp());
            f = this.waterPlane.pseudoDistance(this.camLocation);
            this.calcVect.set(this.waterPlane.getNormal()).multLocal(f * 2.0f);
            this.camReflectUp.set(this.camLocation.subtractLocal(this.calcVect)).subtractLocal(this.camReflectPos).normalizeLocal();
            this.camReflectLeft.set(this.camReflectDir).crossLocal(this.camReflectUp).normalizeLocal();
            this.tRenderer.getCamera().getLocation().set(this.camReflectPos);
            this.tRenderer.getCamera().getDirection().set(this.camReflectDir);
            this.tRenderer.getCamera().getUp().set(this.camReflectUp);
            this.tRenderer.getCamera().getLeft().set(this.camReflectLeft);
        } else {
            this.tRenderer.getCamera().getLocation().set(this.cam.getLocation());
            this.tRenderer.getCamera().getDirection().set(this.cam.getDirection());
            this.tRenderer.getCamera().getUp().set(this.cam.getUp());
            this.tRenderer.getCamera().getLeft().set(this.cam.getLeft());
        }
        if (this.skyBox != null) {
            this.tmpLocation.set(this.skyBox.getLocalTranslation());
            this.skyBox.getLocalTranslation().set(this.tRenderer.getCamera().getLocation());
            this.skyBox.updateWorldData(0.0f);
        }
        this.texArray.clear();
        this.texArray.add(this.textureReflect);
        this.tRenderer.render(this.renderList, this.texArray);
        if (this.skyBox != null) {
            this.skyBox.getLocalTranslation().set(this.tmpLocation);
            this.skyBox.updateWorldData(0.0f);
        }
    }

    private void renderRefraction() {
        this.refractionTime += this.tpf;
        if (this.refractionTime < this.refractionThrottle) {
            return;
        }
        this.refractionTime = 0.0f;
        this.tRenderer.getCamera().getLocation().set(this.cam.getLocation());
        this.tRenderer.getCamera().getDirection().set(this.cam.getDirection());
        this.tRenderer.getCamera().getUp().set(this.cam.getUp());
        this.tRenderer.getCamera().getLeft().set(this.cam.getLeft());
        int n = 0;
        if (this.skyBox != null) {
            n = this.skyBox.getCullMode();
            this.skyBox.setCullMode(2);
        }
        this.texArray.clear();
        this.texArray.add(this.textureRefract);
        this.texArray.add(this.textureDepth);
        this.tRenderer.render(this.renderList, this.texArray);
        if (this.skyBox != null) {
            this.skyBox.setCullMode(n);
        }
    }

    public void removeReflectedScene(Spatial spatial) {
        if (this.renderList != null) {
            System.out.println(this.renderList.remove(spatial));
        }
    }

    public void clearReflectedScene() {
        if (this.renderList != null) {
            this.renderList.clear();
        }
    }

    public void setReflectedScene(Spatial spatial) {
        if (this.renderList == null) {
            this.renderList = new ArrayList();
        }
        this.renderList.clear();
        this.renderList.add(spatial);
        spatial.setRenderState((RenderState)this.clipState);
        spatial.updateRenderState();
    }

    public void addReflectedScene(Spatial spatial) {
        if (this.renderList == null) {
            this.renderList = new ArrayList();
        }
        if (!this.renderList.contains(spatial)) {
            this.renderList.add(spatial);
            spatial.setRenderState((RenderState)this.clipState);
            spatial.updateRenderState();
        }
    }

    public void setSkybox(Node node) {
        ClipState clipState = DisplaySystem.getDisplaySystem().getRenderer().createClipState();
        clipState.setEnabled(false);
        node.setRenderState((RenderState)clipState);
        node.updateRenderState();
        this.skyBox = node;
    }

    public Camera getCam() {
        return this.cam;
    }

    public void setCam(Camera camera) {
        this.cam = camera;
    }

    public ColorRGBA getWaterColorStart() {
        return this.waterColorStart;
    }

    public void setWaterColorStart(ColorRGBA colorRGBA) {
        this.waterColorStart = colorRGBA;
    }

    public ColorRGBA getWaterColorEnd() {
        return this.waterColorEnd;
    }

    public void setWaterColorEnd(ColorRGBA colorRGBA) {
        this.waterColorEnd = colorRGBA;
    }

    public float getHeightFalloffStart() {
        return this.heightFalloffStart;
    }

    public void setHeightFalloffStart(float f) {
        this.heightFalloffStart = f;
    }

    public float getHeightFalloffSpeed() {
        return this.heightFalloffSpeed;
    }

    public void setHeightFalloffSpeed(float f) {
        this.heightFalloffSpeed = f;
    }

    public float getWaterHeight() {
        return this.waterPlane.getConstant();
    }

    public void setWaterHeight(float f) {
        this.waterPlane.setConstant(f);
    }

    public Vector3f getNormal() {
        return this.waterPlane.getNormal();
    }

    public void setNormal(Vector3f vector3f) {
        this.waterPlane.setNormal(vector3f);
    }

    public float getSpeedReflection() {
        return this.speedReflection;
    }

    public void setSpeedReflection(float f) {
        this.speedReflection = f;
    }

    public float getSpeedRefraction() {
        return this.speedRefraction;
    }

    public void setSpeedRefraction(float f) {
        this.speedRefraction = f;
    }

    public float getWaterMaxAmplitude() {
        return this.waterMaxAmplitude;
    }

    public void setWaterMaxAmplitude(float f) {
        this.waterMaxAmplitude = f;
    }

    public float getClipBias() {
        return this.clipBias;
    }

    public void setClipBias(float f) {
        this.clipBias = f;
    }

    public Plane getWaterPlane() {
        return this.waterPlane;
    }

    public void setWaterPlane(Plane plane) {
        this.waterPlane = plane;
    }

    public Vector3f getTangent() {
        return this.tangent;
    }

    public void setTangent(Vector3f vector3f) {
        this.tangent = vector3f;
    }

    public Vector3f getBinormal() {
        return this.binormal;
    }

    public void setBinormal(Vector3f vector3f) {
        this.binormal = vector3f;
    }

    public Texture getTextureReflect() {
        return this.textureReflect;
    }

    public Texture getTextureRefract() {
        return this.textureRefract;
    }

    public Texture getTextureDepth() {
        return this.textureDepth;
    }

    public void useFadeToFogColor(boolean bl) {
        this.useFadeToFogColor = bl;
    }

    public boolean isUseFadeToFogColor() {
        return this.useFadeToFogColor;
    }

    public boolean isUseReflection() {
        return this.useReflection;
    }

    public void setUseReflection(boolean bl) {
        if (bl == this.useReflection) {
            return;
        }
        this.useReflection = bl;
        this.reloadShader();
    }

    public boolean isUseRefraction() {
        return this.useRefraction;
    }

    public void setUseRefraction(boolean bl) {
        if (bl == this.useRefraction) {
            return;
        }
        this.useRefraction = bl;
        this.reloadShader();
    }

    public int getRenderScale() {
        return this.renderScale;
    }

    public void setRenderScale(int n) {
        this.renderScale = n;
    }

    public boolean isUseProjectedShader() {
        return this.useProjectedShader;
    }

    public void setUseProjectedShader(boolean bl) {
        if (bl == this.useProjectedShader) {
            return;
        }
        this.useProjectedShader = bl;
        this.reloadShader();
    }

    public float getReflectionThrottle() {
        return this.reflectionThrottle;
    }

    public void setReflectionThrottle(float f) {
        this.reflectionThrottle = f;
    }

    public float getRefractionThrottle() {
        return this.refractionThrottle;
    }

    public void setRefractionThrottle(float f) {
        this.refractionThrottle = f;
    }

    public TextureState getTextureState() {
        return this.textureState;
    }

    public void setTextureState(TextureState textureState) {
        this.textureState = textureState;
    }
}

