/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.animation.Bone;
import com.jme.animation.BoneAnimation;
import com.jme.scene.Controller;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimationController
extends Controller
implements Savable {
    private static final long serialVersionUID = 1L;
    private ArrayList<BoneAnimation> animationSets;
    private Bone skeleton;
    private BoneAnimation activeAnimation;

    public void addAnimation(BoneAnimation boneAnimation) {
        if (boneAnimation == null) {
            return;
        }
        if (this.animationSets == null) {
            this.animationSets = new ArrayList();
        }
        this.animationSets.add(boneAnimation);
        if (this.skeleton != null) {
            boneAnimation.assignSkeleton(this.skeleton);
        }
    }

    public void removeAnimation(BoneAnimation boneAnimation) {
        if (this.animationSets != null) {
            this.animationSets.remove(boneAnimation);
            if (this.animationSets.size() == 0) {
                this.activeAnimation = null;
            } else if (boneAnimation == this.activeAnimation) {
                this.activeAnimation = this.animationSets.get(0);
            }
        }
    }

    public void removeAnimation(int n) {
        if (n < 0 || n >= this.animationSets.size()) {
            return;
        }
        if (this.animationSets != null) {
            BoneAnimation boneAnimation = this.animationSets.get(n);
            this.animationSets.remove(n);
            if (this.animationSets.size() == 0) {
                this.activeAnimation = null;
            } else if (boneAnimation == this.activeAnimation) {
                this.activeAnimation = this.animationSets.get(0);
            }
        }
    }

    public BoneAnimation getActiveAnimation() {
        return this.activeAnimation;
    }

    public void setCurrentFrame(int n) {
        if (this.activeAnimation != null) {
            this.activeAnimation.setCurrentFrame(n);
        }
    }

    public void clearAnimations() {
        if (this.animationSets != null) {
            this.animationSets.clear();
        }
    }

    public BoneAnimation getAnimation(int n) {
        if (this.animationSets != null) {
            return this.animationSets.get(n);
        }
        return null;
    }

    public ArrayList<BoneAnimation> getAnimations() {
        return this.animationSets;
    }

    public void clearActiveAnimation() {
        this.activeAnimation = null;
    }

    public void setActiveAnimation(String string) {
        if (this.animationSets != null) {
            for (int i = 0; i < this.animationSets.size(); ++i) {
                if (!this.animationSets.get(i).getName().equals(string)) continue;
                this.activeAnimation = this.animationSets.get(i);
                return;
            }
        }
        this.clearActiveAnimation();
    }

    public void setActiveAnimation(BoneAnimation boneAnimation) {
        if (this.animationSets != null) {
            for (int i = 0; i < this.animationSets.size(); ++i) {
                if (this.animationSets.get(i) != boneAnimation) continue;
                this.activeAnimation = this.animationSets.get(i);
                return;
            }
        }
        this.clearActiveAnimation();
    }

    public void setActiveAnimation(int n) {
        if (this.animationSets != null) {
            for (int i = 0; i < this.animationSets.size(); ++i) {
                if (i != n) continue;
                this.activeAnimation = this.animationSets.get(i);
                return;
            }
        }
        this.clearActiveAnimation();
    }

    public void setSkeleton(Bone bone) {
        this.skeleton = bone;
        if (this.animationSets != null) {
            for (int i = 0; i < this.animationSets.size(); ++i) {
                this.animationSets.get(i).assignSkeleton(this.skeleton);
            }
        }
    }

    @Override
    public void update(float f) {
        if (this.activeAnimation != null) {
            this.activeAnimation.update(f, this.getRepeatType(), this.getSpeed());
        }
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.animationSets, "animationSets", null);
        outputCapsule.write(this.skeleton, "skeleton", null);
        outputCapsule.write(this.activeAnimation, "activeAnimation", null);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.animationSets = inputCapsule.readSavableArrayList("animationSets", null);
        this.skeleton = (Bone)inputCapsule.readSavable("skeleton", null);
        this.activeAnimation = (BoneAnimation)inputCapsule.readSavable("activeAnimation", null);
    }
}

