/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.animation.AnimationController;
import com.jme.animation.BoneChangeEvent;
import com.jme.animation.BoneChangeListener;
import com.jme.animation.BoneInfluence;
import com.jme.math.Matrix3f;
import com.jme.math.Matrix4f;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.util.ArrayList;

public class Bone
extends Node
implements Savable {
    private static final long serialVersionUID = 1L;
    protected Matrix4f bindMatrix = new Matrix4f();
    protected AnimationController animationController;
    private static boolean optimizeTransform = false;
    protected final Vector3f workVectA = new Vector3f();
    protected final Matrix4f transform = new Matrix4f();
    protected transient Vector3f oldScale = new Vector3f();
    protected transient Vector3f oldTran = new Vector3f();
    protected transient Quaternion oldRot = new Quaternion();
    protected transient boolean boneChanged = false;
    protected transient boolean skinRoot = false;
    protected transient ArrayList<BoneChangeListener> changeListeners;

    public Bone() {
    }

    public Bone(String string) {
        super(string);
    }

    public Bone(String string, Matrix4f matrix4f) {
        super(string);
        this.bindMatrix = matrix4f;
    }

    public static void setOptimizeTransform(boolean bl) {
        optimizeTransform = bl;
    }

    public void update() {
        if (!optimizeTransform) {
            return;
        }
        this.transform.setRotationQuaternion(this.worldRotation);
        this.transform.setTranslation(this.worldTranslation);
        if (this.children != null) {
            for (Spatial spatial : this.children) {
                try {
                    ((Bone)spatial).update();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void applyBone(BoneInfluence boneInfluence, Vector3f vector3f, Vector3f vector3f2) {
        if (!optimizeTransform) {
            this.transform.loadIdentity();
            this.transform.setRotationQuaternion(this.worldRotation);
            this.transform.setTranslation(this.worldTranslation);
        }
        if (boneInfluence.vOffset != null) {
            this.workVectA.set(boneInfluence.vOffset);
            this.transform.rotateVect(this.workVectA);
            this.transform.translateVect(this.workVectA);
            this.workVectA.multLocal(boneInfluence.weight);
            vector3f.addLocal(this.workVectA);
        }
        if (boneInfluence.nOffset != null) {
            this.workVectA.set(boneInfluence.nOffset);
            this.transform.rotateVect(this.workVectA);
            this.workVectA.multLocal(boneInfluence.weight);
            vector3f2.addLocal(this.workVectA);
        }
    }

    public Matrix4f getBindMatrix() {
        return this.bindMatrix;
    }

    public void setBindMatrix(Matrix4f matrix4f) {
        this.bindMatrix = matrix4f;
    }

    public void addController(Controller controller) {
        super.addController(controller);
        if (controller instanceof AnimationController) {
            ((AnimationController)controller).setSkeleton(this);
            this.animationController = (AnimationController)controller;
        }
    }

    public void updateGeometricState(float f, boolean bl) {
        if (this.parent == null || !(this.parent instanceof Bone)) {
            this.resetChangeValues();
        }
        super.updateGeometricState(f, bl);
    }

    public void resetChangeValues() {
        this.boneChanged = false;
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            if (!(this.getChild(i) instanceof Bone)) continue;
            ((Bone)this.getChild(i)).resetChangeValues();
        }
    }

    public void updateWorldVectors() {
        if (this.parent instanceof Bone) {
            super.updateWorldVectors();
        } else {
            Node node = this.parent;
            this.parent = null;
            super.updateWorldVectors();
            this.parent = node;
        }
        if (this.skinRoot && (this.boneChanged || this.hasTransformChanged())) {
            this.fireBoneChange();
        }
    }

    public AnimationController getAnimationController() {
        return this.animationController;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.bindMatrix, "bindMatrix", new Matrix4f());
        outputCapsule.write(this.animationController, "animationController", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.bindMatrix = (Matrix4f)inputCapsule.readSavable("bindMatrix", new Matrix4f());
        this.animationController = (AnimationController)inputCapsule.readSavable("animationController", null);
    }

    public void revertToBind() {
        this.worldTranslation.set(this.bindMatrix.toTranslationVector());
        this.bindMatrix.toRotationQuat(this.worldRotation);
        this.worldRotation.normalize();
        if (this.children != null) {
            for (Spatial spatial : this.children) {
                if (!(spatial instanceof Bone)) continue;
                ((Bone)spatial).revertToBind();
            }
        }
    }

    public Bone getRootSkeleton() {
        if (this.parent instanceof Bone) {
            return ((Bone)this.parent).getRootSkeleton();
        }
        return this;
    }

    public void addBoneListener(BoneChangeListener boneChangeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(boneChangeListener);
        this.propogateBoneChangeToChildren(true);
        this.skinRoot = true;
    }

    public void removeBoneListener(BoneChangeListener boneChangeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(boneChangeListener);
        this.propogateBoneChangeToChildren(true);
        if (this.changeListeners.size() == 0) {
            this.skinRoot = false;
        }
    }

    protected int getListenerQuantity() {
        if (this.changeListeners == null) {
            return 0;
        }
        return this.changeListeners.size();
    }

    protected void fireBoneChange() {
        if (this.changeListeners == null) {
            return;
        }
        BoneChangeEvent boneChangeEvent = new BoneChangeEvent(this);
        int n = this.getListenerQuantity();
        while (--n >= 0) {
            this.changeListeners.get(n).boneChanged(boneChangeEvent);
        }
    }

    public boolean isSkinRoot() {
        return this.skinRoot;
    }

    public void setSkinRoot(boolean bl) {
        this.skinRoot = bl;
    }

    public void propogateBoneChangeToParent(boolean bl) {
        if (!this.boneChanged || bl) {
            this.boneChanged = true;
            if (this.parent != null && this.parent instanceof Bone) {
                ((Bone)this.parent).propogateBoneChangeToParent(false);
            }
        }
    }

    public void propogateBoneChangeToChildren(boolean bl) {
        if (!this.boneChanged || bl) {
            this.boneChanged = true;
            int n = this.getQuantity();
            for (int i = 0; i < n; ++i) {
                Spatial spatial = this.getChild(i);
                if (!(spatial instanceof Bone)) continue;
                ((Bone)spatial).propogateBoneChangeToChildren(false);
            }
        }
    }

    protected boolean hasTransformChanged() {
        boolean bl = false;
        if (!(this.oldRot.equals(this.getWorldRotation()) && this.oldTran.equals(this.getWorldTranslation()) && this.oldScale.equals(this.getWorldScale()))) {
            bl = true;
            this.oldRot.set(this.getWorldRotation());
            this.oldTran.set(this.getWorldTranslation());
            this.oldScale.set(this.getWorldScale());
        }
        return bl;
    }

    public void propogateBoneChange(boolean bl) {
        this.propogateBoneChangeToParent(bl);
        this.propogateBoneChangeToChildren(bl);
    }

    public void setLocalRotation(Matrix3f matrix3f) {
        super.setLocalRotation(matrix3f);
        this.propogateBoneChange(true);
    }

    public void setLocalRotation(Quaternion quaternion) {
        super.setLocalRotation(quaternion);
        this.propogateBoneChange(true);
    }

    public void setLocalTranslation(Vector3f vector3f) {
        super.setLocalTranslation(vector3f);
        this.propogateBoneChange(true);
    }

    public void setLocalScale(Vector3f vector3f) {
        super.setLocalScale(vector3f);
        this.propogateBoneChange(true);
    }

    public void setLocalScale(float f) {
        super.setLocalScale(f);
        this.propogateBoneChange(true);
    }
}

