/*
 * Decompiled with CFR 0.152.
 */
package com.jme.animation;

import com.jme.animation.Bone;
import com.jme.math.Matrix4f;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;

public class BoneTransform
implements Serializable,
Savable {
    private static final long serialVersionUID = -6037680427670917355L;
    private Quaternion[] rotations;
    private Vector3f[] translations;
    private Bone bone;
    private String boneId;
    private int oldFrame;

    public BoneTransform() {
    }

    public BoneTransform(Bone bone, int n) {
        this.bone = bone;
        this.rotations = new Quaternion[n];
        this.translations = new Vector3f[n];
    }

    public BoneTransform(Bone bone, Matrix4f[] matrix4fArray) {
        this.bone = bone;
        this.setTransforms(matrix4fArray);
    }

    public void setCurrentFrame(int n) {
        if (this.oldFrame == n) {
            return;
        }
        this.oldFrame = n;
        if (this.bone != null) {
            this.bone.getLocalRotation().set(this.rotations[n]);
            this.bone.getLocalTranslation().set(this.translations[n]);
            this.bone.propogateBoneChange(true);
        }
    }

    public void update(int n, int n2, int n3, float f) {
        if (this.bone == null) {
            return;
        }
        this.interpolateRotation(this.rotations[n], this.rotations[n2], n3, f, this.bone.getLocalRotation());
        this.interpolateTranslation(this.translations[n], this.translations[n2], n3, f, this.bone.getLocalTranslation());
        this.bone.propogateBoneChange(true);
    }

    public void setTransform(int n, Matrix4f matrix4f) {
        if (this.rotations[n] == null) {
            this.rotations[n] = new Quaternion();
        }
        matrix4f.toRotationQuat(this.rotations[n]);
        this.rotations[n].normalize();
        if (this.translations[n] == null) {
            this.translations[n] = new Vector3f();
        }
        matrix4f.toTranslationVector(this.translations[n]);
    }

    public void setRotation(int n, Quaternion quaternion) {
        this.rotations[n] = quaternion;
    }

    public void setTranslation(int n, Vector3f vector3f) {
        this.translations[n] = vector3f;
    }

    public void setRotations(Quaternion[] quaternionArray) {
        this.rotations = quaternionArray;
    }

    public void setTranslations(Vector3f[] vector3fArray) {
        this.translations = vector3fArray;
    }

    public void setTransforms(Matrix4f[] matrix4fArray) {
        if (this.rotations == null || this.rotations.length != matrix4fArray.length) {
            this.rotations = new Quaternion[matrix4fArray.length];
        }
        if (this.translations == null || this.translations.length != matrix4fArray.length) {
            this.translations = new Vector3f[matrix4fArray.length];
        }
        for (int i = 0; i < matrix4fArray.length; ++i) {
            this.setTransform(i, matrix4fArray[i]);
        }
    }

    public void setBone(Bone bone) {
        this.bone = bone;
    }

    private void interpolateRotation(Quaternion quaternion, Quaternion quaternion2, int n, float f, Quaternion quaternion3) {
        if (n == 0) {
            quaternion.slerp(quaternion2, quaternion3, f);
        }
    }

    private void interpolateTranslation(Vector3f vector3f, Vector3f vector3f2, int n, float f, Vector3f vector3f3) {
        if (n == 0) {
            vector3f3.set(vector3f).multLocal(1.0f - f).addLocal(vector3f2.x * f, vector3f2.y * f, vector3f2.z * f);
        }
    }

    public Bone getBone() {
        return this.bone;
    }

    public Quaternion[] getRotations() {
        return this.rotations;
    }

    public Vector3f[] getTranslations() {
        return this.translations;
    }

    public String getBoneId() {
        return this.boneId;
    }

    public void setBoneId(String string) {
        this.boneId = string;
    }

    public boolean findBone(Bone bone) {
        if (this.boneId == null) {
            return false;
        }
        if (this.boneId.equals(bone.getName())) {
            this.bone = bone;
            return true;
        }
        for (int i = 0; i < bone.getQuantity(); ++i) {
            if (!(bone.getChild(i) instanceof Bone) || !this.findBone((Bone)bone.getChild(i))) continue;
            return true;
        }
        return false;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.boneId, "name", null);
        outputCapsule.write(this.rotations, "rotations", null);
        outputCapsule.write(this.translations, "translations", null);
        outputCapsule.write(this.bone, "bone", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        int n;
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.boneId = inputCapsule.readString("name", null);
        Savable[] savableArray = inputCapsule.readSavableArray("rotations", null);
        if (savableArray == null) {
            this.rotations = null;
        } else {
            this.rotations = new Quaternion[savableArray.length];
            for (n = 0; n < savableArray.length; ++n) {
                this.rotations[n] = (Quaternion)savableArray[n];
            }
        }
        savableArray = inputCapsule.readSavableArray("translations", null);
        if (savableArray == null) {
            this.translations = null;
        } else {
            this.translations = new Vector3f[savableArray.length];
            for (n = 0; n < savableArray.length; ++n) {
                this.translations[n] = (Vector3f)savableArray[n];
            }
        }
        savableArray = inputCapsule.readSavableArray("transforms", null);
        if (savableArray != null) {
            Matrix4f[] matrix4fArray = new Matrix4f[savableArray.length];
            for (int i = 0; i < savableArray.length; ++i) {
                matrix4fArray[i] = (Matrix4f)savableArray[i];
            }
            this.setTransforms(matrix4fArray);
        }
        this.bone = (Bone)inputCapsule.readSavable("bone", null);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

