/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.app.AbstractGame;
import com.jme.input.InputSystem;
import com.jme.renderer.Renderer;
import com.jme.util.LoggingSystem;
import java.util.logging.Level;

public abstract class BaseHeadlessApp
extends AbstractGame {
    public final void start() {
        LoggingSystem.getLogger().log(Level.INFO, "Application started.");
        try {
            this.getAttributes();
            this.initSystem();
            this.assertDisplayCreated();
            this.initGame();
            Renderer renderer = this.display.getRenderer();
            while (!this.finished && !this.display.isClosing()) {
                InputSystem.update();
                this.update(-1.0f);
                this.render(-1.0f);
                renderer.displayBackBuffer();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.cleanup();
        LoggingSystem.getLogger().log(Level.INFO, "Application ending.");
        if (this.display != null) {
            this.display.reset();
        }
        this.quit();
    }

    protected void quit() {
        if (this.display != null) {
            this.display.close();
        }
        System.exit(0);
    }

    protected abstract void update(float var1);

    protected abstract void render(float var1);

    protected abstract void initSystem();

    protected abstract void initGame();

    protected abstract void reinit();

    protected abstract void cleanup();
}

