/*
 * Decompiled with CFR 0.152.
 */
package com.jme.bounding;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingCapsule;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.intersection.IntersectionRecord;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Plane;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class OrientedBoundingBox
extends BoundingVolume {
    private static final long serialVersionUID = 1L;
    private static final Vector3f _compVect3 = new Vector3f();
    private static final Vector3f _compVect4 = new Vector3f();
    private static final Vector3f _compVect5 = new Vector3f();
    private static final Vector3f _compVect6 = new Vector3f();
    private static final Vector3f _compVect7 = new Vector3f();
    private static final Vector3f tempVe = new Vector3f();
    private static final Matrix3f tempMa = new Matrix3f();
    private static final Quaternion tempQa = new Quaternion();
    private static final Quaternion tempQb = new Quaternion();
    private static final float[] fWdU = new float[3];
    private static final float[] fAWdU = new float[3];
    private static final float[] fDdU = new float[3];
    private static final float[] fADdU = new float[3];
    private static final float[] fAWxDdU = new float[3];
    private static final float[] tempFa = new float[3];
    private static final float[] tempFb = new float[3];
    public final Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
    public final Vector3f yAxis = new Vector3f(0.0f, 1.0f, 0.0f);
    public final Vector3f zAxis = new Vector3f(0.0f, 0.0f, 1.0f);
    public final Vector3f extent = new Vector3f(0.0f, 0.0f, 0.0f);
    public final Vector3f[] vectorStore = new Vector3f[8];
    private final Vector3f tempVk = new Vector3f();
    private final Vector3f tempForword = new Vector3f(0.0f, 0.0f, 1.0f);
    private final Vector3f tempLeft = new Vector3f(1.0f, 0.0f, 0.0f);
    private final Vector3f tempUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final FloatBuffer _mergeBuf = BufferUtils.createVector3Buffer(16);
    public boolean correctCorners = false;

    public OrientedBoundingBox() {
        for (int i = 0; i < 8; ++i) {
            this.vectorStore[i] = new Vector3f();
        }
    }

    public int getType() {
        return 2;
    }

    public BoundingVolume transform(Quaternion quaternion, Vector3f vector3f, Vector3f vector3f2, BoundingVolume boundingVolume) {
        quaternion.toRotationMatrix(tempMa);
        return this.transform(tempMa, vector3f, vector3f2, boundingVolume);
    }

    public BoundingVolume transform(Matrix3f matrix3f, Vector3f vector3f, Vector3f vector3f2, BoundingVolume boundingVolume) {
        if (boundingVolume == null || boundingVolume.getType() != 2) {
            boundingVolume = new OrientedBoundingBox();
        }
        OrientedBoundingBox orientedBoundingBox = (OrientedBoundingBox)boundingVolume;
        orientedBoundingBox.extent.set(FastMath.abs(this.extent.x * vector3f2.x), FastMath.abs(this.extent.y * vector3f2.y), FastMath.abs(this.extent.z * vector3f2.z));
        matrix3f.mult(this.xAxis, orientedBoundingBox.xAxis);
        matrix3f.mult(this.yAxis, orientedBoundingBox.yAxis);
        matrix3f.mult(this.zAxis, orientedBoundingBox.zAxis);
        this.center.mult(vector3f2, orientedBoundingBox.center);
        matrix3f.mult(orientedBoundingBox.center, orientedBoundingBox.center);
        orientedBoundingBox.center.addLocal(vector3f);
        orientedBoundingBox.correctCorners = false;
        return orientedBoundingBox;
    }

    public int whichSide(Plane plane) {
        float f = FastMath.abs(this.extent.x * plane.getNormal().dot(this.xAxis)) + FastMath.abs(this.extent.y * plane.getNormal().dot(this.yAxis)) + FastMath.abs(this.extent.z * plane.getNormal().dot(this.zAxis));
        float f2 = plane.pseudoDistance(this.center);
        if (f2 <= -f) {
            return 2;
        }
        if (f2 >= f) {
            return 1;
        }
        return 0;
    }

    public void computeFromPoints(FloatBuffer floatBuffer) {
        this.containAABB(floatBuffer);
        this.correctCorners = false;
    }

    public void computeFromBatches(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        OrientedBoundingBox orientedBoundingBox = new OrientedBoundingBox();
        orientedBoundingBox.containAABB(((GeomBatch)arrayList.get(0)).getVertexBuffer());
        for (int i = 1; i < arrayList.size(); ++i) {
            OrientedBoundingBox orientedBoundingBox2 = new OrientedBoundingBox();
            orientedBoundingBox2.containAABB(((GeomBatch)arrayList.get(i)).getVertexBuffer());
            orientedBoundingBox.mergeLocal(orientedBoundingBox2);
        }
        this.center = orientedBoundingBox.getCenter();
        this.extent.set(orientedBoundingBox.extent);
        this.xAxis.set(orientedBoundingBox.xAxis);
        this.yAxis.set(orientedBoundingBox.yAxis);
        this.zAxis.set(orientedBoundingBox.zAxis);
        this.correctCorners = false;
    }

    private void containAABB(FloatBuffer floatBuffer) {
        if (floatBuffer == null || floatBuffer.limit() <= 2) {
            return;
        }
        BufferUtils.populateFromBuffer(_compVect1, floatBuffer, 0);
        float f = OrientedBoundingBox._compVect1.x;
        float f2 = OrientedBoundingBox._compVect1.y;
        float f3 = OrientedBoundingBox._compVect1.z;
        float f4 = OrientedBoundingBox._compVect1.x;
        float f5 = OrientedBoundingBox._compVect1.y;
        float f6 = OrientedBoundingBox._compVect1.z;
        int n = floatBuffer.limit() / 3;
        for (int i = 1; i < n; ++i) {
            BufferUtils.populateFromBuffer(_compVect1, floatBuffer, i);
            if (OrientedBoundingBox._compVect1.x < f) {
                f = OrientedBoundingBox._compVect1.x;
            } else if (OrientedBoundingBox._compVect1.x > f4) {
                f4 = OrientedBoundingBox._compVect1.x;
            }
            if (OrientedBoundingBox._compVect1.y < f2) {
                f2 = OrientedBoundingBox._compVect1.y;
            } else if (OrientedBoundingBox._compVect1.y > f5) {
                f5 = OrientedBoundingBox._compVect1.y;
            }
            if (OrientedBoundingBox._compVect1.z < f3) {
                f3 = OrientedBoundingBox._compVect1.z;
                continue;
            }
            if (!(OrientedBoundingBox._compVect1.z > f6)) continue;
            f6 = OrientedBoundingBox._compVect1.z;
        }
        this.center.set(f + f4, f2 + f5, f3 + f6);
        this.center.multLocal(0.5f);
        this.extent.set(f4 - this.center.x, f5 - this.center.y, f6 - this.center.z);
        this.xAxis.set(1.0f, 0.0f, 0.0f);
        this.yAxis.set(0.0f, 1.0f, 0.0f);
        this.zAxis.set(0.0f, 0.0f, 1.0f);
        this.correctCorners = false;
    }

    public BoundingVolume merge(BoundingVolume boundingVolume) {
        return new OrientedBoundingBox().mergeLocal(boundingVolume);
    }

    public BoundingVolume mergeLocal(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return this;
        }
        switch (boundingVolume.getType()) {
            case 2: {
                return this.mergeOBB((OrientedBoundingBox)boundingVolume);
            }
            case 1: {
                return this.mergeAABB((BoundingBox)boundingVolume);
            }
            case 0: {
                return this.mergeSphere((BoundingSphere)boundingVolume);
            }
        }
        return null;
    }

    private BoundingVolume mergeSphere(BoundingSphere boundingSphere) {
        BoundingSphere boundingSphere2 = boundingSphere;
        if (!this.correctCorners) {
            this.computeCorners();
        }
        _mergeBuf.rewind();
        for (int i = 0; i < 8; ++i) {
            _mergeBuf.put(this.vectorStore[i].x);
            _mergeBuf.put(this.vectorStore[i].y);
            _mergeBuf.put(this.vectorStore[i].z);
        }
        _mergeBuf.put(boundingSphere2.center.x + boundingSphere2.radius).put(boundingSphere2.center.y + boundingSphere2.radius).put(boundingSphere2.center.z + boundingSphere2.radius);
        _mergeBuf.put(boundingSphere2.center.x - boundingSphere2.radius).put(boundingSphere2.center.y + boundingSphere2.radius).put(boundingSphere2.center.z + boundingSphere2.radius);
        _mergeBuf.put(boundingSphere2.center.x + boundingSphere2.radius).put(boundingSphere2.center.y - boundingSphere2.radius).put(boundingSphere2.center.z + boundingSphere2.radius);
        _mergeBuf.put(boundingSphere2.center.x + boundingSphere2.radius).put(boundingSphere2.center.y + boundingSphere2.radius).put(boundingSphere2.center.z - boundingSphere2.radius);
        _mergeBuf.put(boundingSphere2.center.x - boundingSphere2.radius).put(boundingSphere2.center.y - boundingSphere2.radius).put(boundingSphere2.center.z + boundingSphere2.radius);
        _mergeBuf.put(boundingSphere2.center.x - boundingSphere2.radius).put(boundingSphere2.center.y + boundingSphere2.radius).put(boundingSphere2.center.z - boundingSphere2.radius);
        _mergeBuf.put(boundingSphere2.center.x + boundingSphere2.radius).put(boundingSphere2.center.y - boundingSphere2.radius).put(boundingSphere2.center.z - boundingSphere2.radius);
        _mergeBuf.put(boundingSphere2.center.x - boundingSphere2.radius).put(boundingSphere2.center.y - boundingSphere2.radius).put(boundingSphere2.center.z - boundingSphere2.radius);
        this.containAABB(_mergeBuf);
        this.correctCorners = false;
        return this;
    }

    private BoundingVolume mergeAABB(BoundingBox boundingBox) {
        BoundingBox boundingBox2 = boundingBox;
        if (!this.correctCorners) {
            this.computeCorners();
        }
        _mergeBuf.rewind();
        for (int i = 0; i < 8; ++i) {
            _mergeBuf.put(this.vectorStore[i].x);
            _mergeBuf.put(this.vectorStore[i].y);
            _mergeBuf.put(this.vectorStore[i].z);
        }
        _mergeBuf.put(boundingBox2.center.x + boundingBox2.xExtent).put(boundingBox2.center.y + boundingBox2.yExtent).put(boundingBox2.center.z + boundingBox2.zExtent);
        _mergeBuf.put(boundingBox2.center.x - boundingBox2.xExtent).put(boundingBox2.center.y + boundingBox2.yExtent).put(boundingBox2.center.z + boundingBox2.zExtent);
        _mergeBuf.put(boundingBox2.center.x + boundingBox2.xExtent).put(boundingBox2.center.y - boundingBox2.yExtent).put(boundingBox2.center.z + boundingBox2.zExtent);
        _mergeBuf.put(boundingBox2.center.x + boundingBox2.xExtent).put(boundingBox2.center.y + boundingBox2.yExtent).put(boundingBox2.center.z - boundingBox2.zExtent);
        _mergeBuf.put(boundingBox2.center.x - boundingBox2.xExtent).put(boundingBox2.center.y - boundingBox2.yExtent).put(boundingBox2.center.z + boundingBox2.zExtent);
        _mergeBuf.put(boundingBox2.center.x - boundingBox2.xExtent).put(boundingBox2.center.y + boundingBox2.yExtent).put(boundingBox2.center.z - boundingBox2.zExtent);
        _mergeBuf.put(boundingBox2.center.x + boundingBox2.xExtent).put(boundingBox2.center.y - boundingBox2.yExtent).put(boundingBox2.center.z - boundingBox2.zExtent);
        _mergeBuf.put(boundingBox2.center.x - boundingBox2.xExtent).put(boundingBox2.center.y - boundingBox2.yExtent).put(boundingBox2.center.z - boundingBox2.zExtent);
        this.containAABB(_mergeBuf);
        this.correctCorners = false;
        return this;
    }

    private BoundingVolume mergeOBB(OrientedBoundingBox orientedBoundingBox) {
        float f;
        int n;
        OrientedBoundingBox orientedBoundingBox2 = this;
        OrientedBoundingBox orientedBoundingBox3 = orientedBoundingBox;
        Vector3f vector3f = orientedBoundingBox2.center.add(orientedBoundingBox3.center, _compVect7).multLocal(0.5f);
        Quaternion quaternion = tempQa;
        Quaternion quaternion2 = tempQb;
        quaternion.fromAxes(orientedBoundingBox2.xAxis, orientedBoundingBox2.yAxis, orientedBoundingBox2.zAxis);
        quaternion2.fromAxes(orientedBoundingBox3.xAxis, orientedBoundingBox3.yAxis, orientedBoundingBox3.zAxis);
        if (quaternion.dot(quaternion2) < 0.0f) {
            quaternion2.negate();
        }
        Quaternion quaternion3 = quaternion.addLocal(quaternion2);
        quaternion3.normalize();
        Matrix3f matrix3f = quaternion3.toRotationMatrix(tempMa);
        matrix3f.getColumn(0, this.xAxis);
        matrix3f.getColumn(1, this.yAxis);
        matrix3f.getColumn(2, this.zAxis);
        this.correctCorners = false;
        Vector3f vector3f2 = _compVect4;
        Vector3f vector3f3 = _compVect5;
        Vector3f vector3f4 = _compVect6;
        vector3f3.z = Float.MAX_VALUE;
        vector3f3.y = Float.MAX_VALUE;
        vector3f3.x = Float.MAX_VALUE;
        vector3f4.z = -3.4028235E38f;
        vector3f4.y = -3.4028235E38f;
        vector3f4.x = -3.4028235E38f;
        if (!orientedBoundingBox2.correctCorners) {
            orientedBoundingBox2.computeCorners();
        }
        for (n = 0; n < 8; ++n) {
            orientedBoundingBox2.vectorStore[n].subtract(vector3f, vector3f2);
            f = vector3f2.dot(this.xAxis);
            if (f > vector3f4.x) {
                vector3f4.x = f;
            } else if (f < vector3f3.x) {
                vector3f3.x = f;
            }
            f = vector3f2.dot(this.yAxis);
            if (f > vector3f4.y) {
                vector3f4.y = f;
            } else if (f < vector3f3.y) {
                vector3f3.y = f;
            }
            f = vector3f2.dot(this.zAxis);
            if (f > vector3f4.z) {
                vector3f4.z = f;
                continue;
            }
            if (!(f < vector3f3.z)) continue;
            vector3f3.z = f;
        }
        if (!orientedBoundingBox3.correctCorners) {
            orientedBoundingBox3.computeCorners();
        }
        for (n = 0; n < 8; ++n) {
            orientedBoundingBox3.vectorStore[n].subtract(vector3f, vector3f2);
            f = vector3f2.dot(this.xAxis);
            if (f > vector3f4.x) {
                vector3f4.x = f;
            } else if (f < vector3f3.x) {
                vector3f3.x = f;
            }
            f = vector3f2.dot(this.yAxis);
            if (f > vector3f4.y) {
                vector3f4.y = f;
            } else if (f < vector3f3.y) {
                vector3f3.y = f;
            }
            f = vector3f2.dot(this.zAxis);
            if (f > vector3f4.z) {
                vector3f4.z = f;
                continue;
            }
            if (!(f < vector3f3.z)) continue;
            vector3f3.z = f;
        }
        this.extent.x = 0.5f * (vector3f4.x - vector3f3.x);
        vector3f.addLocal(this.xAxis.mult(0.5f * (vector3f4.x + vector3f3.x), tempVe));
        this.extent.y = 0.5f * (vector3f4.y - vector3f3.y);
        vector3f.addLocal(this.yAxis.mult(0.5f * (vector3f4.y + vector3f3.y), tempVe));
        this.extent.z = 0.5f * (vector3f4.z - vector3f3.z);
        vector3f.addLocal(this.zAxis.mult(0.5f * (vector3f4.z + vector3f3.z), tempVe));
        this.center.set(vector3f);
        this.correctCorners = false;
        return this;
    }

    public BoundingVolume clone(BoundingVolume boundingVolume) {
        OrientedBoundingBox orientedBoundingBox = boundingVolume instanceof OrientedBoundingBox ? (OrientedBoundingBox)boundingVolume : new OrientedBoundingBox();
        orientedBoundingBox.extent.set(this.extent);
        orientedBoundingBox.xAxis.set(this.xAxis);
        orientedBoundingBox.yAxis.set(this.yAxis);
        orientedBoundingBox.zAxis.set(this.zAxis);
        orientedBoundingBox.center.set(this.center);
        orientedBoundingBox.checkPlane = this.checkPlane;
        int n = this.vectorStore.length;
        while (--n >= 0) {
            orientedBoundingBox.vectorStore[n].set(this.vectorStore[n]);
        }
        orientedBoundingBox.correctCorners = this.correctCorners;
        return orientedBoundingBox;
    }

    public void recomputeMesh() {
        if (!this.correctCorners) {
            this.computeCorners();
        }
    }

    public void computeCorners() {
        this.correctCorners = true;
        float f = this.xAxis.dot(this.yAxis.cross(this.zAxis, _compVect1));
        Vector3f vector3f = this.yAxis.cross(this.zAxis, _compVect1).multLocal(this.extent.x);
        Vector3f vector3f2 = this.zAxis.cross(this.xAxis, _compVect2).multLocal(this.extent.y);
        Vector3f vector3f3 = this.xAxis.cross(this.yAxis, _compVect3).multLocal(this.extent.z);
        this.vectorStore[0].set((vector3f.x + vector3f2.x + vector3f3.x) / f + this.center.x, (vector3f.y + vector3f2.y + vector3f3.y) / f + this.center.y, (vector3f.z + vector3f2.z + vector3f3.z) / f + this.center.z);
        this.vectorStore[1].set((-vector3f.x + vector3f2.x + vector3f3.x) / f + this.center.x, (-vector3f.y + vector3f2.y + vector3f3.y) / f + this.center.y, (-vector3f.z + vector3f2.z + vector3f3.z) / f + this.center.z);
        this.vectorStore[2].set((vector3f.x + -vector3f2.x + vector3f3.x) / f + this.center.x, (vector3f.y + -vector3f2.y + vector3f3.y) / f + this.center.y, (vector3f.z + -vector3f2.z + vector3f3.z) / f + this.center.z);
        this.vectorStore[3].set((vector3f.x + vector3f2.x + -vector3f3.x) / f + this.center.x, (vector3f.y + vector3f2.y + -vector3f3.y) / f + this.center.y, (vector3f.z + vector3f2.z + -vector3f3.z) / f + this.center.z);
        this.vectorStore[4].set((-vector3f.x + -vector3f2.x + vector3f3.x) / f + this.center.x, (-vector3f.y + -vector3f2.y + vector3f3.y) / f + this.center.y, (-vector3f.z + -vector3f2.z + vector3f3.z) / f + this.center.z);
        this.vectorStore[5].set((-vector3f.x + vector3f2.x + -vector3f3.x) / f + this.center.x, (-vector3f.y + vector3f2.y + -vector3f3.y) / f + this.center.y, (-vector3f.z + vector3f2.z + -vector3f3.z) / f + this.center.z);
        this.vectorStore[6].set((vector3f.x + -vector3f2.x + -vector3f3.x) / f + this.center.x, (vector3f.y + -vector3f2.y + -vector3f3.y) / f + this.center.y, (vector3f.z + -vector3f2.z + -vector3f3.z) / f + this.center.z);
        this.vectorStore[7].set(-(vector3f.x + vector3f2.x + vector3f3.x) / f + this.center.x, -(vector3f.y + vector3f2.y + vector3f3.y) / f + this.center.y, -(vector3f.z + vector3f2.z + vector3f3.z) / f + this.center.z);
    }

    public void computeFromTris(int[] nArray, TriangleBatch triangleBatch, int n, int n2) {
        if (n2 - n <= 0) {
            return;
        }
        Vector3f[] vector3fArray = new Vector3f[3];
        Vector3f vector3f = _compVect1.set(new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
        Vector3f vector3f2 = _compVect2.set(new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY));
        for (int i = n; i < n2; ++i) {
            triangleBatch.getTriangle(nArray[i], vector3fArray);
            Vector3f vector3f3 = vector3fArray[0];
            if (vector3f3.x < vector3f.x) {
                vector3f.x = vector3f3.x;
            } else if (vector3f3.x > vector3f2.x) {
                vector3f2.x = vector3f3.x;
            }
            if (vector3f3.y < vector3f.y) {
                vector3f.y = vector3f3.y;
            } else if (vector3f3.y > vector3f2.y) {
                vector3f2.y = vector3f3.y;
            }
            if (vector3f3.z < vector3f.z) {
                vector3f.z = vector3f3.z;
            } else if (vector3f3.z > vector3f2.z) {
                vector3f2.z = vector3f3.z;
            }
            vector3f3 = vector3fArray[1];
            if (vector3f3.x < vector3f.x) {
                vector3f.x = vector3f3.x;
            } else if (vector3f3.x > vector3f2.x) {
                vector3f2.x = vector3f3.x;
            }
            if (vector3f3.y < vector3f.y) {
                vector3f.y = vector3f3.y;
            } else if (vector3f3.y > vector3f2.y) {
                vector3f2.y = vector3f3.y;
            }
            if (vector3f3.z < vector3f.z) {
                vector3f.z = vector3f3.z;
            } else if (vector3f3.z > vector3f2.z) {
                vector3f2.z = vector3f3.z;
            }
            vector3f3 = vector3fArray[2];
            if (vector3f3.x < vector3f.x) {
                vector3f.x = vector3f3.x;
            } else if (vector3f3.x > vector3f2.x) {
                vector3f2.x = vector3f3.x;
            }
            if (vector3f3.y < vector3f.y) {
                vector3f.y = vector3f3.y;
            } else if (vector3f3.y > vector3f2.y) {
                vector3f2.y = vector3f3.y;
            }
            if (vector3f3.z < vector3f.z) {
                vector3f.z = vector3f3.z;
                continue;
            }
            if (!(vector3f3.z > vector3f2.z)) continue;
            vector3f2.z = vector3f3.z;
        }
        this.center.set(vector3f.addLocal(vector3f2));
        this.center.multLocal(0.5f);
        this.extent.set(vector3f2.x - this.center.x, vector3f2.y - this.center.y, vector3f2.z - this.center.z);
        this.xAxis.set(1.0f, 0.0f, 0.0f);
        this.yAxis.set(0.0f, 1.0f, 0.0f);
        this.zAxis.set(0.0f, 0.0f, 1.0f);
        this.correctCorners = false;
    }

    public void computeFromTris(Triangle[] triangleArray, int n, int n2) {
        if (n2 - n <= 0) {
            return;
        }
        Vector3f vector3f = _compVect1.set(triangleArray[n].get(0));
        Vector3f vector3f2 = _compVect2.set(vector3f);
        for (int i = n; i < n2; ++i) {
            Vector3f vector3f3 = triangleArray[i].get(0);
            if (vector3f3.x < vector3f.x) {
                vector3f.x = vector3f3.x;
            } else if (vector3f3.x > vector3f2.x) {
                vector3f2.x = vector3f3.x;
            }
            if (vector3f3.y < vector3f.y) {
                vector3f.y = vector3f3.y;
            } else if (vector3f3.y > vector3f2.y) {
                vector3f2.y = vector3f3.y;
            }
            if (vector3f3.z < vector3f.z) {
                vector3f.z = vector3f3.z;
            } else if (vector3f3.z > vector3f2.z) {
                vector3f2.z = vector3f3.z;
            }
            vector3f3 = triangleArray[i].get(1);
            if (vector3f3.x < vector3f.x) {
                vector3f.x = vector3f3.x;
            } else if (vector3f3.x > vector3f2.x) {
                vector3f2.x = vector3f3.x;
            }
            if (vector3f3.y < vector3f.y) {
                vector3f.y = vector3f3.y;
            } else if (vector3f3.y > vector3f2.y) {
                vector3f2.y = vector3f3.y;
            }
            if (vector3f3.z < vector3f.z) {
                vector3f.z = vector3f3.z;
            } else if (vector3f3.z > vector3f2.z) {
                vector3f2.z = vector3f3.z;
            }
            vector3f3 = triangleArray[i].get(2);
            if (vector3f3.x < vector3f.x) {
                vector3f.x = vector3f3.x;
            } else if (vector3f3.x > vector3f2.x) {
                vector3f2.x = vector3f3.x;
            }
            if (vector3f3.y < vector3f.y) {
                vector3f.y = vector3f3.y;
            } else if (vector3f3.y > vector3f2.y) {
                vector3f2.y = vector3f3.y;
            }
            if (vector3f3.z < vector3f.z) {
                vector3f.z = vector3f3.z;
                continue;
            }
            if (!(vector3f3.z > vector3f2.z)) continue;
            vector3f2.z = vector3f3.z;
        }
        this.center.set(vector3f.addLocal(vector3f2));
        this.center.multLocal(0.5f);
        this.extent.set(vector3f2.x - this.center.x, vector3f2.y - this.center.y, vector3f2.z - this.center.z);
        this.xAxis.set(1.0f, 0.0f, 0.0f);
        this.yAxis.set(0.0f, 1.0f, 0.0f);
        this.zAxis.set(0.0f, 0.0f, 1.0f);
        this.correctCorners = false;
    }

    public boolean intersection(OrientedBoundingBox orientedBoundingBox) {
        float f;
        float f2;
        float f3;
        int n;
        OrientedBoundingBox orientedBoundingBox2 = this;
        float f4 = 0.999999f;
        boolean bl = false;
        Vector3f[] vector3fArray = new Vector3f[]{orientedBoundingBox2.xAxis, orientedBoundingBox2.yAxis, orientedBoundingBox2.zAxis};
        Vector3f[] vector3fArray2 = new Vector3f[]{orientedBoundingBox.xAxis, orientedBoundingBox.yAxis, orientedBoundingBox.zAxis};
        Vector3f vector3f = orientedBoundingBox2.extent;
        Vector3f vector3f2 = orientedBoundingBox.extent;
        Vector3f vector3f3 = orientedBoundingBox.center.subtract(orientedBoundingBox2.center, _compVect1);
        float[][] fArrayArray = new float[][]{fWdU, fAWdU, fDdU};
        float[][] fArrayArray2 = new float[][]{fADdU, fAWxDdU, tempFa};
        float[] fArray = tempFb;
        for (n = 0; n < 3; ++n) {
            fArrayArray[0][n] = vector3fArray[0].dot(vector3fArray2[n]);
            fArrayArray2[0][n] = FastMath.abs(fArrayArray[0][n]);
            if (!(fArrayArray2[0][n] > f4)) continue;
            bl = true;
        }
        fArray[0] = vector3fArray[0].dot(vector3f3);
        float f5 = FastMath.abs(fArray[0]);
        if (f5 > (f3 = vector3f.x + (f2 = vector3f2.x * fArrayArray2[0][0] + vector3f2.y * fArrayArray2[0][1] + vector3f2.z * fArrayArray2[0][2]))) {
            return false;
        }
        for (n = 0; n < 3; ++n) {
            fArrayArray[1][n] = vector3fArray[1].dot(vector3fArray2[n]);
            fArrayArray2[1][n] = FastMath.abs(fArrayArray[1][n]);
            if (!(fArrayArray2[1][n] > f4)) continue;
            bl = true;
        }
        fArray[1] = vector3fArray[1].dot(vector3f3);
        f5 = FastMath.abs(fArray[1]);
        if (f5 > (f3 = vector3f.y + (f2 = vector3f2.x * fArrayArray2[1][0] + vector3f2.y * fArrayArray2[1][1] + vector3f2.z * fArrayArray2[1][2]))) {
            return false;
        }
        for (n = 0; n < 3; ++n) {
            fArrayArray[2][n] = vector3fArray[2].dot(vector3fArray2[n]);
            fArrayArray2[2][n] = FastMath.abs(fArrayArray[2][n]);
            if (!(fArrayArray2[2][n] > f4)) continue;
            bl = true;
        }
        fArray[2] = vector3fArray[2].dot(vector3f3);
        f5 = FastMath.abs(fArray[2]);
        if (f5 > (f3 = vector3f.z + (f2 = vector3f2.x * fArrayArray2[2][0] + vector3f2.y * fArrayArray2[2][1] + vector3f2.z * fArrayArray2[2][2]))) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[0].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][0] + vector3f.y * fArrayArray2[1][0] + vector3f.z * fArrayArray2[2][0]) + vector3f2.x)) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[1].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][1] + vector3f.y * fArrayArray2[1][1] + vector3f.z * fArrayArray2[2][1]) + vector3f2.y)) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[2].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][2] + vector3f.y * fArrayArray2[1][2] + vector3f.z * fArrayArray2[2][2]) + vector3f2.z)) {
            return false;
        }
        if (bl) {
            return true;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][0] - fArray[1] * fArrayArray[2][0]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][0] + vector3f.z * fArrayArray2[1][0]) + (f2 = vector3f2.y * fArrayArray2[0][2] + vector3f2.z * fArrayArray2[0][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][1] - fArray[1] * fArrayArray[2][1]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][1] + vector3f.z * fArrayArray2[1][1]) + (f2 = vector3f2.x * fArrayArray2[0][2] + vector3f2.z * fArrayArray2[0][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][2] - fArray[1] * fArrayArray[2][2]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][2] + vector3f.z * fArrayArray2[1][2]) + (f2 = vector3f2.x * fArrayArray2[0][1] + vector3f2.y * fArrayArray2[0][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][0] - fArray[2] * fArrayArray[0][0]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][0] + vector3f.z * fArrayArray2[0][0]) + (f2 = vector3f2.y * fArrayArray2[1][2] + vector3f2.z * fArrayArray2[1][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][1] - fArray[2] * fArrayArray[0][1]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][1] + vector3f.z * fArrayArray2[0][1]) + (f2 = vector3f2.x * fArrayArray2[1][2] + vector3f2.z * fArrayArray2[1][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][2] - fArray[2] * fArrayArray[0][2]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][2] + vector3f.z * fArrayArray2[0][2]) + (f2 = vector3f2.x * fArrayArray2[1][1] + vector3f2.y * fArrayArray2[1][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][0] - fArray[0] * fArrayArray[1][0]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[1][0] + vector3f.y * fArrayArray2[0][0]) + (f2 = vector3f2.y * fArrayArray2[2][2] + vector3f2.z * fArrayArray2[2][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][1] - fArray[0] * fArrayArray[1][1]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[1][1] + vector3f.y * fArrayArray2[0][1]) + (f2 = vector3f2.x * fArrayArray2[2][2] + vector3f2.z * fArrayArray2[2][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][2] - fArray[0] * fArrayArray[1][2]);
        return !(f5 > (f3 = (f = vector3f.x * fArrayArray2[1][2] + vector3f.y * fArrayArray2[0][2]) + (f2 = vector3f2.x * fArrayArray2[2][1] + vector3f2.y * fArrayArray2[2][0])));
    }

    public boolean intersects(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return false;
        }
        return boundingVolume.intersectsOrientedBoundingBox(this);
    }

    public boolean intersectsSphere(BoundingSphere boundingSphere) {
        _compVect1.set(boundingSphere.getCenter()).subtractLocal(this.center);
        tempMa.fromAxes(this.xAxis, this.yAxis, this.zAxis);
        tempMa.mult(_compVect1, _compVect2);
        return FastMath.abs(OrientedBoundingBox._compVect2.x) < boundingSphere.getRadius() + this.extent.x && FastMath.abs(OrientedBoundingBox._compVect2.y) < boundingSphere.getRadius() + this.extent.y && FastMath.abs(OrientedBoundingBox._compVect2.z) < boundingSphere.getRadius() + this.extent.z;
    }

    public boolean intersectsBoundingBox(BoundingBox boundingBox) {
        float f;
        float f2;
        float f3;
        int n;
        float f4 = 0.999999f;
        boolean bl = false;
        Vector3f[] vector3fArray = new Vector3f[]{this.xAxis, this.yAxis, this.zAxis};
        Vector3f[] vector3fArray2 = new Vector3f[]{this.tempForword, this.tempLeft, this.tempUp};
        Vector3f vector3f = this.extent;
        Vector3f vector3f2 = this.tempVk.set(boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent);
        Vector3f vector3f3 = boundingBox.getCenter().subtract(this.center, _compVect1);
        float[][] fArrayArray = new float[][]{fWdU, fAWdU, fDdU};
        float[][] fArrayArray2 = new float[][]{fADdU, fAWxDdU, tempFa};
        float[] fArray = tempFb;
        for (n = 0; n < 3; ++n) {
            fArrayArray[0][n] = vector3fArray[0].dot(vector3fArray2[n]);
            fArrayArray2[0][n] = FastMath.abs(fArrayArray[0][n]);
            if (!(fArrayArray2[0][n] > f4)) continue;
            bl = true;
        }
        fArray[0] = vector3fArray[0].dot(vector3f3);
        float f5 = FastMath.abs(fArray[0]);
        if (f5 > (f3 = vector3f.x + (f2 = vector3f2.x * fArrayArray2[0][0] + vector3f2.y * fArrayArray2[0][1] + vector3f2.z * fArrayArray2[0][2]))) {
            return false;
        }
        for (n = 0; n < 3; ++n) {
            fArrayArray[1][n] = vector3fArray[1].dot(vector3fArray2[n]);
            fArrayArray2[1][n] = FastMath.abs(fArrayArray[1][n]);
            if (!(fArrayArray2[1][n] > f4)) continue;
            bl = true;
        }
        fArray[1] = vector3fArray[1].dot(vector3f3);
        f5 = FastMath.abs(fArray[1]);
        if (f5 > (f3 = vector3f.y + (f2 = vector3f2.x * fArrayArray2[1][0] + vector3f2.y * fArrayArray2[1][1] + vector3f2.z * fArrayArray2[1][2]))) {
            return false;
        }
        for (n = 0; n < 3; ++n) {
            fArrayArray[2][n] = vector3fArray[2].dot(vector3fArray2[n]);
            fArrayArray2[2][n] = FastMath.abs(fArrayArray[2][n]);
            if (!(fArrayArray2[2][n] > f4)) continue;
            bl = true;
        }
        fArray[2] = vector3fArray[2].dot(vector3f3);
        f5 = FastMath.abs(fArray[2]);
        if (f5 > (f3 = vector3f.z + (f2 = vector3f2.x * fArrayArray2[2][0] + vector3f2.y * fArrayArray2[2][1] + vector3f2.z * fArrayArray2[2][2]))) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[0].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][0] + vector3f.y * fArrayArray2[1][0] + vector3f.z * fArrayArray2[2][0]) + vector3f2.x)) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[1].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][1] + vector3f.y * fArrayArray2[1][1] + vector3f.z * fArrayArray2[2][1]) + vector3f2.y)) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[2].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][2] + vector3f.y * fArrayArray2[1][2] + vector3f.z * fArrayArray2[2][2]) + vector3f2.z)) {
            return false;
        }
        if (bl) {
            return true;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][0] - fArray[1] * fArrayArray[2][0]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][0] + vector3f.z * fArrayArray2[1][0]) + (f2 = vector3f2.y * fArrayArray2[0][2] + vector3f2.z * fArrayArray2[0][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][1] - fArray[1] * fArrayArray[2][1]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][1] + vector3f.z * fArrayArray2[1][1]) + (f2 = vector3f2.x * fArrayArray2[0][2] + vector3f2.z * fArrayArray2[0][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][2] - fArray[1] * fArrayArray[2][2]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][2] + vector3f.z * fArrayArray2[1][2]) + (f2 = vector3f2.x * fArrayArray2[0][1] + vector3f2.y * fArrayArray2[0][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][0] - fArray[2] * fArrayArray[0][0]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][0] + vector3f.z * fArrayArray2[0][0]) + (f2 = vector3f2.y * fArrayArray2[1][2] + vector3f2.z * fArrayArray2[1][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][1] - fArray[2] * fArrayArray[0][1]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][1] + vector3f.z * fArrayArray2[0][1]) + (f2 = vector3f2.x * fArrayArray2[1][2] + vector3f2.z * fArrayArray2[1][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][2] - fArray[2] * fArrayArray[0][2]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][2] + vector3f.z * fArrayArray2[0][2]) + (f2 = vector3f2.x * fArrayArray2[1][1] + vector3f2.y * fArrayArray2[1][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][0] - fArray[0] * fArrayArray[1][0]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[1][0] + vector3f.y * fArrayArray2[0][0]) + (f2 = vector3f2.y * fArrayArray2[2][2] + vector3f2.z * fArrayArray2[2][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][1] - fArray[0] * fArrayArray[1][1]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[1][1] + vector3f.y * fArrayArray2[0][1]) + (f2 = vector3f2.x * fArrayArray2[2][2] + vector3f2.z * fArrayArray2[2][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][2] - fArray[0] * fArrayArray[1][2]);
        return !(f5 > (f3 = (f = vector3f.x * fArrayArray2[1][2] + vector3f.y * fArrayArray2[0][2]) + (f2 = vector3f2.x * fArrayArray2[2][1] + vector3f2.y * fArrayArray2[2][0])));
    }

    public boolean intersectsOrientedBoundingBox(OrientedBoundingBox orientedBoundingBox) {
        float f;
        float f2;
        float f3;
        int n;
        float f4 = 0.999999f;
        boolean bl = false;
        Vector3f[] vector3fArray = new Vector3f[]{this.xAxis, this.yAxis, this.zAxis};
        Vector3f[] vector3fArray2 = new Vector3f[]{orientedBoundingBox.xAxis, orientedBoundingBox.yAxis, orientedBoundingBox.zAxis};
        Vector3f vector3f = this.extent;
        Vector3f vector3f2 = orientedBoundingBox.extent;
        Vector3f vector3f3 = orientedBoundingBox.center.subtract(this.center, _compVect1);
        float[][] fArrayArray = new float[][]{fWdU, fAWdU, fDdU};
        float[][] fArrayArray2 = new float[][]{fADdU, fAWxDdU, tempFa};
        float[] fArray = tempFb;
        for (n = 0; n < 3; ++n) {
            fArrayArray[0][n] = vector3fArray[0].dot(vector3fArray2[n]);
            fArrayArray2[0][n] = FastMath.abs(fArrayArray[0][n]);
            if (!(fArrayArray2[0][n] > f4)) continue;
            bl = true;
        }
        fArray[0] = vector3fArray[0].dot(vector3f3);
        float f5 = FastMath.abs(fArray[0]);
        if (f5 > (f3 = vector3f.x + (f2 = vector3f2.x * fArrayArray2[0][0] + vector3f2.y * fArrayArray2[0][1] + vector3f2.z * fArrayArray2[0][2]))) {
            return false;
        }
        for (n = 0; n < 3; ++n) {
            fArrayArray[1][n] = vector3fArray[1].dot(vector3fArray2[n]);
            fArrayArray2[1][n] = FastMath.abs(fArrayArray[1][n]);
            if (!(fArrayArray2[1][n] > f4)) continue;
            bl = true;
        }
        fArray[1] = vector3fArray[1].dot(vector3f3);
        f5 = FastMath.abs(fArray[1]);
        if (f5 > (f3 = vector3f.y + (f2 = vector3f2.x * fArrayArray2[1][0] + vector3f2.y * fArrayArray2[1][1] + vector3f2.z * fArrayArray2[1][2]))) {
            return false;
        }
        for (n = 0; n < 3; ++n) {
            fArrayArray[2][n] = vector3fArray[2].dot(vector3fArray2[n]);
            fArrayArray2[2][n] = FastMath.abs(fArrayArray[2][n]);
            if (!(fArrayArray2[2][n] > f4)) continue;
            bl = true;
        }
        fArray[2] = vector3fArray[2].dot(vector3f3);
        f5 = FastMath.abs(fArray[2]);
        if (f5 > (f3 = vector3f.z + (f2 = vector3f2.x * fArrayArray2[2][0] + vector3f2.y * fArrayArray2[2][1] + vector3f2.z * fArrayArray2[2][2]))) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[0].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][0] + vector3f.y * fArrayArray2[1][0] + vector3f.z * fArrayArray2[2][0]) + vector3f2.x)) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[1].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][1] + vector3f.y * fArrayArray2[1][1] + vector3f.z * fArrayArray2[2][1]) + vector3f2.y)) {
            return false;
        }
        f5 = FastMath.abs(vector3fArray2[2].dot(vector3f3));
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[0][2] + vector3f.y * fArrayArray2[1][2] + vector3f.z * fArrayArray2[2][2]) + vector3f2.z)) {
            return false;
        }
        if (bl) {
            return true;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][0] - fArray[1] * fArrayArray[2][0]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][0] + vector3f.z * fArrayArray2[1][0]) + (f2 = vector3f2.y * fArrayArray2[0][2] + vector3f2.z * fArrayArray2[0][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][1] - fArray[1] * fArrayArray[2][1]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][1] + vector3f.z * fArrayArray2[1][1]) + (f2 = vector3f2.x * fArrayArray2[0][2] + vector3f2.z * fArrayArray2[0][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[2] * fArrayArray[1][2] - fArray[1] * fArrayArray[2][2]);
        if (f5 > (f3 = (f = vector3f.y * fArrayArray2[2][2] + vector3f.z * fArrayArray2[1][2]) + (f2 = vector3f2.x * fArrayArray2[0][1] + vector3f2.y * fArrayArray2[0][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][0] - fArray[2] * fArrayArray[0][0]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][0] + vector3f.z * fArrayArray2[0][0]) + (f2 = vector3f2.y * fArrayArray2[1][2] + vector3f2.z * fArrayArray2[1][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][1] - fArray[2] * fArrayArray[0][1]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][1] + vector3f.z * fArrayArray2[0][1]) + (f2 = vector3f2.x * fArrayArray2[1][2] + vector3f2.z * fArrayArray2[1][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[0] * fArrayArray[2][2] - fArray[2] * fArrayArray[0][2]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[2][2] + vector3f.z * fArrayArray2[0][2]) + (f2 = vector3f2.x * fArrayArray2[1][1] + vector3f2.y * fArrayArray2[1][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][0] - fArray[0] * fArrayArray[1][0]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[1][0] + vector3f.y * fArrayArray2[0][0]) + (f2 = vector3f2.y * fArrayArray2[2][2] + vector3f2.z * fArrayArray2[2][1]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][1] - fArray[0] * fArrayArray[1][1]);
        if (f5 > (f3 = (f = vector3f.x * fArrayArray2[1][1] + vector3f.y * fArrayArray2[0][1]) + (f2 = vector3f2.x * fArrayArray2[2][2] + vector3f2.z * fArrayArray2[2][0]))) {
            return false;
        }
        f5 = FastMath.abs(fArray[1] * fArrayArray[0][2] - fArray[0] * fArrayArray[1][2]);
        return !(f5 > (f3 = (f = vector3f.x * fArrayArray2[1][2] + vector3f.y * fArrayArray2[0][2]) + (f2 = vector3f2.x * fArrayArray2[2][1] + vector3f2.y * fArrayArray2[2][0])));
    }

    public boolean intersectsCapsule(BoundingCapsule boundingCapsule) {
        return boundingCapsule.intersectsOrientedBoundingBox(this);
    }

    public boolean intersects(Ray ray) {
        Vector3f vector3f = ray.origin.subtract(this.getCenter(_compVect2), _compVect1);
        OrientedBoundingBox.fWdU[0] = ray.getDirection().dot(this.xAxis);
        OrientedBoundingBox.fAWdU[0] = FastMath.abs(fWdU[0]);
        OrientedBoundingBox.fDdU[0] = vector3f.dot(this.xAxis);
        OrientedBoundingBox.fADdU[0] = FastMath.abs(fDdU[0]);
        if (fADdU[0] > this.extent.x && (double)(fDdU[0] * fWdU[0]) >= 0.0) {
            return false;
        }
        OrientedBoundingBox.fWdU[1] = ray.getDirection().dot(this.yAxis);
        OrientedBoundingBox.fAWdU[1] = FastMath.abs(fWdU[1]);
        OrientedBoundingBox.fDdU[1] = vector3f.dot(this.yAxis);
        OrientedBoundingBox.fADdU[1] = FastMath.abs(fDdU[1]);
        if (fADdU[1] > this.extent.y && (double)(fDdU[1] * fWdU[1]) >= 0.0) {
            return false;
        }
        OrientedBoundingBox.fWdU[2] = ray.getDirection().dot(this.zAxis);
        OrientedBoundingBox.fAWdU[2] = FastMath.abs(fWdU[2]);
        OrientedBoundingBox.fDdU[2] = vector3f.dot(this.zAxis);
        OrientedBoundingBox.fADdU[2] = FastMath.abs(fDdU[2]);
        if (fADdU[2] > this.extent.z && (double)(fDdU[2] * fWdU[2]) >= 0.0) {
            return false;
        }
        Vector3f vector3f2 = ray.getDirection().cross(vector3f, _compVect2);
        OrientedBoundingBox.fAWxDdU[0] = FastMath.abs(vector3f2.dot(this.xAxis));
        float f = this.extent.y * fAWdU[2] + this.extent.z * fAWdU[1];
        if (fAWxDdU[0] > f) {
            return false;
        }
        OrientedBoundingBox.fAWxDdU[1] = FastMath.abs(vector3f2.dot(this.yAxis));
        f = this.extent.x * fAWdU[2] + this.extent.z * fAWdU[0];
        if (fAWxDdU[1] > f) {
            return false;
        }
        OrientedBoundingBox.fAWxDdU[2] = FastMath.abs(vector3f2.dot(this.zAxis));
        f = this.extent.x * fAWdU[1] + this.extent.y * fAWdU[0];
        return !(fAWxDdU[2] > f);
    }

    public IntersectionRecord intersectsWhere(Ray ray) {
        boolean bl;
        Vector3f vector3f = _compVect1.set(ray.origin).subtractLocal(this.center);
        Vector3f vector3f2 = _compVect2.set(ray.direction.x, ray.direction.y, ray.direction.z);
        float[] fArray = new float[]{0.0f, Float.POSITIVE_INFINITY};
        float f = fArray[0];
        float f2 = fArray[1];
        boolean bl2 = bl = this.clip(vector3f2.x, -vector3f.x - this.extent.x, fArray) && this.clip(-vector3f2.x, vector3f.x - this.extent.x, fArray) && this.clip(vector3f2.y, -vector3f.y - this.extent.y, fArray) && this.clip(-vector3f2.y, vector3f.y - this.extent.y, fArray) && this.clip(vector3f2.z, -vector3f.z - this.extent.z, fArray) && this.clip(-vector3f2.z, vector3f.z - this.extent.z, fArray);
        if (bl && (fArray[0] != f || fArray[1] != f2)) {
            if (fArray[1] > fArray[0]) {
                float[] fArray2 = fArray;
                Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(ray.direction).multLocal(fArray2[0]).addLocal(ray.origin), new Vector3f(ray.direction).multLocal(fArray2[1]).addLocal(ray.origin)};
                IntersectionRecord intersectionRecord = new IntersectionRecord(fArray2, vector3fArray);
                return intersectionRecord;
            }
            float[] fArray3 = new float[]{fArray[0]};
            Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(ray.direction).multLocal(fArray3[0]).addLocal(ray.origin)};
            IntersectionRecord intersectionRecord = new IntersectionRecord(fArray3, vector3fArray);
            return intersectionRecord;
        }
        return new IntersectionRecord();
    }

    private boolean clip(float f, float f2, float[] fArray) {
        if (f > 0.0f) {
            if (f2 > f * fArray[1]) {
                return false;
            }
            if (f2 > f * fArray[0]) {
                fArray[0] = f2 / f;
            }
            return true;
        }
        if (f < 0.0f) {
            if (f2 > f * fArray[0]) {
                return false;
            }
            if (f2 > f * fArray[1]) {
                fArray[1] = f2 / f;
            }
            return true;
        }
        return (double)f2 <= 0.0;
    }

    public void setXAxis(Vector3f vector3f) {
        this.xAxis.set(vector3f);
        this.correctCorners = false;
    }

    public void setYAxis(Vector3f vector3f) {
        this.yAxis.set(vector3f);
        this.correctCorners = false;
    }

    public void setZAxis(Vector3f vector3f) {
        this.zAxis.set(vector3f);
        this.correctCorners = false;
    }

    public void setExtent(Vector3f vector3f) {
        this.extent.set(vector3f);
        this.correctCorners = false;
    }

    public Vector3f getXAxis() {
        return this.xAxis;
    }

    public Vector3f getYAxis() {
        return this.yAxis;
    }

    public Vector3f getZAxis() {
        return this.zAxis;
    }

    public Vector3f getExtent() {
        return this.extent;
    }

    public boolean contains(Vector3f vector3f) {
        _compVect1.set(vector3f).subtractLocal(this.center);
        float f = _compVect1.dot(this.xAxis);
        if (FastMath.abs(f) > this.extent.x) {
            return false;
        }
        f = _compVect1.dot(this.yAxis);
        if (FastMath.abs(f) > this.extent.y) {
            return false;
        }
        f = _compVect1.dot(this.zAxis);
        return !(FastMath.abs(f) > this.extent.z);
    }

    public float distanceToEdge(Vector3f vector3f) {
        float f;
        Vector3f vector3f2 = vector3f.subtract(this.center);
        Vector3f vector3f3 = new Vector3f(vector3f2.dot(this.xAxis), vector3f2.dot(this.yAxis), vector3f2.dot(this.zAxis));
        float f2 = 0.0f;
        if (vector3f3.x < -this.extent.x) {
            f = vector3f3.x + this.extent.x;
            f2 += f * f;
            vector3f3.x = -this.extent.x;
        } else if (vector3f3.x > this.extent.x) {
            f = vector3f3.x - this.extent.x;
            f2 += f * f;
            vector3f3.x = this.extent.x;
        }
        if (vector3f3.y < -this.extent.y) {
            f = vector3f3.y + this.extent.y;
            f2 += f * f;
            vector3f3.y = -this.extent.y;
        } else if (vector3f3.y > this.extent.y) {
            f = vector3f3.y - this.extent.y;
            f2 += f * f;
            vector3f3.y = this.extent.y;
        }
        if (vector3f3.z < -this.extent.z) {
            f = vector3f3.z + this.extent.z;
            f2 += f * f;
            vector3f3.z = -this.extent.z;
        } else if (vector3f3.z > this.extent.z) {
            f = vector3f3.z - this.extent.z;
            f2 += f * f;
            vector3f3.z = this.extent.z;
        }
        return FastMath.sqrt(f2);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.xAxis, "xAxis", Vector3f.UNIT_X);
        outputCapsule.write(this.yAxis, "yAxis", Vector3f.UNIT_Y);
        outputCapsule.write(this.zAxis, "zAxis", Vector3f.UNIT_Z);
        outputCapsule.write(this.extent, "extent", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.xAxis.set((Vector3f)inputCapsule.readSavable("xAxis", new Vector3f(Vector3f.UNIT_X)));
        this.yAxis.set((Vector3f)inputCapsule.readSavable("yAxis", new Vector3f(Vector3f.UNIT_Y)));
        this.zAxis.set((Vector3f)inputCapsule.readSavable("zAxis", new Vector3f(Vector3f.UNIT_Z)));
        this.extent.set((Vector3f)inputCapsule.readSavable("extent", new Vector3f(Vector3f.ZERO)));
        this.correctCorners = false;
    }

    public float getVolume() {
        return 8.0f * this.extent.x * this.extent.y * this.extent.z;
    }
}

