/*
 * Decompiled with CFR 0.152.
 */
package com.jme.image.util;

import com.jme.image.Image;
import com.jme.util.LittleEndien;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class DDSLoader {
    private DDSLoader() {
    }

    public static Image loadImage(InputStream inputStream) throws IOException {
        return DDSLoader.loadImage(inputStream, false);
    }

    public static Image loadImage(InputStream inputStream, boolean bl) throws IOException {
        DDSReader dDSReader = new DDSReader(inputStream);
        dDSReader.loadHeader();
        ByteBuffer byteBuffer = dDSReader.readData(bl);
        return new Image(dDSReader.pixelFormat_, dDSReader.width_, dDSReader.height_, byteBuffer, dDSReader.sizes_);
    }

    public static class DDSReader {
        private static final int DDSD_MANDATORY = 4103;
        private static final int DDSD_MIPMAPCOUNT = 131072;
        private static final int DDSD_LINEARSIZE = 524288;
        private static final int DDSD_DEPTH = 0x800000;
        private static final int DDPF_ALPHAPIXELS = 1;
        private static final int DDPF_FOURCC = 4;
        private static final int DDPF_RGB = 64;
        private static final int DDSCAPS_COMPLEX = 8;
        private static final int DDSCAPS_TEXTURE = 4096;
        private static final int DDSCAPS_MIPMAP = 0x400000;
        private static final int DDSCAPS2_CUBEMAP = 512;
        private static final int DDSCAPS2_VOLUME = 0x200000;
        private static final int PF_DXT1 = 827611204;
        private static final int PF_DXT3 = 861165636;
        private static final int PF_DXT5 = 894720068;
        private static final double LOG2 = Math.log(2.0);
        private int width_;
        private int height_;
        private int flags_;
        private int pitchOrSize_;
        private int mipMapCount_;
        private int caps1_;
        private int caps2_;
        private boolean compressed_;
        private int pixelFormat_;
        private int bpp_;
        private int[] sizes_;
        private DataInput in_;

        public DDSReader(InputStream inputStream) {
            this.in_ = new LittleEndien(inputStream);
        }

        public void loadHeader() throws IOException {
            if (this.in_.readInt() != 542327876 || this.in_.readInt() != 124) {
                throw new IOException("Not a DDS file");
            }
            this.flags_ = this.in_.readInt();
            if (!DDSReader.is(this.flags_, 4103)) {
                throw new IOException("Mandatory flags missing");
            }
            if (DDSReader.is(this.flags_, 0x800000)) {
                throw new IOException("Depth not supported");
            }
            this.height_ = this.in_.readInt();
            this.width_ = this.in_.readInt();
            this.pitchOrSize_ = this.in_.readInt();
            this.in_.skipBytes(4);
            this.mipMapCount_ = this.in_.readInt();
            this.in_.skipBytes(44);
            this.readPixelFormat();
            this.caps1_ = this.in_.readInt();
            this.caps2_ = this.in_.readInt();
            this.in_.skipBytes(12);
            if (!DDSReader.is(this.caps1_, 4096)) {
                throw new IOException("File is not a texture");
            }
            if (DDSReader.is(this.caps2_, 512)) {
                throw new IOException("Cubemaps not supported");
            }
            if (DDSReader.is(this.caps2_, 0x200000)) {
                throw new IOException("Volume textures not supported");
            }
            int n = 1 + (int)Math.ceil(Math.log(Math.max(this.height_, this.width_)) / LOG2);
            if (DDSReader.is(this.caps1_, 0x400000)) {
                if (!DDSReader.is(this.flags_, 131072)) {
                    this.mipMapCount_ = n;
                } else if (this.mipMapCount_ != n) {
                    throw new IOException("Got " + this.mipMapCount_ + "mipmaps, expected" + n);
                }
            } else {
                this.mipMapCount_ = 1;
            }
            this.loadSizes();
        }

        private void readPixelFormat() throws IOException {
            int n = this.in_.readInt();
            if (n != 32) {
                throw new IOException("Pixel format size is " + n + ", not 32");
            }
            int n2 = this.in_.readInt();
            if (DDSReader.is(n2, 4)) {
                if (!DDSReader.is(this.flags_, 524288)) {
                    throw new IOException("Must use linear size with fourcc");
                }
                this.compressed_ = true;
                int n3 = this.in_.readInt();
                this.in_.skipBytes(20);
                switch (n3) {
                    case 827611204: {
                        this.bpp_ = 4;
                        if (DDSReader.is(n2, 1)) {
                            this.pixelFormat_ = 10;
                            break;
                        }
                        this.pixelFormat_ = 9;
                        break;
                    }
                    case 861165636: {
                        this.bpp_ = 8;
                        this.pixelFormat_ = 11;
                        break;
                    }
                    case 894720068: {
                        this.bpp_ = 8;
                        this.pixelFormat_ = 12;
                        break;
                    }
                    default: {
                        throw new IOException("Unknown fourcc: " + DDSReader.string(n3));
                    }
                }
                int n4 = (this.width_ + 3) / 4 * ((this.height_ + 3) / 4) * this.bpp_ * 2;
                if (this.pitchOrSize_ != n4) {
                    throw new IOException("Expected size = " + n4 + ", real = " + this.pitchOrSize_);
                }
            } else {
                this.compressed_ = false;
                throw new IOException("Uncompressed not supported");
            }
        }

        private void loadSizes() {
            int n = this.width_;
            int n2 = this.height_;
            this.sizes_ = new int[this.mipMapCount_];
            for (int i = 0; i < this.mipMapCount_; ++i) {
                if (!this.compressed_) {
                    throw new RuntimeException("Uncompressed not supported");
                }
                int n3 = (n + 3) / 4 * ((n2 + 3) / 4) * this.bpp_ * 2;
                this.sizes_[i] = (n3 + 3) / 4 * 4;
                n = Math.max(n / 2, 1);
                n2 = Math.max(n2 / 2, 1);
            }
        }

        public ByteBuffer readData(boolean bl) throws IOException {
            int n = 0;
            for (int i = 0; i < this.sizes_.length; ++i) {
                n += this.sizes_[i];
            }
            byte[] byArray = new byte[n];
            this.in_.readFully(byArray);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            return byteBuffer;
        }

        private static boolean is(int n, int n2) {
            return (n & n2) == n2;
        }

        private static String string(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((char)(n & 0xFF));
            stringBuffer.append((char)((n & 0xFF00) >> 8));
            stringBuffer.append((char)((n & 0xFF0000) >> 16));
            stringBuffer.append((char)((n & 0xFF00000) >> 24));
            return stringBuffer.toString();
        }
    }
}

