/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.action.InputActionInterface;
import com.jme.input.action.KeyBackwardAction;
import com.jme.input.action.KeyForwardAction;
import com.jme.input.action.KeyLookDownAction;
import com.jme.input.action.KeyLookUpAction;
import com.jme.input.action.KeyRotateLeftAction;
import com.jme.input.action.KeyRotateRightAction;
import com.jme.input.action.KeyStrafeLeftAction;
import com.jme.input.action.KeyStrafeRightAction;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;

public class KeyboardLookHandler
extends InputHandler {
    private KeyRotateRightAction right;
    private KeyRotateLeftAction left;

    public KeyboardLookHandler(Camera camera, float f, float f2) {
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        keyBindingManager.set("forward", 17);
        keyBindingManager.set("backward", 31);
        keyBindingManager.set("strafeLeft", 30);
        keyBindingManager.set("strafeRight", 32);
        keyBindingManager.set("lookUp", 200);
        keyBindingManager.set("lookDown", 208);
        keyBindingManager.set("turnRight", 205);
        keyBindingManager.set("turnLeft", 203);
        this.addAction((InputActionInterface)new KeyForwardAction(camera, f), "forward", true);
        this.addAction((InputActionInterface)new KeyBackwardAction(camera, f), "backward", true);
        this.addAction((InputActionInterface)new KeyStrafeLeftAction(camera, f), "strafeLeft", true);
        this.addAction((InputActionInterface)new KeyStrafeRightAction(camera, f), "strafeRight", true);
        this.addAction((InputActionInterface)new KeyLookUpAction(camera, f2), "lookUp", true);
        this.addAction((InputActionInterface)new KeyLookDownAction(camera, f2), "lookDown", true);
        this.right = new KeyRotateRightAction(camera, f2);
        this.right.setLockAxis(new Vector3f(camera.getUp()));
        this.addAction((InputActionInterface)this.right, "turnRight", true);
        this.left = new KeyRotateLeftAction(camera, f2);
        this.left.setLockAxis(new Vector3f(camera.getUp()));
        this.addAction((InputActionInterface)this.left, "turnLeft", true);
    }

    public void setLockAxis(Vector3f vector3f) {
        this.right.setLockAxis(new Vector3f(vector3f));
        this.left.setLockAxis(new Vector3f(vector3f));
    }
}

