/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.InputHandler;
import com.jme.math.Vector3f;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;

public abstract class Mouse
extends Quad {
    protected boolean hasCursor = false;
    protected int imageWidth;
    protected int imageHeight;
    protected Vector3f hotSpotLocation = new Vector3f();
    protected Vector3f hotSpotOffset = new Vector3f();

    public Mouse(String string) {
        super(string, 32.0f, 32.0f);
        this.setCullMode(3);
        this.setRenderQueueMode(4);
        this.setZOrder(Integer.MIN_VALUE);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
    }

    public RenderState setRenderState(RenderState renderState) {
        if (renderState.getType() == 6) {
            this.hasCursor = true;
            this.imageHeight = ((TextureState)renderState).getTexture().getImage().getHeight();
            this.imageWidth = ((TextureState)renderState).getTexture().getImage().getWidth();
            this.initialize(this.imageWidth, this.imageHeight);
            this.hotSpotOffset = new Vector3f(-this.imageWidth / 2, this.imageHeight / 2, 0.0f);
        }
        return super.setRenderState(renderState);
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public boolean hasCursor() {
        return this.hasCursor;
    }

    public abstract void setSpeed(float var1);

    public Vector3f getHotSpotPosition() {
        return this.hotSpotLocation;
    }

    public Vector3f getHotSpotOffset() {
        return this.hotSpotOffset;
    }

    public void setHotSpotOffset(Vector3f vector3f) {
        this.hotSpotOffset = vector3f;
    }

    public abstract void registerWithInputHandler(InputHandler var1);
}

