/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.joystick;

import com.jme.input.Input;
import com.jme.input.joystick.DummyJoystickInput;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInputListener;
import com.jme.input.joystick.lwjgl.LWJGLJoystickInput;
import com.jme.util.LoggingSystem;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoystickInput
extends Input {
    private static JoystickInput instance;
    public static final String INPUT_LWJGL;
    public static final String INPUT_DUMMY;
    private static Class provider;
    protected ArrayList<JoystickInputListener> listeners;

    public static JoystickInput get() {
        if (instance == null) {
            try {
                if (instance == null) {
                    try {
                        Constructor constructor = JoystickInput.getProvider().getDeclaredConstructor(null);
                        constructor.setAccessible(true);
                        instance = (JoystickInput)constructor.newInstance(null);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Error creating input provider", exception);
                    }
                }
                return instance;
            }
            catch (RuntimeException runtimeException) {
                LoggingSystem.getLogger().warning("Joystick support disabled due to error:");
                runtimeException.printStackTrace();
                instance = new DummyJoystickInput(){};
            }
        }
        return instance;
    }

    protected JoystickInput() {
    }

    public static Class getProvider() {
        return provider;
    }

    public static void setProvider(String string) {
        if (instance != null) {
            throw new IllegalStateException("Provider may only be changed before input is created!");
        }
        if ("LWJGL".equals(string)) {
            string = INPUT_LWJGL;
        } else if ("DUMMY".equals(string)) {
            string = INPUT_DUMMY;
        }
        try {
            JoystickInput.setProvider(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unsupported provider: " + classNotFoundException.getMessage());
        }
    }

    public static void setProvider(Class clazz) {
        if (instance != null) {
            throw new IllegalStateException("Provider may only be changed before input is created!");
        }
        if (!JoystickInput.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Specified class does not extend JoystickInput");
        }
        provider = clazz;
    }

    public void addListener(JoystickInputListener joystickInputListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(joystickInputListener);
    }

    public void removeListener(JoystickInputListener joystickInputListener) {
        if (this.listeners != null) {
            this.listeners.remove(joystickInputListener);
        }
    }

    public void removeListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public abstract int getJoystickCount();

    public abstract Joystick getJoystick(int var1);

    public abstract Joystick getDefaultJoystick();

    public static void destroyIfInitalized() {
        if (instance != null) {
            instance.destroy();
            instance = null;
        }
    }

    protected abstract void destroy();

    public abstract ArrayList<Joystick> findJoysticksByAxis(String ... var1);

    static {
        INPUT_LWJGL = LWJGLJoystickInput.class.getName();
        INPUT_DUMMY = DummyJoystickInput.class.getName();
        provider = DummyJoystickInput.class;
    }
}

