/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.mouse;

import com.jme.input.ActionTrigger;
import com.jme.input.InputHandler;
import com.jme.input.InputHandlerDevice;
import com.jme.input.MouseInput;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.mouse.TriggersMouseInputListener;
import com.jme.system.DisplaySystem;

public class MouseInputHandlerDevice
extends InputHandlerDevice {
    private TriggersMouseInputListener mouseListener;

    public MouseInputHandlerDevice() {
        super("mouse");
    }

    public synchronized TriggersMouseInputListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new TriggersMouseInputListener();
            this.mouseListener.activate();
        }
        return this.mouseListener;
    }

    protected void createTriggers(InputActionInterface inputActionInterface, int n, int n2, boolean bl, InputHandler inputHandler) {
        int n3;
        int n4;
        int n5;
        if (n2 != -1) {
            n5 = n2 == Integer.MIN_VALUE ? 0 : n2;
            n4 = n2 == Integer.MIN_VALUE ? MouseInput.get().getButtonCount() - 1 : n2;
            for (n3 = n5; n3 <= n4; ++n3) {
                new MouseButtonTrigger(inputHandler, MouseInput.get().getButtonName(n3), inputActionInterface, n3, bl);
            }
        }
        if (n != -1) {
            n5 = n == Integer.MIN_VALUE ? 0 : n;
            n4 = n == Integer.MIN_VALUE ? 2 : n;
            for (n3 = n5; n3 <= n4; ++n3) {
                String string;
                switch (n3) {
                    case 0: {
                        string = "X Axis";
                        break;
                    }
                    case 1: {
                        string = "Y Axis";
                        break;
                    }
                    case 2: {
                        string = "Wheel";
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                new MouseAxisTrigger(inputHandler, string, inputActionInterface, n3, bl);
            }
        }
    }

    protected class MouseAxisTrigger
    extends ActionTrigger {
        private int axis;
        private float delta;
        private float position;

        public MouseAxisTrigger(InputHandler inputHandler, String string, InputActionInterface inputActionInterface, int n, boolean bl) {
            super(inputHandler, string, inputActionInterface, bl);
            this.axis = n;
            MouseInputHandlerDevice.this.getMouseListener().add(this);
            if (bl) {
                if (n == 0) {
                    this.position = (float)MouseInput.get().getXAbsolute() / (float)DisplaySystem.getDisplaySystem().getWidth();
                } else if (n == 1) {
                    this.position = (float)MouseInput.get().getYAbsolute() / (float)DisplaySystem.getDisplaySystem().getHeight();
                }
                this.activate();
            }
        }

        protected void remove() {
            super.remove();
            MouseInputHandlerDevice.this.getMouseListener().remove(this);
        }

        protected void putTriggerInfo(InputActionEvent inputActionEvent, int n) {
            super.putTriggerInfo(inputActionEvent, n);
            inputActionEvent.setTriggerIndex(this.axis);
            inputActionEvent.setTriggerDelta(this.delta);
            inputActionEvent.setTriggerPosition(this.position);
        }

        protected String getDeviceName() {
            return "mouse";
        }

        public void checkActivation(char c, int n, float f, float f2, boolean bl, Object object) {
            if (n == this.axis) {
                this.delta = f2;
                this.position = f;
                if (!this.allowRepeats) {
                    this.activate();
                }
            }
        }
    }

    protected class MouseButtonTrigger
    extends ActionTrigger {
        private int button;
        private boolean pressed;

        public MouseButtonTrigger(InputHandler inputHandler, String string, InputActionInterface inputActionInterface, int n, boolean bl) {
            super(inputHandler, string, inputActionInterface, bl);
            this.button = n;
            MouseInputHandlerDevice.this.getMouseListener().add(this);
        }

        protected void remove() {
            super.remove();
            MouseInputHandlerDevice.this.getMouseListener().remove(this);
        }

        protected void putTriggerInfo(InputActionEvent inputActionEvent, int n) {
            char c;
            super.putTriggerInfo(inputActionEvent, n);
            inputActionEvent.setTriggerIndex(this.button);
            inputActionEvent.setTriggerPressed(this.pressed);
            switch (this.button) {
                case 0: {
                    c = 'L';
                    break;
                }
                case 1: {
                    c = 'R';
                    break;
                }
                case 2: {
                    c = 'M';
                    break;
                }
                default: {
                    c = (char)(97 + this.button - 3);
                }
            }
            inputActionEvent.setTriggerCharacter(c);
        }

        protected String getDeviceName() {
            return "mouse";
        }

        public void checkActivation(char c, int n, float f, float f2, boolean bl, Object object) {
            if (n == this.button) {
                if (this.allowRepeats) {
                    if (bl) {
                        this.pressed = true;
                        this.activate();
                    } else {
                        this.deactivate();
                    }
                } else {
                    this.pressed = bl;
                    this.activate();
                }
            }
        }
    }
}

