/*
 * Decompiled with CFR 0.152.
 */
package com.jme.intersection;

import com.jme.math.FastMath;
import com.jme.math.Ray;
import com.jme.math.Vector3f;

public class Distance {
    private Distance() {
    }

    public static float distance(Vector3f vector3f, Vector3f vector3f2) {
        return FastMath.sqrt(Distance.distanceSquared(vector3f, vector3f2));
    }

    public static float distanceSquared(Vector3f vector3f, Vector3f vector3f2) {
        return (vector3f.x - vector3f2.x) * (vector3f.x - vector3f2.x) + (vector3f.y - vector3f2.y) * (vector3f.y - vector3f2.y) + (vector3f.z - vector3f2.z) * (vector3f.z - vector3f2.z);
    }

    public static float distance(Vector3f vector3f, Ray ray) {
        Vector3f vector3f2 = vector3f.subtract(ray.getOrigin());
        float f = vector3f2.dot(ray.getDirection());
        if ((double)f <= 0.0) {
            f = 0.0f;
        } else {
            vector3f2.subtractLocal(ray.getDirection().mult(f /= ray.getDirection().lengthSquared()));
        }
        return vector3f2.length();
    }
}

