/*
 * Decompiled with CFR 0.152.
 */
package com.jme.intersection;

import com.jme.bounding.BoundingSphere;
import com.jme.math.Line;
import com.jme.math.Plane;
import com.jme.math.Vector3f;

public class IntersectionSphere {
    private IntersectionSphere() {
    }

    public static boolean intersection(Line line, BoundingSphere boundingSphere, Vector3f vector3f, float f) {
        Vector3f vector3f2 = boundingSphere.getCenter().subtract(line.getOrigin());
        float f2 = line.getDirection().dot(vector3f);
        float f3 = line.getDirection().dot(line.getDirection());
        float f4 = vector3f.dot(vector3f);
        float f5 = vector3f.dot(vector3f2);
        float f6 = line.getDirection().dot(vector3f2);
        float f7 = vector3f2.dot(vector3f2);
        float f8 = f3 * boundingSphere.getRadius() * boundingSphere.getRadius();
        float f9 = f3 * f4 - f2 * f2;
        float f10 = f3 * f5 - f6 * f2;
        float f11 = f3 * f7 - f6 * f6;
        if (f9 > 0.0f) {
            float f12 = -f10 / f9;
            if (f12 < 0.0f) {
                return f11 <= f8;
            }
            if (f12 > f) {
                return f * (f9 * f + 2.0f * f10) + f11 <= f8;
            }
            return f12 * (f9 * f12 + 2.0f * f10) + f11 <= f8;
        }
        return f11 <= f8;
    }

    public static boolean intersection(Plane plane, BoundingSphere boundingSphere, Vector3f vector3f, float f) {
        float f2 = plane.getNormal().dot(boundingSphere.getCenter()) - plane.getConstant();
        if (f2 > boundingSphere.getRadius()) {
            float f3 = plane.getNormal().dot(vector3f);
            return boundingSphere.getRadius() - f2 / f3 < f;
        }
        if (f2 < -boundingSphere.getRadius()) {
            float f4 = plane.getNormal().dot(vector3f);
            return -(boundingSphere.getRadius() + f2) / f4 < f;
        }
        return true;
    }

    public static boolean intersection(BoundingSphere boundingSphere, BoundingSphere boundingSphere2, Vector3f vector3f, Vector3f vector3f2, float f) {
        float f2;
        Vector3f vector3f3 = vector3f2.subtract(vector3f);
        float f3 = vector3f3.lengthSquared();
        Vector3f vector3f4 = boundingSphere2.getCenter().subtract(boundingSphere.getCenter());
        float f4 = vector3f4.lengthSquared();
        float f5 = boundingSphere.getRadius() + boundingSphere2.getRadius();
        float f6 = f5 * f5;
        if ((double)f3 > 0.0 && (double)(f2 = vector3f4.dot(vector3f3)) <= 0.0) {
            if (-f * f3 <= f2) {
                return f3 * f4 - f2 * f2 <= f3 * f6;
            }
            return (double)f * ((double)(f * f3) + 2.0 * (double)f2) + (double)f4 <= (double)f6;
        }
        return f4 <= f6;
    }
}

