/*
 * Decompiled with CFR 0.152.
 */
package com.jme.intersection;

import com.jme.intersection.IntersectionRecord;
import com.jme.math.Ray;
import com.jme.scene.batch.GeomBatch;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickData {
    private Ray ray;
    private GeomBatch targetMesh;
    private ArrayList<Integer> targetTris;
    private float distance;

    public PickData(Ray ray, GeomBatch geomBatch, boolean bl) {
        this(ray, geomBatch, null, bl);
    }

    public PickData(Ray ray, GeomBatch geomBatch, ArrayList<Integer> arrayList, boolean bl) {
        this.ray = ray;
        this.targetMesh = geomBatch;
        this.targetTris = arrayList;
        if (bl) {
            this.distance = this.calculateDistance();
        }
    }

    public GeomBatch getTargetMesh() {
        return this.targetMesh;
    }

    public void setTargetMesh(GeomBatch geomBatch) {
        this.targetMesh = geomBatch;
    }

    public ArrayList<Integer> getTargetTris() {
        return this.targetTris;
    }

    public void setTargetTris(ArrayList<Integer> arrayList) {
        this.targetTris = arrayList;
    }

    public Ray getRay() {
        return this.ray;
    }

    public void setRay(Ray ray) {
        this.ray = ray;
    }

    public float getDistance() {
        return this.distance;
    }

    protected float calculateDistance() {
        IntersectionRecord intersectionRecord = this.targetMesh.getWorldBound().intersectsWhere(this.ray);
        return intersectionRecord.getClosestDistance();
    }
}

