/*
 * Decompiled with CFR 0.152.
 */
package com.jme.intersection;

import com.jme.intersection.PickData;
import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.LoggingSystem;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrianglePickData
extends PickData {
    private Vector3f[] worldTriangle;
    private Vector3f intersectionPoint;
    private Quaternion worldRotation;
    private Vector3f worldScale;
    private Vector3f worldTranslation;

    public TrianglePickData(Ray ray, GeomBatch geomBatch, ArrayList<Integer> arrayList, boolean bl) {
        super(ray, geomBatch, arrayList, bl);
    }

    @Override
    protected float calculateDistance() {
        int n;
        int n2;
        ArrayList<Integer> arrayList = this.getTargetTris();
        if (arrayList.isEmpty()) {
            return Float.POSITIVE_INFINITY;
        }
        TriangleBatch triangleBatch = (TriangleBatch)this.getTargetMesh();
        triangleBatch.getParentGeom().updateWorldVectors();
        this.worldRotation = triangleBatch.getParentGeom().getWorldRotation();
        this.worldScale = triangleBatch.getParentGeom().getWorldScale();
        this.worldTranslation = triangleBatch.getParentGeom().getWorldTranslation();
        this.worldTriangle = new Vector3f[3];
        for (n2 = 0; n2 < 3; ++n2) {
            this.worldTriangle[n2] = new Vector3f();
        }
        this.intersectionPoint = new Vector3f();
        Vector3f[] vector3fArray = new Vector3f[3];
        float f = Float.MAX_VALUE;
        float[] fArray = new float[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            float f2;
            n = arrayList.get(n2);
            triangleBatch.getTriangle(n, vector3fArray);
            fArray[n2] = f2 = this.getDistanceToTriangle(vector3fArray);
            if (!(f2 > 0.0f) || !(f2 < f)) continue;
            f = f2;
        }
        n = 0;
        while (n == 0) {
            n = 1;
            for (int i = 0; i < fArray.length - 1; ++i) {
                if (!(fArray[i] > fArray[i + 1])) continue;
                n = 0;
                float f3 = fArray[i + 1];
                fArray[i + 1] = fArray[i];
                fArray[i] = f3;
                int n3 = arrayList.get(i + 1);
                arrayList.set(i + 1, arrayList.get(i));
                arrayList.set(i, n3);
            }
        }
        if (f == Float.MAX_VALUE) {
            LoggingSystem.getLogger().warning("Couldn't detect nearest triangle intersection!");
        } else {
            f = FastMath.sqrt(f);
        }
        return f;
    }

    private float getDistanceToTriangle(Vector3f[] vector3fArray) {
        for (int i = 0; i < 3; ++i) {
            this.worldRotation.mult(vector3fArray[i], this.worldTriangle[i]).multLocal(this.worldScale).addLocal(this.worldTranslation);
        }
        Ray ray = this.getRay();
        if (ray.intersectWhere(this.worldTriangle[0], this.worldTriangle[1], this.worldTriangle[2], this.intersectionPoint)) {
            return ray.getOrigin().distanceSquared(this.intersectionPoint);
        }
        return Float.MAX_VALUE;
    }
}

