/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.bounding.BoundingSphere;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.LightManagement;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.shape.Sphere;
import junit.framework.TestCase;

public class LightManagementTest
extends TestCase {
    public void testQuickSort() {
        LightManagement lightStateCreator = new LightManagement();
        SpotLight a = new SpotLight();
        lightStateCreator.addLight(a);
        SpotLight b = new SpotLight();
        lightStateCreator.addLight(b);
        SpotLight c = new SpotLight();
        lightStateCreator.addLight(c);
        SpotLight spot1 = new SpotLight();
        spot1.setAttenuate(true);
        spot1.setLocation(new Vector3f(2.0f, 0.0f, 0.0f));
        spot1.setDirection(new Vector3f(0.0f, 0.5f, 0.0f));
        spot1.setLinear(2.0f);
        lightStateCreator.addLight(spot1);
        lightStateCreator.addLight(new DirectionalLight());
        lightStateCreator.addLight(new SpotLight());
        lightStateCreator.addLight(new SpotLight());
        lightStateCreator.addLight(new DirectionalLight());
        lightStateCreator.addLight(new PointLight());
        for (int i = 0; i < lightStateCreator.numberOfLights(); ++i) {
            Light light = lightStateCreator.get(i);
            light.setEnabled(true);
        }
        LightManagementTest.assertEquals((String)"number of lights", (int)9, (int)lightStateCreator.numberOfLights());
        Node node = new Node("test");
        Sphere dummy = new Sphere(null, 5, 5, 1.0f);
        dummy.setModelBound(new BoundingSphere(1.0f, new Vector3f(1.0f, 0.0f, 0.0f)));
        node.attachChild(dummy);
        node.updateGeometricState(0.0f, true);
        lightStateCreator.sort(node);
        LightManagementTest.assertEquals((String)"number of lights", (int)9, (int)lightStateCreator.numberOfLights());
        float lastValue = Float.MAX_VALUE;
        int aIndex = -1;
        int bIndex = -1;
        int cIndex = -1;
        for (int i = 0; i < lightStateCreator.numberOfLights(); ++i) {
            Light light = lightStateCreator.get(i);
            float lightValue = lightStateCreator.getValueFor(light, node.getWorldBound());
            System.out.println(lightValue);
            LightManagementTest.assertTrue((String)"order wrong", (lightValue <= lastValue ? 1 : 0) != 0);
            if (light == a) {
                aIndex = i;
            }
            if (light == b) {
                bIndex = i;
            }
            if (light == c) {
                cIndex = i;
            }
            lastValue = lightValue;
        }
        LightManagementTest.assertEquals((String)"b after a", (int)(aIndex + 1), (int)bIndex);
        LightManagementTest.assertEquals((String)"c after b", (int)(bIndex + 1), (int)cIndex);
    }
}

