/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.util.LoggingSystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;

public class Plane
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    public static final int NO_SIDE = 0;
    public static final int POSITIVE_SIDE = 1;
    public static final int NEGATIVE_SIDE = 2;
    public Vector3f normal;
    public float constant;

    public Plane() {
        this.normal = new Vector3f();
    }

    public Plane(Vector3f vector3f, float f) {
        if (vector3f == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "Normal was null, created default normal.");
            vector3f = new Vector3f();
        }
        this.normal = vector3f;
        this.constant = f;
    }

    public void setNormal(Vector3f vector3f) {
        if (vector3f == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "Normal was null, created default normal.");
            vector3f = new Vector3f();
        }
        this.normal = vector3f;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void setConstant(float f) {
        this.constant = f;
    }

    public float getConstant() {
        return this.constant;
    }

    public float pseudoDistance(Vector3f vector3f) {
        return this.normal.x * vector3f.x + this.normal.y * vector3f.y + this.normal.z * vector3f.z - this.constant;
    }

    public int whichSide(Vector3f vector3f) {
        float f = this.pseudoDistance(vector3f);
        if (f < 0.0f) {
            return 2;
        }
        if (f > 0.0f) {
            return 1;
        }
        return 0;
    }

    public void setPlanePoints(Triangle triangle) {
        this.setPlanePoints(triangle.get(0), triangle.get(1), triangle.get(2));
    }

    public void setPlanePoints(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        this.normal.set(vector3f2).subtractLocal(vector3f);
        this.normal.crossLocal(vector3f3.x - vector3f.x, vector3f3.y - vector3f.y, vector3f3.z - vector3f.z).normalizeLocal();
        this.constant = -(this.normal.x * vector3f.x + this.normal.y * vector3f.y + this.normal.z * vector3f.z);
    }

    public String toString() {
        return "com.jme.math.Plane [Normal: " + this.normal + " - Constant: " + this.constant + "]";
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.normal, "normal", Vector3f.ZERO);
        outputCapsule.write(this.constant, "constant", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.normal = (Vector3f)inputCapsule.readSavable("normal", new Vector3f(Vector3f.ZERO));
        this.constant = inputCapsule.readFloat("constant", 0.0f);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

