/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math.spring;

import com.jme.math.Vector3f;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;

public class SpringPoint
implements Savable {
    public int index = 0;
    public float mass = 1.0f;
    public float invMass = 1.0f;
    public Vector3f position;
    public Vector3f oldPos;
    public Vector3f acceleration;

    public SpringPoint(Vector3f vector3f) {
        this.position = vector3f;
        this.oldPos = new Vector3f(vector3f);
        this.acceleration = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public void setMass(float f) {
        this.mass = f;
        this.invMass = f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY ? 0.0f : (f == 0.0f ? Float.POSITIVE_INFINITY : 1.0f / f);
    }

    public void update(float f) {
        float f2 = f * f;
        if (this.invMass == 0.0f) {
            return;
        }
        float f3 = this.position.x;
        float f4 = this.position.y;
        float f5 = this.position.z;
        this.position.set(2.0f * this.position.x - this.oldPos.x + this.acceleration.x * f2, 2.0f * this.position.y - this.oldPos.y + this.acceleration.y * f2, 2.0f * this.position.z - this.oldPos.z + this.acceleration.z * f2);
        this.oldPos.set(f3, f4, f5);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.index, "index", 0);
        outputCapsule.write(this.mass, "mass", 1.0f);
        outputCapsule.write(this.position, "position", Vector3f.ZERO);
        outputCapsule.write(this.acceleration, "acceleration", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.index = inputCapsule.readInt("index", 0);
        this.mass = inputCapsule.readFloat("mass", 1.0f);
        this.invMass = 1.0f / this.mass;
        this.position = (Vector3f)inputCapsule.readSavable("position", new Vector3f(Vector3f.ZERO));
        this.acceleration = (Vector3f)inputCapsule.readSavable("acceleration", new Vector3f(Vector3f.ZERO));
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

