/*
 * Decompiled with CFR 0.152.
 */
package com.jme.renderer.pass;

import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.renderer.pass.DefaultShadowGate;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.ShadowGate;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.shadow.MeshShadows;
import com.jme.scene.shadow.ShadowVolume;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.ColorMaskState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.StencilState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public class ShadowedRenderPass
extends Pass {
    private static final long serialVersionUID = 1L;
    public static final int ADDITIVE = 0;
    public static final int MODULATIVE = 1;
    protected ArrayList<Spatial> occluders = new ArrayList();
    protected Node volumeNode = new Node("Volumes");
    protected boolean initialised = false;
    protected Quad shadowQuad = new Quad("RenderForeground", 10.0f, 10.0f);
    protected ColorRGBA shadowColor = new ColorRGBA(0.2f, 0.2f, 0.2f, 0.1f);
    protected boolean renderVolume = false;
    protected boolean renderShadows = true;
    protected int lightingMethod = 0;
    protected IdentityHashMap<TriangleBatch, MeshShadows> meshes = new IdentityHashMap();
    protected ArrayList<TriangleBatch> occluderMeshes = new ArrayList();
    protected ArrayList<Light> shadowLights = new ArrayList();
    protected RenderState[] preStates = new RenderState[17];
    protected int quadWidth = -1;
    protected int quadHeight = -1;
    private ShadowGate shadowGate = new DefaultShadowGate();
    public static boolean rTexture = true;
    protected static ZBufferState zbufferWriteLE;
    protected static ZBufferState zbufferAlways;
    protected static ZBufferState forTesting;
    protected static ZBufferState forColorPassTesting;
    protected static StencilState noStencil;
    protected static StencilState stencilFrontFaces;
    protected static StencilState stencilBackFaces;
    protected static StencilState stencilDrawOnlyWhenSet;
    protected static StencilState stencilDrawWhenNotSet;
    protected static CullState cullFrontFace;
    protected static CullState cullBackFace;
    protected static CullState noCull;
    protected static TextureState noTexture;
    protected static LightState lights;
    protected static LightState noLights;
    public static AlphaState blended;
    public static AlphaState alphaBlended;
    public static AlphaState modblended;
    public static AlphaState blendTex;
    protected static ColorMaskState colorEnabled;
    protected static ColorMaskState colorDisabled;

    public void addOccluder(Spatial spatial) {
        this.occluders.add(spatial);
    }

    public void clearOccluders() {
        this.occluders.clear();
    }

    public boolean containsOccluder(Spatial spatial) {
        return this.occluders.contains(spatial);
    }

    public boolean removeOccluder(Spatial spatial) {
        return this.occluders.remove(spatial);
    }

    public int occludersSize() {
        return this.occluders.size();
    }

    public boolean getRenderVolume() {
        return this.renderVolume;
    }

    public void setRenderVolume(boolean bl) {
        this.renderVolume = bl;
    }

    public boolean getRenderShadows() {
        return this.renderShadows;
    }

    public void setRenderShadows(boolean bl) {
        this.renderShadows = bl;
    }

    public ColorRGBA getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(ColorRGBA colorRGBA) {
        if (colorRGBA == null) {
            throw new IllegalArgumentException("shadowColor must not be null!");
        }
        this.shadowColor = colorRGBA;
    }

    public int getLightingMethod() {
        return this.lightingMethod;
    }

    public void setLightingMethod(int n) {
        this.lightingMethod = n;
    }

    public void doRender(Renderer renderer) {
        Light light;
        this.init();
        if (!this.renderShadows) {
            this.renderScene(renderer);
            if (this.renderVolume) {
                this.getShadowLights();
                this.setupOccluderMeshes();
                this.generateVolumes();
                this.drawVolumes(renderer);
            }
            return;
        }
        this.getShadowLights();
        this.setupOccluderMeshes();
        if (this.occluderMeshes.size() == 0 || this.shadowLights.size() == 0) {
            this.renderScene(renderer);
            this.cleanup();
            return;
        }
        if (this.lightingMethod == 0) {
            this.maskShadowLights(6);
            this.saveEnforcedStates();
            this.context.enforceState(noTexture);
            this.renderScene(renderer);
            this.replaceEnforcedStates();
            this.unmaskShadowLights();
            renderer.setPolygonOffset(0.0f, -5.0f);
        } else {
            this.renderScene(renderer);
        }
        this.generateVolumes();
        int n = this.shadowLights.size();
        while (--n >= 0) {
            light = this.shadowLights.get(n);
            light.setEnabled(false);
        }
        n = this.shadowLights.size();
        while (--n >= 0) {
            light = this.shadowLights.get(n);
            renderer.clearStencilBuffer();
            light.setEnabled(true);
            this.saveEnforcedStates();
            this.context.enforceState(noTexture);
            this.context.enforceState(forTesting);
            this.context.enforceState(colorDisabled);
            this.context.enforceState(stencilFrontFaces);
            this.context.enforceState(cullBackFace);
            this.volumeNode.getChildren().clear();
            this.addShadowVolumes(light);
            this.volumeNode.updateWorldVectors();
            this.volumeNode.onDraw(renderer);
            this.context.enforceState(stencilBackFaces);
            this.context.enforceState(cullFrontFace);
            this.volumeNode.onDraw(renderer);
            this.context.enforceState(colorEnabled);
            this.context.enforceState(forColorPassTesting);
            this.context.enforceState(cullBackFace);
            if (this.lightingMethod == 0) {
                this.context.enforceState(lights);
                this.context.enforceState(blended);
                lights.detachAll();
                lights.attach(light);
                this.context.enforceState(stencilDrawWhenNotSet);
                this.renderScene(renderer);
            } else if (rTexture) {
                this.context.enforceState(modblended);
                this.context.enforceState(zbufferAlways);
                this.context.enforceState(cullBackFace);
                this.context.enforceState(noLights);
                this.context.enforceState(stencilDrawOnlyWhenSet);
                this.shadowColor.a = 1.0f - light.getAmbient().a;
                this.shadowQuad.setDefaultColor(this.shadowColor);
                renderer.setOrtho();
                this.resetShadowQuad(renderer);
                this.shadowQuad.draw(renderer);
                renderer.unsetOrtho();
            }
            light.setEnabled(false);
            this.replaceEnforcedStates();
        }
        n = this.shadowLights.size();
        while (--n >= 0) {
            light = this.shadowLights.get(n);
            light.setEnabled(true);
        }
        if (this.lightingMethod == 0 && rTexture) {
            this.saveEnforcedStates();
            this.context.enforceState(noStencil);
            this.context.enforceState(colorEnabled);
            this.context.enforceState(cullBackFace);
            this.context.enforceState(blendTex);
            this.renderScene(renderer);
            this.replaceEnforcedStates();
        }
        if (this.renderVolume) {
            this.drawVolumes(renderer);
        }
        this.cleanup();
    }

    protected void cleanup() {
        this.occluderMeshes.clear();
        this.shadowLights.clear();
    }

    protected void maskShadowLights(int n) {
        int n2 = this.shadowLights.size();
        while (--n2 >= 0) {
            Light light = this.shadowLights.get(n2);
            light.pushLightMask();
            light.setLightMask(n);
        }
    }

    protected void unmaskShadowLights() {
        int n = this.shadowLights.size();
        while (--n >= 0) {
            Light light = this.shadowLights.get(n);
            light.popLightMask();
        }
    }

    protected void renderScene(Renderer renderer) {
        int n = this.spatials.size();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = (Spatial)this.spatials.get(i);
            spatial.onDraw(renderer);
        }
        renderer.renderQueue();
    }

    protected void getShadowLights() {
        if (this.shadowLights == null) {
            this.shadowLights = new ArrayList();
        }
        int n = this.occluders.size();
        while (--n >= 0) {
            this.getShadowLights(this.occluders.get(n));
        }
    }

    protected void getShadowLights(Spatial spatial) {
        SceneElement sceneElement;
        int n;
        Spatial spatial2;
        if ((spatial.getType() & 2) != 0) {
            spatial2 = (Geometry)spatial;
            int n2 = ((Geometry)spatial2).getBatchCount();
            for (n = 0; n < n2; ++n) {
                sceneElement = ((Geometry)spatial2).getBatch(n);
                LightState lightState = (LightState)sceneElement.states[3];
                if (lightState == null) continue;
                int n3 = lightState.getQuantity();
                while (--n3 >= 0) {
                    Light light = lightState.get(n3);
                    if (!light.isShadowCaster() || light.getType() != 0 && light.getType() != 1 || this.shadowLights.contains(light)) continue;
                    this.shadowLights.add(light);
                }
            }
        }
        if ((spatial.getType() & 1) != 0 && ((Node)(spatial2 = (Node)spatial)).getChildren() != null) {
            ArrayList<Spatial> arrayList = ((Node)spatial2).getChildren();
            n = arrayList.size();
            while (--n >= 0) {
                sceneElement = arrayList.get(n);
                this.getShadowLights((Spatial)sceneElement);
            }
        }
    }

    protected void setupOccluderMeshes() {
        if (this.occluderMeshes == null) {
            this.occluderMeshes = new ArrayList();
        }
        this.occluderMeshes.clear();
        int n = this.occluders.size();
        while (--n >= 0) {
            this.setupOccluderMeshes(this.occluders.get(n));
        }
        this.meshes.keySet().retainAll(this.occluderMeshes);
    }

    protected void setupOccluderMeshes(Spatial spatial) {
        if ((spatial.getType() & 4) != 0) {
            this.addOccluderBatches((TriMesh)spatial);
        } else if ((spatial.getType() & 1) != 0) {
            Node node = (Node)spatial;
            int n = node.getQuantity();
            for (int i = 0; i < n; ++i) {
                Spatial spatial2 = node.getChild(i);
                this.setupOccluderMeshes(spatial2);
            }
        }
    }

    private void addOccluderBatches(TriMesh triMesh) {
        int n = triMesh.getBatchCount();
        for (int i = 0; i < n; ++i) {
            TriangleBatch triangleBatch = triMesh.getBatch(i);
            if (!triangleBatch.isCastsShadows()) continue;
            this.occluderMeshes.add(triangleBatch);
        }
    }

    protected void saveEnforcedStates() {
        int n = 17;
        while (--n >= 0) {
            this.preStates[n] = this.context.enforcedStateList[n];
        }
    }

    protected void replaceEnforcedStates() {
        int n = 17;
        while (--n >= 0) {
            this.context.enforcedStateList[n] = this.preStates[n];
        }
    }

    protected void generateVolumes() {
        for (int i = 0; i < this.occluderMeshes.size(); ++i) {
            TriangleBatch triangleBatch = this.occluderMeshes.get(i);
            if (!this.shadowGate.shouldUpdateShadows(triangleBatch)) continue;
            if (!this.meshes.containsKey(triangleBatch)) {
                this.meshes.put(triangleBatch, new MeshShadows(triangleBatch));
            } else if ((triangleBatch.getLocks() & 8) != 0) continue;
            MeshShadows meshShadows = this.meshes.get(triangleBatch);
            meshShadows.createGeometry((LightState)triangleBatch.states[3]);
        }
    }

    protected void addShadowVolumes(Light light) {
        if (this.enabled) {
            int n = this.occluderMeshes.size();
            while (--n >= 0) {
                MeshShadows meshShadows;
                ShadowVolume shadowVolume;
                TriangleBatch triangleBatch = this.occluderMeshes.get(n);
                if (!this.shadowGate.shouldDrawShadows(triangleBatch) || (shadowVolume = (meshShadows = this.meshes.get(triangleBatch)).getShadowVolume(light)) == null) continue;
                this.volumeNode.getChildren().add(shadowVolume);
            }
        }
    }

    protected void drawVolumes(Renderer renderer) {
        Node node = new Node("renderVolume");
        node.setRenderState(cullBackFace);
        node.setRenderState(forTesting);
        node.setRenderState(colorEnabled);
        node.setRenderState(noStencil);
        node.setRenderState(alphaBlended);
        int n = this.occluderMeshes.size();
        while (--n >= 0) {
            TriangleBatch triangleBatch = this.occluderMeshes.get(n);
            MeshShadows meshShadows = this.meshes.get(triangleBatch);
            if (meshShadows == null) continue;
            ArrayList<ShadowVolume> arrayList = meshShadows.getVolumes();
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                ShadowVolume shadowVolume = arrayList.get(i);
                node.attachChild(shadowVolume);
                shadowVolume.setDefaultColor(new ColorRGBA(0.0f, 1.0f, 0.0f, 0.075f));
            }
        }
        node.updateRenderState();
        node.updateGeometricState(0.0f, true);
        node.onDraw(renderer);
    }

    protected void init() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        Renderer renderer = DisplaySystem.getDisplaySystem().getRenderer();
        zbufferWriteLE = renderer.createZBufferState();
        zbufferWriteLE.setWritable(true);
        zbufferWriteLE.setFunction(3);
        zbufferWriteLE.setEnabled(true);
        zbufferAlways = renderer.createZBufferState();
        zbufferAlways.setEnabled(false);
        zbufferAlways.setWritable(false);
        forTesting = renderer.createZBufferState();
        forTesting.setWritable(false);
        forTesting.setFunction(1);
        forTesting.setEnabled(true);
        forColorPassTesting = renderer.createZBufferState();
        forColorPassTesting.setWritable(false);
        forColorPassTesting.setFunction(3);
        forColorPassTesting.setEnabled(true);
        noStencil = renderer.createStencilState();
        noStencil.setEnabled(false);
        stencilFrontFaces = renderer.createStencilState();
        stencilFrontFaces.setEnabled(true);
        stencilFrontFaces.setStencilMask(-1);
        stencilFrontFaces.setStencilFunc(7);
        stencilFrontFaces.setStencilOpFail(0);
        stencilFrontFaces.setStencilOpZFail(0);
        stencilFrontFaces.setStencilOpZPass(3);
        stencilBackFaces = renderer.createStencilState();
        stencilBackFaces.setEnabled(true);
        stencilBackFaces.setStencilMask(-1);
        stencilBackFaces.setStencilFunc(7);
        stencilBackFaces.setStencilOpFail(0);
        stencilBackFaces.setStencilOpZFail(0);
        stencilBackFaces.setStencilOpZPass(4);
        stencilDrawOnlyWhenSet = renderer.createStencilState();
        stencilDrawOnlyWhenSet.setEnabled(true);
        stencilDrawOnlyWhenSet.setStencilMask(-1);
        stencilDrawOnlyWhenSet.setStencilFunc(6);
        stencilDrawOnlyWhenSet.setStencilOpFail(0);
        stencilDrawOnlyWhenSet.setStencilOpZFail(0);
        stencilDrawOnlyWhenSet.setStencilOpZPass(0);
        stencilDrawOnlyWhenSet.setStencilRef(0);
        stencilDrawWhenNotSet = renderer.createStencilState();
        stencilDrawWhenNotSet.setEnabled(true);
        stencilDrawWhenNotSet.setStencilMask(-1);
        stencilDrawWhenNotSet.setStencilFunc(5);
        stencilDrawWhenNotSet.setStencilOpFail(0);
        stencilDrawWhenNotSet.setStencilOpZFail(0);
        stencilDrawWhenNotSet.setStencilOpZPass(0);
        stencilDrawWhenNotSet.setStencilRef(0);
        cullFrontFace = renderer.createCullState();
        cullFrontFace.setEnabled(true);
        cullFrontFace.setCullMode(1);
        noCull = renderer.createCullState();
        noCull.setEnabled(false);
        noLights = renderer.createLightState();
        noLights.setEnabled(false);
        cullBackFace = renderer.createCullState();
        cullBackFace.setEnabled(true);
        cullBackFace.setCullMode(2);
        blended = renderer.createAlphaState();
        blended.setEnabled(true);
        blended.setBlendEnabled(true);
        blended.setDstFunction(1);
        blended.setSrcFunction(2);
        alphaBlended = renderer.createAlphaState();
        alphaBlended.setEnabled(true);
        alphaBlended.setBlendEnabled(true);
        alphaBlended.setDstFunction(5);
        alphaBlended.setSrcFunction(1);
        modblended = renderer.createAlphaState();
        modblended.setEnabled(true);
        modblended.setBlendEnabled(true);
        modblended.setDstFunction(5);
        modblended.setSrcFunction(2);
        blendTex = renderer.createAlphaState();
        blendTex.setEnabled(true);
        blendTex.setBlendEnabled(true);
        blendTex.setDstFunction(0);
        blendTex.setSrcFunction(2);
        colorEnabled = renderer.createColorMaskState();
        colorEnabled.setAll(true);
        colorDisabled = renderer.createColorMaskState();
        colorDisabled.setAll(false);
        this.volumeNode.setRenderQueueMode(1);
        this.volumeNode.updateRenderState();
        this.volumeNode.attachChild(new Node());
        noTexture = renderer.createTextureState();
        noTexture.setEnabled(false);
        this.resetShadowQuad(renderer);
        lights = renderer.createLightState();
        lights.setEnabled(true);
        lights.setLightMask(9);
    }

    public void resetShadowQuad(Renderer renderer) {
        if (renderer.getWidth() == this.quadWidth && renderer.getHeight() == this.quadHeight) {
            return;
        }
        this.quadWidth = renderer.getWidth();
        this.quadHeight = renderer.getHeight();
        this.shadowQuad.resize(this.quadWidth, renderer.getHeight());
        this.shadowQuad.setLocalTranslation(new Vector3f(this.quadWidth >> 1, this.quadHeight >> 1, 0.0f));
        this.shadowQuad.setRenderQueueMode(1);
        this.shadowQuad.updateGeometricState(0.0f, true);
        this.shadowQuad.updateRenderState();
    }

    public ShadowGate getShadowGate() {
        return this.shadowGate;
    }

    public void setShadowGate(ShadowGate shadowGate) {
        this.shadowGate = shadowGate;
    }
}

