/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;

public class CompositeMesh
extends TriMesh
implements Serializable {
    protected IndexRange[] ranges;
    private int[] cachedTriangleIndices;
    private static final long serialVersionUID = 1L;

    public CompositeMesh() {
    }

    public CompositeMesh(String string) {
        super(string);
    }

    public CompositeMesh(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, IntBuffer intBuffer, IndexRange[] indexRangeArray) {
        super(string);
        this.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, intBuffer, indexRangeArray);
        LoggingSystem.getLogger().log(Level.INFO, "CompositeMesh created.");
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, IntBuffer intBuffer, IndexRange[] indexRangeArray) {
        super.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, intBuffer);
        if (indexRangeArray == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "Index ranges may not be null.");
            throw new JmeException("Index ranges may not be null.");
        }
        this.ranges = indexRangeArray;
    }

    public int getType() {
        return 134;
    }

    public IndexRange[] getIndexRanges() {
        return this.ranges;
    }

    public void setIndexRanges(IndexRange[] indexRangeArray) {
        this.ranges = indexRangeArray;
        this.cachedTriangleIndices = null;
    }

    public void draw(Renderer renderer) {
        if (!renderer.isProcessingQueue() && renderer.checkAndAdd(this)) {
            return;
        }
        renderer.draw(this);
    }

    public int getTriangleQuantity() {
        if (this.cachedTriangleIndices != null) {
            return this.cachedTriangleIndices.length / 3;
        }
        int n = 0;
        for (int i = 0; i < this.ranges.length; ++i) {
            n = (int)((long)n + this.ranges[i].getTriangleQuantityEquivalent());
        }
        return n;
    }

    public static IndexRange createTriangleRange(int n) {
        if (n % 3 != 0) {
            throw new IllegalArgumentException("Triangle range has to be multiple of 3 vertices");
        }
        return new IndexRange(1, n);
    }

    public static IndexRange createTriangleStrip(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Triangle strip cannot be shorter than 3 vertices");
        }
        return new IndexRange(2, n);
    }

    public static IndexRange createTriangleFan(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Triangle fan cannot be shorter than 3 vertices");
        }
        return new IndexRange(3, n);
    }

    public static IndexRange createQuadRange(int n) {
        if (n % 4 != 0) {
            throw new IllegalArgumentException("Quad range has to be multiple of 4 vertices");
        }
        return new IndexRange(4, n);
    }

    public static IndexRange createQuadStrip(int n) {
        if (n < 4) {
            throw new IllegalArgumentException("Quad strip range cannot be shorter than 4 vertices");
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Quad strip range has to be multiple of 2 vertices");
        }
        return new IndexRange(5, n);
    }

    protected void recreateTriangleIndices() {
        TriangleBatch triangleBatch = this.getBatch(0);
        this.cachedTriangleIndices = new int[this.getTriangleQuantity() * 3];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.ranges.length; ++i) {
            IndexRange indexRange = this.ranges[i];
            switch (indexRange.getKind()) {
                case 1: {
                    int n3;
                    for (n3 = 0; n3 < indexRange.getCount(); ++n3) {
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n3 + n);
                    }
                    break;
                }
                case 2: {
                    int n3;
                    for (n3 = 2; n3 < indexRange.getCount(); ++n3) {
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 - 2);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 - 1);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3);
                    }
                    break;
                }
                case 3: {
                    int n3;
                    for (n3 = 2; n3 < indexRange.getCount(); ++n3) {
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 - 1);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3);
                    }
                    break;
                }
                case 4: {
                    int n3;
                    for (n3 = 0; n3 < indexRange.getCount(); n3 += 4) {
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 + 1);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 + 2);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 + 2);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 + 3);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3);
                    }
                    break;
                }
                case 5: {
                    int n3;
                    for (n3 = 2; n3 < indexRange.getCount(); n3 += 2) {
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 - 2);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 - 1);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 + 1);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3);
                        this.cachedTriangleIndices[n2++] = triangleBatch.getIndexBuffer().get(n + n3 - 1);
                    }
                    break;
                }
                default: {
                    throw new JmeException("Unknown index range type " + this.ranges[i].getKind());
                }
            }
            n += indexRange.getCount();
        }
    }

    public Vector3f[] getMeshAsTrianglesVertices() {
        if (this.cachedTriangleIndices == null) {
            this.recreateTriangleIndices();
        }
        TriangleBatch triangleBatch = this.getBatch(0);
        Vector3f[] vector3fArray = BufferUtils.getVector3Array(triangleBatch.getVertexBuffer());
        Vector3f[] vector3fArray2 = new Vector3f[this.cachedTriangleIndices.length];
        for (int i = 0; i < vector3fArray2.length; ++i) {
            vector3fArray2[i] = vector3fArray[this.cachedTriangleIndices[i]];
        }
        return vector3fArray2;
    }

    public void getTriangle(int n, int[] nArray) {
        int n2 = n * 3;
        if (this.cachedTriangleIndices == null) {
            this.recreateTriangleIndices();
        }
        if (n < 0 || n2 >= this.cachedTriangleIndices.length) {
            return;
        }
        nArray[0] = this.cachedTriangleIndices[n2 + 0];
        nArray[1] = this.cachedTriangleIndices[n2 + 1];
        nArray[2] = this.cachedTriangleIndices[n2 + 2];
    }

    public void getTriangle(int n, Vector3f[] vector3fArray) {
        TriangleBatch triangleBatch = this.getBatch(0);
        int n2 = n * 3;
        if (this.cachedTriangleIndices == null) {
            this.recreateTriangleIndices();
        }
        if (n < 0 || n2 >= this.cachedTriangleIndices.length) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            vector3fArray[i] = new Vector3f();
            BufferUtils.populateFromBuffer(vector3fArray[i], triangleBatch.getVertexBuffer(), this.cachedTriangleIndices[n2++]);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.ranges, "ranges", null);
        outputCapsule.write(this.cachedTriangleIndices, "cachedTriangleIndices", (int[])null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        Savable[] savableArray = inputCapsule.readSavableArray("ranges", null);
        if (savableArray != null) {
            this.ranges = new IndexRange[savableArray.length];
            for (int i = 0; i < savableArray.length; ++i) {
                this.ranges[i] = (IndexRange)savableArray[i];
            }
        }
        this.cachedTriangleIndices = inputCapsule.readIntArray("cachedTriangleIndices", null);
    }

    public static class IndexRange
    implements Serializable,
    Savable {
        public static final int TRIANGLES = 1;
        public static final int TRIANGLE_STRIP = 2;
        public static final int TRIANGLE_FAN = 3;
        public static final int QUADS = 4;
        public static final int QUAD_STRIP = 5;
        private int kind;
        private int count;
        private String[] KIND_NAMES = new String[]{null, "TRIANGLES", "TRIANGLE_STRIP", "TRIANGLE_FAN", "QUADS", "QUAD_STRIP"};
        private static final long serialVersionUID = 1L;

        public IndexRange() {
        }

        IndexRange(int n, int n2) {
            this.kind = n;
            this.count = n2;
        }

        public int getCount() {
            return this.count;
        }

        public int getKind() {
            return this.kind;
        }

        public long getTriangleQuantityEquivalent() {
            switch (this.kind) {
                case 1: {
                    return this.count / 3;
                }
                case 2: {
                    return this.count - 2;
                }
                case 3: {
                    return this.count - 2;
                }
                case 4: {
                    return this.count / 4 * 2;
                }
                case 5: {
                    return (this.count - 2) / 2 * 2;
                }
            }
            throw new JmeException("Unknown kind of index range");
        }

        public String toString() {
            return "IndexRange kind=" + this.KIND_NAMES[this.getKind()] + " count=" + this.getCount();
        }

        public void write(JMEExporter jMEExporter) throws IOException {
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.kind, "kind", 0);
            outputCapsule.write(this.count, "count", 0);
        }

        public void read(JMEImporter jMEImporter) throws IOException {
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            this.kind = inputCapsule.readInt("kind", 0);
            this.count = inputCapsule.readInt("count", 0);
        }

        public Class getClassTag() {
            return this.getClass();
        }
    }
}

