/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.math.Vector3f;
import com.jme.scene.SwitchModel;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class DistanceSwitchModel
implements SwitchModel {
    private float[] modelMin;
    private float[] modelMax;
    private float[] worldMin;
    private float[] worldMax;
    private int numChildren;
    private float worldScaleSquared;
    private Vector3f diff;

    public DistanceSwitchModel() {
    }

    public DistanceSwitchModel(int n) {
        this.numChildren = n;
        this.modelMin = new float[n];
        this.modelMax = new float[n];
        this.worldMin = new float[n];
        this.worldMax = new float[n];
    }

    public void setModelMinDistance(int n, float f) {
        this.modelMin[n] = f;
    }

    public void setModelMaxDistance(int n, float f) {
        this.modelMax[n] = f;
    }

    public void setModelDistance(int n, float f, float f2) {
        this.modelMin[n] = f;
        this.modelMax[n] = f2;
    }

    public void set(Object object) {
        if (object instanceof Float) {
            this.worldScaleSquared = ((Float)object).floatValue();
            for (int i = 0; i < this.numChildren; ++i) {
                this.worldMin[i] = this.worldScaleSquared * this.modelMin[i] * this.modelMin[i];
                this.worldMax[i] = this.worldScaleSquared * this.modelMax[i] * this.modelMax[i];
            }
        } else if (object instanceof Vector3f) {
            this.diff = (Vector3f)object;
        } else {
            throw new JmeException("Invalid value for set method.");
        }
    }

    public int getSwitchChild() {
        if (this.numChildren > 0) {
            float f = this.diff.lengthSquared();
            for (int i = 0; i < this.numChildren; ++i) {
                if (!(this.worldMin[i] <= f) || !(f < this.worldMax[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.modelMin, "modelMin", new float[0]);
        outputCapsule.write(this.modelMax, "modelMax", new float[0]);
        outputCapsule.write(this.worldMin, "worldMin", new float[0]);
        outputCapsule.write(this.worldMax, "worldMax", new float[0]);
        outputCapsule.write(this.numChildren, "numChildren", 0);
        outputCapsule.write(this.worldScaleSquared, "worldScaleSquared", 0.0f);
        outputCapsule.write(this.diff, "diff", Vector3f.ZERO);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.modelMin = inputCapsule.readFloatArray("modelMin", new float[0]);
        this.modelMax = inputCapsule.readFloatArray("modelMax", new float[0]);
        this.worldMin = inputCapsule.readFloatArray("worldMin", new float[0]);
        this.worldMax = inputCapsule.readFloatArray("worldMax", new float[0]);
        this.numChildren = inputCapsule.readInt("numChildren", 0);
        this.worldScaleSquared = inputCapsule.readFloat("worldScaleSquared", 0.0f);
        this.diff = (Vector3f)inputCapsule.readSavable("diff", new Vector3f(Vector3f.ZERO));
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

