/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.intersection.CollisionResults;
import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Spatial;
import com.jme.scene.batch.LineBatch;
import com.jme.util.LoggingSystem;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Level;

public class Line
extends Geometry {
    private static final long serialVersionUID = 1L;
    public static final int SEGMENTS = 0;
    public static final int CONNECTED = 1;
    public static final int LOOP = 2;

    public Line() {
    }

    public Line(String string) {
        super(string);
    }

    public Line(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        super(string, floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.generateIndices(0);
        LoggingSystem.getLogger().log(Level.INFO, "Line created.");
    }

    public Line(String string, Vector3f[] vector3fArray, Vector3f[] vector3fArray2, ColorRGBA[] colorRGBAArray, Vector2f[] vector2fArray) {
        super(string, BufferUtils.createFloatBuffer(vector3fArray), BufferUtils.createFloatBuffer(vector3fArray2), BufferUtils.createFloatBuffer(colorRGBAArray), BufferUtils.createFloatBuffer(vector2fArray));
        this.generateIndices(0);
        LoggingSystem.getLogger().log(Level.INFO, "Line created.");
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        super.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.generateIndices(0);
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, int n) {
        super.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, n);
        this.generateIndices(n);
    }

    protected void setupBatchList() {
        this.batchList = new ArrayList(1);
        LineBatch lineBatch = new LineBatch();
        lineBatch.setParentGeom(this);
        this.batchList.add(lineBatch);
    }

    public LineBatch getBatch(int n) {
        return (LineBatch)this.batchList.get(n);
    }

    public void generateIndices(int n) {
        LineBatch lineBatch = this.getBatch(n);
        if (lineBatch.getIndexBuffer() == null || lineBatch.getIndexBuffer().limit() != lineBatch.getVertexCount()) {
            lineBatch.setIndexBuffer(BufferUtils.createIntBuffer(lineBatch.getVertexCount()));
        } else {
            lineBatch.getIndexBuffer().rewind();
        }
        for (int i = 0; i < lineBatch.getVertexCount(); ++i) {
            lineBatch.getIndexBuffer().put(i);
        }
    }

    public IntBuffer getIndexBuffer() {
        return this.getBatch(0).getIndexBuffer();
    }

    public void setIndexBuffer(IntBuffer intBuffer) {
        this.getBatch(0).setIndexBuffer(intBuffer);
    }

    public boolean isAntialiased() {
        return this.getBatch(0).isAntialiased();
    }

    public void setAntialiased(boolean bl) {
        this.getBatch(0).setAntialiased(bl);
    }

    public int getMode() {
        return this.getBatch(0).getMode();
    }

    public void setMode(int n) {
        this.getBatch(0).setMode(n);
    }

    public float getLineWidth() {
        return this.getBatch(0).getLineWidth();
    }

    public void setLineWidth(float f) {
        this.getBatch(0).setLineWidth(f);
    }

    public short getStipplePattern() {
        return this.getBatch(0).getStipplePattern();
    }

    public void setStipplePattern(short s) {
        this.getBatch(0).setStipplePattern(s);
    }

    public int getStippleFactor() {
        return this.getBatch(0).getStippleFactor();
    }

    public void setStippleFactor(int n) {
        this.getBatch(0).setStippleFactor(n);
    }

    public IntBuffer getIndexBuffer(int n) {
        return this.getBatch(n).getIndexBuffer();
    }

    public void setIndexBuffer(IntBuffer intBuffer, int n) {
        this.getBatch(n).setIndexBuffer(intBuffer);
    }

    public boolean isAntialiased(int n) {
        return this.getBatch(n).isAntialiased();
    }

    public void setAntialiased(boolean bl, int n) {
        this.getBatch(n).setAntialiased(bl);
    }

    public int getMode(int n) {
        return this.getBatch(n).getMode();
    }

    public void setMode(int n, int n2) {
        this.getBatch(n2).setMode(n);
    }

    public float getLineWidth(int n) {
        return this.getBatch(n).getLineWidth();
    }

    public void setLineWidth(float f, int n) {
        this.getBatch(n).setLineWidth(f);
    }

    public short getStipplePattern(int n) {
        return this.getBatch(n).getStipplePattern();
    }

    public void setStipplePattern(short s, int n) {
        this.getBatch(n).setStipplePattern(s);
    }

    public int getStippleFactor(int n) {
        return this.getBatch(n).getStippleFactor();
    }

    public void setStippleFactor(int n, int n2) {
        this.getBatch(n2).setStippleFactor(n);
    }

    public void draw(Renderer renderer) {
        LineBatch lineBatch;
        if (this.getBatchCount() == 1 && (lineBatch = this.getBatch(0)) != null && lineBatch.isEnabled()) {
            lineBatch.setLastFrustumIntersection(this.frustrumIntersects);
            lineBatch.draw(renderer);
            return;
        }
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            lineBatch = this.getBatch(i);
            if (lineBatch == null || !lineBatch.isEnabled()) continue;
            lineBatch.onDraw(renderer);
        }
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        return false;
    }

    public void appendCircle(float f, float f2, float f3, int n, boolean bl) {
        int n2 = n * 2 * 3;
        FloatBuffer floatBuffer = BufferUtils.ensureLargeEnough(this.getVertexBuffer(0), n2);
        this.setVertexBuffer(0, floatBuffer);
        FloatBuffer floatBuffer2 = BufferUtils.ensureLargeEnough(this.getNormalBuffer(0), n2);
        this.setNormalBuffer(0, floatBuffer2);
        float f4 = 0.0f;
        float f5 = (float)Math.PI * 2 / (float)n;
        for (int i = 0; i < n; ++i) {
            float f6 = FastMath.cos(bl ? -f4 : f4) * f;
            float f7 = FastMath.sin(bl ? -f4 : f4) * f;
            if (i > 0) {
                floatBuffer.put(f6 + f2).put(f7 + f3).put(0.0f);
                floatBuffer2.put(f6).put(f7).put(0.0f);
            }
            floatBuffer.put(f6 + f2).put(f7 + f3).put(0.0f);
            floatBuffer2.put(f6).put(f7).put(0.0f);
            f4 += f5;
        }
        floatBuffer.put(f + f2).put(f3).put(0.0f);
        floatBuffer2.put(f).put(0.0f).put(0.0f);
        this.generateIndices(0);
    }
}

